/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.exception;

import org.squirrelframework.foundation.exception.ErrorCodes;

public class SquirrelRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -4324278329515258777L;
    private int errorCodeId;
    private Throwable targetException;
    private String errorMessage;

    public SquirrelRuntimeException(ErrorCodes errorCodes) {
        this.errorCodeId = errorCodes.getCode();
        this.errorMessage = String.format("%08d : %s.", this.getErrorCodeId(), errorCodes.getDescription());
    }

    public SquirrelRuntimeException(Throwable throwable, ErrorCodes errorCodes) {
        this(errorCodes);
        this.targetException = throwable;
    }

    public SquirrelRuntimeException(ErrorCodes errorCodes, Object ... objectArray) {
        this.errorCodeId = errorCodes.getCode();
        this.errorMessage = String.format("%08d : %s.", this.getErrorCodeId(), String.format(errorCodes.getDescription(), objectArray));
    }

    public SquirrelRuntimeException(Throwable throwable, ErrorCodes errorCodes, Object ... objectArray) {
        this(errorCodes, objectArray);
        this.targetException = throwable;
    }

    public int getErrorCodeId() {
        return this.errorCodeId;
    }

    public Throwable getTargetException() {
        return this.targetException;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }
}

