/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import java.util.List;
import org.squirrelframework.foundation.fsm.AnonymousCondition;
import org.squirrelframework.foundation.fsm.Condition;

public class Conditions {
    public static <C> boolean isSatified(Condition<C> condition, C c) {
        return condition != null && c != null && condition.isSatisfied(c);
    }

    public static <C> boolean isNotSatified(Condition<C> condition, C c) {
        return condition == null || c == null || !condition.isSatisfied(c);
    }

    public static <C> Condition<C> always() {
        return new Always();
    }

    public static <C> Condition<C> never() {
        return new Never();
    }

    public static <C> Condition<C> and(final Condition<C> condition, final Condition<C> condition2) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C c) {
                return condition.isSatisfied(c) && condition2.isSatisfied(c);
            }

            @Override
            public String name() {
                return condition.name() + "And" + condition2.name();
            }
        };
    }

    public static <C> Condition<C> and(final List<Condition<C>> list) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C c) {
                for (Condition condition : list) {
                    if (condition.isSatisfied(c)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String name() {
                String string = null;
                for (Condition condition : list) {
                    if (string == null) {
                        string = condition.name();
                        continue;
                    }
                    string = string + "And" + condition.name();
                }
                return string;
            }
        };
    }

    public static <C> Condition<C> or(final Condition<C> condition, final Condition<C> condition2) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C c) {
                return condition.isSatisfied(c) || condition2.isSatisfied(c);
            }

            @Override
            public String name() {
                return condition.name() + "Or" + condition2.name();
            }
        };
    }

    public static <C> Condition<C> or(final List<Condition<C>> list) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C c) {
                for (Condition condition : list) {
                    if (!condition.isSatisfied(c)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String name() {
                String string = null;
                for (Condition condition : list) {
                    if (string == null) {
                        string = condition.name();
                        continue;
                    }
                    string = string + "Or" + condition.name();
                }
                return string;
            }
        };
    }

    public static <C> Condition<C> not(final Condition<C> condition) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C c) {
                return !condition.isSatisfied(c);
            }

            @Override
            public String name() {
                return "Not" + condition.name();
            }
        };
    }

    public static <C> Condition<C> xor(final Condition<C> condition, final Condition<C> condition2) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C c) {
                return condition.isSatisfied(c) ^ condition2.isSatisfied(c);
            }

            @Override
            public String name() {
                return condition.name() + "Xor" + condition2.name();
            }
        };
    }

    public static class Never<C>
    extends AnonymousCondition<C> {
        @Override
        public boolean isSatisfied(C c) {
            return false;
        }
    }

    public static class Always<C>
    extends AnonymousCondition<C> {
        @Override
        public boolean isSatisfied(C c) {
            return true;
        }
    }
}

