/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import com.google.common.base.Stopwatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.squirrelframework.foundation.exception.TransitionException;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.annotation.OnActionExecException;
import org.squirrelframework.foundation.fsm.annotation.OnAfterActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnBeforeActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineStart;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineTerminate;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionBegin;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionComplete;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionDecline;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionException;

public class StateMachineLogger {
    private static final Logger logger = LogManager.getLogger(StateMachineLogger.class);
    private Stopwatch transitionWatch;
    private Stopwatch actionWatch;
    private final StateMachine<?, ?, ?, ?> stateMachine;
    private final String stateMachineLabel;

    public StateMachineLogger(StateMachine<?, ?, ?, ?> stateMachine) {
        this.stateMachine = stateMachine;
        this.stateMachineLabel = stateMachine.getClass().getSimpleName() + "(" + stateMachine.getIdentifier() + ")";
    }

    public void startLogging() {
        this.stateMachine.addDeclarativeListener(this);
    }

    public void stopLogging() {
        this.stateMachine.removeDeclarativeListener(this);
    }

    @OnStateMachineStart
    public void onStateMachineStart() {
        logger.info(this.stateMachineLabel + ": Started.");
    }

    @OnStateMachineTerminate
    public void onStateMachineTerminate() {
        logger.info(this.stateMachineLabel + ": Terminated.");
    }

    @OnTransitionBegin
    public void onTransitionBegin(Object object, Object object2, Object object3) {
        this.transitionWatch = Stopwatch.createStarted();
        logger.info(this.stateMachineLabel + ": Transition from \"" + object + "\" on \"" + object2 + "\" with context \"" + object3 + "\" begin.");
    }

    @OnTransitionComplete
    public void onTransitionComplete(Object object, Object object2, Object object3, Object object4) {
        logger.info(this.stateMachineLabel + ": Transition from \"" + object + "\" to \"" + object2 + "\" on \"" + object3 + "\" complete which took " + this.transitionWatch + ".");
    }

    @OnTransitionDecline
    public void onTransitionDeclined(Object object, Object object2) {
        logger.warn(this.stateMachineLabel + ": Transition from \"" + object + "\" on \"" + object2 + "\" declined.");
    }

    @OnTransitionException
    public void onTransitionException(Object object, Object object2, Object object3, Object object4, TransitionException transitionException) {
        Throwable throwable = transitionException.getTargetException();
        logger.error(this.stateMachineLabel + ": Transition from \"" + object + "\" to \"" + object2 + "\" on \"" + object3 + "\" caused exception.", throwable);
    }

    @OnBeforeActionExecuted
    public void onBeforeActionExecuted(Object object, Object object2, Object object3, Object object4, int[] nArray, Action<?, ?, ?, ?> action) {
        this.actionWatch = Stopwatch.createStarted();
        logger.info("Before execute method call action \"" + action.name() + ":" + action.weight() + "\" (" + nArray[0] + " of " + nArray[1] + ").");
    }

    @OnAfterActionExecuted
    public void onAfterActionExecuted(Object object, Object object2, Object object3, Object object4, int[] nArray, Action<?, ?, ?, ?> action) {
        logger.info("After execute method call action \"" + action.name() + ":" + action.weight() + "\" which took " + this.actionWatch + ".");
    }

    @OnActionExecException
    public void onActionExecException(Action<?, ?, ?, ?> action, TransitionException transitionException) {
        logger.error("Error executing method call action \"" + action.name() + "\" caused by \"" + transitionException.getMessage() + "\"");
    }
}

