/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StateMachinePerformanceModel {
    private String name;
    private long totalTransitionInvokedTimes = 0L;
    private long totalTransitionFailedTimes = 0L;
    private long totalTransitionDeclinedTimes = 0L;
    private float averageTranstionConsumedTime = 0.0f;
    private final Map<String, Long> transitionInvokeTimes = Maps.newHashMap();
    private final Map<String, Float> averTransitionConsumedTime = Maps.newHashMap();
    private final Map<String, Long> maxTransitionConsumedTime = Maps.newHashMap();
    private final Map<String, Long> minTransitionConsumedTime = Maps.newHashMap();
    private long totalActionInvokedTimes = 0L;
    private long totalActionFailedTimes = 0L;
    private float averageActionConsumedTime = 0.0f;
    private final Map<String, Long> actionInvokeTimes = Maps.newHashMap();
    private final Map<String, Float> averActionConsumedTime = Maps.newHashMap();
    private final Map<String, Long> maxActionConsumedTime = Maps.newHashMap();
    private final Map<String, Long> minActionConsumedTime = Maps.newHashMap();

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public long getTotalTransitionInvokedTimes() {
        return this.totalTransitionInvokedTimes;
    }

    void setTotalTransitionInvokedTimes(long l) {
        this.totalTransitionInvokedTimes = l;
    }

    public long getTotalTransitionFailedTimes() {
        return this.totalTransitionFailedTimes;
    }

    void setTotalTransitionFailedTimes(long l) {
        this.totalTransitionFailedTimes = l;
    }

    public long getTotalTransitionDeclinedTimes() {
        return this.totalTransitionDeclinedTimes;
    }

    void setTotalTransitionDeclinedTimes(long l) {
        this.totalTransitionDeclinedTimes = l;
    }

    public float getAverageTranstionConsumedTime() {
        return this.averageTranstionConsumedTime;
    }

    void setAverageTranstionConsumedTime(float f) {
        this.averageTranstionConsumedTime = f;
    }

    public long getTotalActionInvokedTimes() {
        return this.totalActionInvokedTimes;
    }

    void setTotalActionInvokedTimes(long l) {
        this.totalActionInvokedTimes = l;
    }

    public long getTotalActionFailedTimes() {
        return this.totalActionFailedTimes;
    }

    void setTotalActionFailedTimes(long l) {
        this.totalActionFailedTimes = l;
    }

    public float getAverageActionConsumedTime() {
        return this.averageActionConsumedTime;
    }

    void setAverageActionConsumedTime(float f) {
        this.averageActionConsumedTime = f;
    }

    public Map<String, Long> getTransitionInvokeTimes() {
        return Collections.unmodifiableMap(this.transitionInvokeTimes);
    }

    void addTransitionInvokeTime(String string, Long l) {
        this.transitionInvokeTimes.put(string, l);
    }

    public Map<String, Float> getAverTransitionConsumedTime() {
        return Collections.unmodifiableMap(this.averTransitionConsumedTime);
    }

    void addAverTransitionConsumedTime(String string, float f) {
        this.averTransitionConsumedTime.put(string, Float.valueOf(f));
    }

    public Map<String, Long> getMaxTransitionConsumedTime() {
        return Collections.unmodifiableMap(this.maxTransitionConsumedTime);
    }

    void addMaxTransitionConsumedTime(String string, Long l) {
        this.maxTransitionConsumedTime.put(string, l);
    }

    public Map<String, Long> getMinTransitionConsumedTime() {
        return Collections.unmodifiableMap(this.minTransitionConsumedTime);
    }

    void addMinTransitionConsumedTime(String string, Long l) {
        this.minTransitionConsumedTime.put(string, l);
    }

    public Map<String, Long> getActionInvokeTimes() {
        return Collections.unmodifiableMap(this.actionInvokeTimes);
    }

    void addActionInvokeTime(String string, Long l) {
        this.actionInvokeTimes.put(string, l);
    }

    public Map<String, Float> getAverActionConsumedTime() {
        return Collections.unmodifiableMap(this.averActionConsumedTime);
    }

    void addAverActionConsumedTime(String string, float f) {
        this.averActionConsumedTime.put(string, Float.valueOf(f));
    }

    public Map<String, Long> getMaxActionConsumedTime() {
        return Collections.unmodifiableMap(this.maxActionConsumedTime);
    }

    void addMaxActionConsumedTime(String string, Long l) {
        this.maxActionConsumedTime.put(string, l);
    }

    public Map<String, Long> getMinActionConsumedTime() {
        return Collections.unmodifiableMap(this.minActionConsumedTime);
    }

    void addMinActionConsumedTime(String string, Long l) {
        this.minActionConsumedTime.put(string, l);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("========================== ");
        stringBuilder.append(this.name);
        stringBuilder.append(" ==========================\n");
        stringBuilder.append("Total Transition Invoked: ").append(this.totalTransitionInvokedTimes).append("\n");
        stringBuilder.append("Total Transition Failed: ").append(this.totalTransitionFailedTimes).append("\n");
        stringBuilder.append("Total Transition Declained: ").append(this.totalTransitionDeclinedTimes).append("\n");
        stringBuilder.append("Average Transition Comsumed: ").append(String.format("%.4fms", Float.valueOf(this.averageTranstionConsumedTime))).append("\n");
        stringBuilder.append("\t").append("Transition Key").append("\t\tInvoked Times\tAverage Time\t\tMax Time\tMin Time\n");
        for (String string : this.transitionInvokeTimes.keySet()) {
            stringBuilder.append("\t").append(StringUtils.abbreviateMiddle((String)string, (String)"...", (int)15)).append("\t\t").append(this.transitionInvokeTimes.get(string)).append("\t\t").append(String.format("%.4fms", this.averTransitionConsumedTime.get(string))).append("\t\t").append(this.maxTransitionConsumedTime.get(string)).append("ms\t\t").append(this.minTransitionConsumedTime.get(string)).append("ms\t\t");
            stringBuilder.append("\n");
        }
        stringBuilder.append("\n");
        stringBuilder.append("Total Action Invoked: ").append(this.totalActionInvokedTimes).append("\n");
        stringBuilder.append("Total Action Failed: ").append(this.totalActionFailedTimes).append("\n");
        stringBuilder.append("Average Action Execution Comsumed: ").append(String.format("%.4fms", Float.valueOf(this.averageActionConsumedTime))).append("\n");
        stringBuilder.append("\t").append("Action Key").append("\t\tInvoked Times\tAverage Time\t\tMax Time\tMin Time\n");
        for (String string : this.actionInvokeTimes.keySet()) {
            stringBuilder.append("\t").append(StringUtils.abbreviateMiddle((String)string, (String)"...", (int)15)).append("\t\t").append(this.actionInvokeTimes.get(string)).append("\t\t").append(String.format("%.4fms", this.averActionConsumedTime.get(string))).append("\t\t").append(this.maxActionConsumedTime.get(string)).append("ms\t\t").append(this.minActionConsumedTime.get(string)).append("ms\t\t");
            stringBuilder.append("\n");
        }
        stringBuilder.append("========================== ");
        stringBuilder.append(this.name);
        stringBuilder.append(" ==========================").append("\n");
        return stringBuilder.toString();
    }
}

