/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.fsm.Converter;
import org.squirrelframework.foundation.fsm.ConverterProvider;
import org.squirrelframework.foundation.fsm.GeneralConverter;

public class ConverterProviderImpl
implements ConverterProvider {
    private Map<Class<?>, Converter<?>> converterRegistry = Maps.newHashMap();

    @Override
    public void register(Class<?> clazz, Class<? extends Converter<?>> clazz2) {
        Converter<?> converter = SquirrelProvider.getInstance().newInstance(clazz2);
        this.register(clazz, converter);
    }

    @Override
    public void register(Class<?> clazz, Converter<?> converter) {
        this.converterRegistry.put(clazz, converter);
    }

    @Override
    public void unregister(Class<?> clazz) {
        this.converterRegistry.remove(clazz);
    }

    @Override
    public <T> Converter<T> getConverter(Class<T> clazz) {
        Converter<?> converter = this.converterRegistry.get(clazz);
        if (converter == null) {
            converter = new GeneralConverter(clazz);
        }
        return converter;
    }

    @Override
    public void clearRegistry() {
        this.converterRegistry.clear();
    }
}

