/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.annotation.AsyncExecute;
import org.squirrelframework.foundation.fsm.annotation.ExecuteWhen;
import org.squirrelframework.foundation.fsm.annotation.LogExecTime;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;
import org.squirrelframework.foundation.util.ReflectUtils;

public class MethodCallActionImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements Action<T, S, E, C> {
    static final Logger logger = LogManager.getLogger(MethodCallActionImpl.class);
    private final Method method;
    private boolean logExecTime;
    private final String executeWhenExpr;
    private final String methodDesc;
    private final ExecutionContext executionContext;
    private final int weight;
    private final boolean isAsync;
    private final long timeout;

    MethodCallActionImpl(Method method, int n, ExecutionContext executionContext) {
        ExecuteWhen executeWhen;
        Preconditions.checkNotNull((Object)method, (Object)"Method of the action cannot be null.");
        this.method = method;
        this.weight = n;
        this.executionContext = executionContext;
        AsyncExecute asyncExecute = method.getAnnotation(AsyncExecute.class);
        this.isAsync = asyncExecute != null;
        this.timeout = asyncExecute != null ? asyncExecute.timeout() : -1L;
        this.logExecTime = ReflectUtils.isAnnotatedWith(method, LogExecTime.class);
        if (!this.logExecTime) {
            boolean bl = this.logExecTime = method.getDeclaringClass().getAnnotation(LogExecTime.class) != null;
        }
        if ((executeWhen = method.getAnnotation(ExecuteWhen.class)) != null) {
            this.executeWhenExpr = executeWhen.value();
            executionContext.getScriptManager().compile(this.executeWhenExpr);
        } else {
            this.executeWhenExpr = null;
        }
        this.methodDesc = ReflectUtils.logMethod(method);
    }

    @Override
    public void execute(S s, S s2, E e, C c, T t) {
        this.invokeMethod(s, s2, e, c, t);
    }

    private void invokeMethod(S s, S s2, E e, C c, T t) {
        Object[] objectArray;
        if (this.executeWhenExpr != null) {
            objectArray = new HashMap();
            objectArray.put("context", c);
            boolean bl = this.executionContext.getScriptManager().evalBoolean(this.executeWhenExpr, objectArray);
            if (!bl) {
                return;
            }
        }
        objectArray = Lists.newArrayList((Object[])new Object[]{s, s2, e, c}).subList(0, this.executionContext.getMethodCallParamTypes().length).toArray();
        if (this.logExecTime && logger.isDebugEnabled()) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            ReflectUtils.invoke(this.method, t, objectArray);
            logger.debug("Execute Method \"" + this.methodDesc + "\" tooks " + stopwatch + ".");
        } else {
            ReflectUtils.invoke(this.method, t, objectArray);
        }
    }

    @Override
    public String name() {
        return this.method.getName();
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof MethodCallActionProxyImpl && object.equals(this)) {
            return true;
        }
        return this.getClass() == object.getClass() && this.method.equals(((MethodCallActionImpl)MethodCallActionImpl.class.cast((Object)object)).method);
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public final String toString() {
        return "method#" + this.method.getName() + ":" + this.weight;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }
}

