/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionImpl;
import org.squirrelframework.foundation.fsm.impl.StateMachineBuilderImpl;

public class MethodCallActionProxyImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements Action<T, S, E, C> {
    private static final Logger logger = LogManager.getLogger(MethodCallActionProxyImpl.class);
    private final String methodName;
    private final ExecutionContext executionContext;
    private Action<T, S, E, C> delegator;
    private final int weight;

    MethodCallActionProxyImpl(String string, ExecutionContext executionContext) {
        String[] stringArray = StringUtils.split((String)string, (char)':');
        this.methodName = stringArray[0];
        if (stringArray.length > 1 && stringArray[1].matches("[\\+-]?\\d+")) {
            if (stringArray[1].startsWith("+")) {
                stringArray[1] = stringArray[1].substring(1);
            }
            this.weight = Integer.valueOf(stringArray[1]);
        } else {
            this.weight = stringArray.length > 1 && stringArray[1].equals("ignore") ? Integer.MIN_VALUE : (string.startsWith("before") ? 100 : (string.startsWith("after") ? -100 : 0));
        }
        this.executionContext = executionContext;
    }

    @Override
    public void execute(S s, S s2, E e, C c, T t) {
        Preconditions.checkNotNull(t);
        this.getDelegator().execute(s, s2, e, c, t);
    }

    private Action<T, S, E, C> getDelegator() {
        if (this.delegator == null) {
            Class<?>[] classArray;
            Class<?> clazz = this.executionContext.getExecutionTargetType();
            Method method = StateMachineBuilderImpl.findMethodCallActionInternal(clazz, this.methodName, classArray = this.executionContext.getMethodCallParamTypes());
            if (method != null) {
                this.delegator = FSM.newMethodCallAction(method, this.weight, this.executionContext);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.warn("Cannot find method '" + this.methodName + "' with parameters '[" + StringUtils.join((Object[])this.executionContext.getMethodCallParamTypes(), (String)", ") + "]' in class " + clazz + ".");
                }
                this.delegator = Action.DUMMY_ACTION;
            }
        }
        return this.delegator;
    }

    @Override
    public String name() {
        return this.methodName;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public int hashCode() {
        return this.methodName.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof MethodCallActionImpl && ((MethodCallActionImpl)MethodCallActionImpl.class.cast(object)).name().equals(this.methodName)) {
            return true;
        }
        return this.getClass() == object.getClass() && this.methodName.equals(((MethodCallActionProxyImpl)MethodCallActionProxyImpl.class.cast((Object)object)).methodName);
    }

    public final String toString() {
        return "method#" + this.methodName + ":" + this.weight;
    }

    @Override
    public boolean isAsync() {
        return this.getDelegator().isAsync();
    }

    @Override
    public long timeout() {
        return this.getDelegator().timeout();
    }
}

