/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.MvelScriptManager;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;

class MvelActionImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements Action<T, S, E, C> {
    private static final Logger logger = LogManager.getLogger(MvelActionImpl.class);
    private final String mvelExpression;
    private final MvelScriptManager scriptManager;
    private final String name;
    private final String script;

    MvelActionImpl(String string, ExecutionContext executionContext) {
        Preconditions.checkNotNull((Object)string);
        String[] stringArray = StringUtils.split((String)string, (String)":::");
        if (stringArray.length == 2) {
            this.name = stringArray[0].trim();
            this.mvelExpression = stringArray[1].trim();
        } else {
            this.name = "_NoName_";
            this.mvelExpression = stringArray[0].trim();
        }
        this.script = string;
        this.scriptManager = executionContext.getScriptManager();
        this.scriptManager.compile(this.mvelExpression);
    }

    @Override
    public void execute(S s, S s2, E e, C c, T t) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("from", s);
            hashMap.put("to", s2);
            hashMap.put("event", e);
            hashMap.put("context", c);
            hashMap.put("stateMachine", t);
            this.scriptManager.eval(this.mvelExpression, hashMap, Void.class);
        }
        catch (RuntimeException runtimeException) {
            logger.error("Evaluate \"" + this.mvelExpression + "\" failed, which caused by " + runtimeException.getCause().getMessage());
            throw runtimeException;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int weight() {
        return 0;
    }

    public final String toString() {
        return "mvel#" + this.script;
    }

    public int hashCode() {
        int n = 1;
        n = 31 + this.mvelExpression.hashCode();
        n = 31 * n + this.name.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MvelActionImpl mvelActionImpl = (MvelActionImpl)object;
        if (this.mvelExpression == null ? mvelActionImpl.mvelExpression != null : !this.mvelExpression.equals(mvelActionImpl.mvelExpression)) {
            return false;
        }
        return !(this.name == null ? mvelActionImpl.name != null : !this.name.equals(mvelActionImpl.name));
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public long timeout() {
        return -1L;
    }
}

