/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.ImmutableTransition;
import org.squirrelframework.foundation.fsm.SCXMLVisitor;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.AbstractVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

class SCXMLVisitorImpl
extends AbstractVisitor
implements SCXMLVisitor {
    SCXMLVisitorImpl() {
    }

    @Override
    public void visitOnEntry(StateMachine<?, ?, ?, ?> stateMachine) {
        this.writeLine("<scxml initial=" + this.quoteName(stateMachine.getInitialState().toString()) + " version=\"1.0\" xmlns=\"http://www.w3.org/2005/07/scxml\" xmlns:sqrl=\"http://squirrelframework.org/squirrel\">");
        this.writeLine("<sqrl:fsm " + stateMachine.getDescription() + " />");
    }

    @Override
    public void visitOnExit(StateMachine<?, ?, ?, ?> stateMachine) {
        this.writeLine("</scxml>");
    }

    @Override
    public void visitOnEntry(ImmutableState<?, ?, ?, ?> immutableState) {
        if (immutableState.isParallelState()) {
            this.writeLine("<parallel id= " + this.quoteName(immutableState.toString()) + ">");
        } else if (immutableState.isFinalState()) {
            this.writeLine("<final id= " + this.quoteName(immutableState.toString()) + ">");
        } else {
            StringBuilder stringBuilder = new StringBuilder("<state id= ");
            stringBuilder.append(this.quoteName(immutableState.toString()));
            if (immutableState.getInitialState() != null) {
                stringBuilder.append(" initial= ").append(this.quoteName(immutableState.getInitialState().toString()));
            }
            stringBuilder.append(">");
            this.writeLine(stringBuilder.toString());
        }
        if (!immutableState.getEntryActions().isEmpty()) {
            this.writeLine("<onentry>");
            for (Action action : immutableState.getEntryActions()) {
                this.writeAction(action);
            }
            this.writeLine("</onentry>");
        }
        if (immutableState.getHistoryType() != HistoryType.NONE) {
            this.writeLine("<history type= " + this.quoteName(immutableState.getHistoryType().name().toLowerCase()) + "/>");
        }
    }

    @Override
    public void visitOnExit(ImmutableState<?, ?, ?, ?> immutableState) {
        if (!immutableState.getExitActions().isEmpty()) {
            this.writeLine("<onexit>");
            for (Action<?, ?, ?, ?> action : immutableState.getExitActions()) {
                this.writeAction(action);
            }
            this.writeLine("</onexit>");
        }
        if (immutableState.isParallelState()) {
            this.writeLine("</parallel>");
        } else if (immutableState.isFinalState()) {
            this.writeLine("</final>");
        } else {
            this.writeLine("</state>");
        }
    }

    @Override
    public void visitOnEntry(ImmutableTransition<?, ?, ?, ?> immutableTransition) {
        this.writeLine("<transition event=" + this.quoteName(immutableTransition.getEvent().toString()) + " sqrl:priority=" + this.quoteName(Integer.toString(immutableTransition.getPriority())) + " sqrl:type=" + this.quoteName(immutableTransition.getType().toString()) + " target=" + this.quoteName(immutableTransition.getTargetState().toString()) + " cond=" + this.quoteName(immutableTransition.getCondition().toString()) + ">");
        for (Action<?, ?, ?, ?> action : immutableTransition.getActions()) {
            this.writeAction(action);
        }
    }

    @Override
    public void visitOnExit(ImmutableTransition<?, ?, ?, ?> immutableTransition) {
        this.writeLine("</transition>");
    }

    private void writeAction(Action<?, ?, ?, ?> action) {
        if (this.isExternalAction(action)) {
            this.writeLine("<sqrl:action content=" + this.quoteName(action.toString()) + "/>");
        }
    }

    private boolean isExternalAction(Action<?, ?, ?, ?> action) {
        return !action.name().startsWith("__");
    }

    @Override
    public String getScxml(boolean bl) {
        return bl ? this.beautify(this.buffer.toString()) : this.buffer.toString();
    }

    @Override
    public void convertSCXMLFile(String string, boolean bl) {
        this.saveFile(string + ".scxml", this.getScxml(bl));
    }

    private String beautify(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("LS"));
            LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
            lSSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            LSOutput lSOutput = dOMImplementationLS.createLSOutput();
            lSOutput.setEncoding("UTF-8");
            StringWriter stringWriter = new StringWriter();
            lSOutput.setCharacterStream(stringWriter);
            lSSerializer.write(document, lSOutput);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }
}

