/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.squirrelframework.foundation.component.SquirrelInstanceProvider;
import org.squirrelframework.foundation.component.SquirrelPostProcessor;
import org.squirrelframework.foundation.component.SquirrelPostProcessorProvider;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.exception.SquirrelRuntimeException;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.ActionWrapper;
import org.squirrelframework.foundation.fsm.AnonymousAction;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.Conditions;
import org.squirrelframework.foundation.fsm.Converter;
import org.squirrelframework.foundation.fsm.ConverterProvider;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.ImmutableTransition;
import org.squirrelframework.foundation.fsm.MutableLinkedState;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.MutableTimedState;
import org.squirrelframework.foundation.fsm.MutableTransition;
import org.squirrelframework.foundation.fsm.MvelScriptManager;
import org.squirrelframework.foundation.fsm.StateCompositeType;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineBuilder;
import org.squirrelframework.foundation.fsm.StateMachineConfiguration;
import org.squirrelframework.foundation.fsm.TransitionType;
import org.squirrelframework.foundation.fsm.UntypedImmutableState;
import org.squirrelframework.foundation.fsm.UntypedMutableState;
import org.squirrelframework.foundation.fsm.UntypedStateMachine;
import org.squirrelframework.foundation.fsm.annotation.ContextEvent;
import org.squirrelframework.foundation.fsm.annotation.ContextInsensitive;
import org.squirrelframework.foundation.fsm.annotation.State;
import org.squirrelframework.foundation.fsm.annotation.StateMachineParameters;
import org.squirrelframework.foundation.fsm.annotation.States;
import org.squirrelframework.foundation.fsm.annotation.Transit;
import org.squirrelframework.foundation.fsm.annotation.Transitions;
import org.squirrelframework.foundation.fsm.builder.DeferBoundActionBuilder;
import org.squirrelframework.foundation.fsm.builder.EntryExitActionBuilder;
import org.squirrelframework.foundation.fsm.builder.ExternalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.From;
import org.squirrelframework.foundation.fsm.builder.InternalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.LocalTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.MultiTransitionBuilder;
import org.squirrelframework.foundation.fsm.builder.To;
import org.squirrelframework.foundation.fsm.builder.When;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;
import org.squirrelframework.foundation.fsm.impl.DeferBoundActionInfo;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionImpl;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;
import org.squirrelframework.foundation.fsm.jmx.ManagementService;
import org.squirrelframework.foundation.util.DuplicateChecker;
import org.squirrelframework.foundation.util.ReflectUtils;

public class StateMachineBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements StateMachineBuilder<T, S, E, C> {
    private static final Logger logger;
    private final Map<S, MutableState<T, S, E, C>> states = Maps.newConcurrentMap();
    private final Class<? extends T> stateMachineImplClazz;
    private final Class<S> stateClazz;
    private final Class<E> eventClazz;
    private final Class<C> contextClazz;
    private boolean prepared = false;
    private final Constructor<? extends T> constructor;
    private final Method postConstructMethod;
    protected final Converter<S> stateConverter;
    protected final Converter<E> eventConverter;
    private final Class<?>[] methodCallParamTypes;
    private Map<String, String> stateAliasToDescription = null;
    private final MvelScriptManager scriptManager;
    private E startEvent;
    private E finishEvent;
    private E terminateEvent;
    private final ExecutionContext executionContext;
    private final List<DeferBoundActionInfo<T, S, E, C>> deferBoundActionInfoList = Lists.newArrayList();
    private boolean isScanAnnotations = true;
    private final Class<?>[] extraParamTypes;
    private StateMachineConfiguration defaultConfiguration = StateMachineConfiguration.getInstance();
    private ManagementService managementService;

    private StateMachineBuilderImpl(Class<? extends T> clazz, Class<S> clazz2, Class<E> clazz3, Class<C> clazz4, Class<?> ... classArray) {
        Constructor<? extends T> constructor;
        Class[] classArray2;
        boolean bl;
        Preconditions.checkArgument((boolean)this.isInstantiableType(clazz), (Object)("The state machine class \"" + clazz.getName() + "\" cannot be instantiated."));
        Preconditions.checkArgument((boolean)this.isStateMachineType(clazz), (Object)("The implementation class of state machine \"" + clazz.getName() + "\" must be extended from AbstractStateMachine.class."));
        this.stateMachineImplClazz = clazz;
        this.extraParamTypes = classArray != null ? classArray : new Class[]{};
        StateMachineParameters stateMachineParameters = this.findAnnotation(StateMachineParameters.class);
        this.stateClazz = clazz2 == Object.class && stateMachineParameters != null ? stateMachineParameters.stateType() : clazz2;
        this.eventClazz = clazz3 == Object.class && stateMachineParameters != null ? stateMachineParameters.eventType() : clazz3;
        this.contextClazz = clazz4 == Object.class && stateMachineParameters != null ? stateMachineParameters.contextType() : clazz4;
        this.stateConverter = ConverterProvider.INSTANCE.getConverter(this.stateClazz);
        this.eventConverter = ConverterProvider.INSTANCE.getConverter(this.eventClazz);
        this.scriptManager = SquirrelProvider.getInstance().newInstance(MvelScriptManager.class);
        boolean bl2 = bl = this.findAnnotation(ContextInsensitive.class) != null;
        if (bl) {
            Class[] classArray3 = new Class[3];
            classArray3[0] = this.stateClazz;
            classArray3[1] = this.stateClazz;
            classArray2 = classArray3;
            classArray3[2] = this.eventClazz;
        } else {
            Class[] classArray4 = new Class[4];
            classArray4[0] = this.stateClazz;
            classArray4[1] = this.stateClazz;
            classArray4[2] = this.eventClazz;
            classArray2 = classArray4;
            classArray4[3] = this.contextClazz;
        }
        this.methodCallParamTypes = classArray2;
        try {
            constructor = ReflectUtils.getConstructor(clazz, this.extraParamTypes);
        }
        catch (Exception exception) {
            try {
                constructor = ReflectUtils.getConstructor(clazz, new Class[0]);
            }
            catch (Exception exception2) {
                throw new IllegalArgumentException("Cannot find matched constructor for '" + clazz.getName() + "'.");
            }
        }
        this.constructor = constructor;
        Method method = null;
        try {
            method = ReflectUtils.getMethod(clazz, "postConstruct", this.extraParamTypes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.postConstructMethod = method;
        this.executionContext = new ExecutionContext(this.scriptManager, clazz, this.methodCallParamTypes);
        this.defineContextEvent();
    }

    private void defineContextEvent() {
        ContextEvent contextEvent = this.findAnnotation(ContextEvent.class);
        if (contextEvent != null) {
            Preconditions.checkState((this.eventConverter != null ? 1 : 0) != 0, (Object)"Do not register event converter");
            if (!contextEvent.startEvent().isEmpty()) {
                this.defineStartEvent(this.eventConverter.convertFromString(contextEvent.startEvent()));
            }
            if (!contextEvent.finishEvent().isEmpty()) {
                this.defineFinishEvent(this.eventConverter.convertFromString(contextEvent.finishEvent()));
            }
            if (!contextEvent.terminateEvent().isEmpty()) {
                this.defineTerminateEvent(this.eventConverter.convertFromString(contextEvent.terminateEvent()));
            }
        }
    }

    private <M extends Annotation> M findAnnotation(final Class<M> clazz) {
        final AtomicReference atomicReference = new AtomicReference();
        this.walkThroughStateMachineClass(new Function<Class<?>, Boolean>(){

            public Boolean apply(Class<?> clazz2) {
                Object a = clazz2.getAnnotation(clazz);
                if (a != null) {
                    atomicReference.set(a);
                    return false;
                }
                return true;
            }
        });
        Annotation annotation = (Annotation)atomicReference.get();
        return (M)annotation;
    }

    private void checkState() {
        if (this.prepared) {
            throw new IllegalStateException("The state machine builder has been freezed and cannot be changed anymore.");
        }
    }

    @Override
    public ExternalTransitionBuilder<T, S, E, C> externalTransition() {
        this.checkState();
        return this.externalTransition(1);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> externalTransitions() {
        this.checkState();
        return this.transitions(1);
    }

    @Override
    public ExternalTransitionBuilder<T, S, E, C> transition() {
        this.checkState();
        return this.externalTransition(1);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> transitions() {
        this.checkState();
        return this.transitions(1);
    }

    @Override
    public DeferBoundActionBuilder<T, S, E, C> transit() {
        this.checkState();
        return FSM.newDeferBoundActionBuilder(this.deferBoundActionInfoList, this.executionContext);
    }

    @Override
    public LocalTransitionBuilder<T, S, E, C> localTransition() {
        this.checkState();
        return this.localTransition(1);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> localTransitions() {
        this.checkState();
        return this.localTransitions(1);
    }

    @Override
    public InternalTransitionBuilder<T, S, E, C> internalTransition() {
        this.checkState();
        return this.internalTransition(1);
    }

    @Override
    public ExternalTransitionBuilder<T, S, E, C> externalTransition(int n) {
        this.checkState();
        return FSM.newExternalTransitionBuilder(this.states, n, this.executionContext);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> externalTransitions(int n) {
        this.checkState();
        return this.transitions(n);
    }

    @Override
    public ExternalTransitionBuilder<T, S, E, C> transition(int n) {
        this.checkState();
        return this.externalTransition(n);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> transitions(int n) {
        this.checkState();
        return FSM.newMultiTransitionBuilder(this.states, TransitionType.EXTERNAL, n, this.executionContext);
    }

    @Override
    public LocalTransitionBuilder<T, S, E, C> localTransition(int n) {
        this.checkState();
        return FSM.newLocalTransitionBuilder(this.states, n, this.executionContext);
    }

    @Override
    public MultiTransitionBuilder<T, S, E, C> localTransitions(int n) {
        this.checkState();
        return FSM.newMultiTransitionBuilder(this.states, TransitionType.LOCAL, n, this.executionContext);
    }

    @Override
    public InternalTransitionBuilder<T, S, E, C> internalTransition(int n) {
        this.checkState();
        return FSM.newInternalTransitionBuilder(this.states, n, this.executionContext);
    }

    private void addStateEntryExitMethodCallAction(String string, Class<?>[] classArray, MutableState<T, S, E, C> mutableState, boolean bl) {
        Method method = StateMachineBuilderImpl.findMethodCallActionInternal(this.stateMachineImplClazz, string, classArray);
        if (method != null) {
            int n = -10;
            if (string.startsWith("before")) {
                n = 100;
            } else if (string.startsWith("after")) {
                n = -100;
            }
            MethodCallActionImpl methodCallActionImpl = FSM.newMethodCallAction(method, n, this.executionContext);
            if (bl) {
                mutableState.addEntryAction(methodCallActionImpl);
            } else {
                mutableState.addExitAction(methodCallActionImpl);
            }
        }
    }

    private void addTransitionMethodCallAction(String string, Class<?>[] classArray, MutableTransition<T, S, E, C> mutableTransition) {
        Method method = StateMachineBuilderImpl.findMethodCallActionInternal(this.stateMachineImplClazz, string, classArray);
        if (method != null) {
            MethodCallActionImpl methodCallActionImpl = FSM.newMethodCallAction(method, -10, this.executionContext);
            mutableTransition.addAction(methodCallActionImpl);
        }
    }

    private boolean isDeferBoundAction(Transit transit) {
        return "*".equals(transit.from()) || "*".equals(transit.to()) || "*".equals(transit.on());
    }

    private Action<T, S, E, C> warpConditionalAction(Action<T, S, E, C> action, final Condition<C> condition) {
        return new ActionWrapper<T, S, E, C>(action){

            @Override
            public void execute(S s, S s2, E e, C c, T t) {
                if (condition.isSatisfied(c)) {
                    super.execute(s, s2, e, c, t);
                }
            }
        };
    }

    private void buildDeferBoundAction(Transit transit) {
        Object s = "*".equals(transit.from()) ? null : (Object)this.stateConverter.convertFromString(this.parseStateId(transit.from()));
        Object s2 = "*".equals(transit.to()) ? null : (Object)this.stateConverter.convertFromString(this.parseStateId(transit.to()));
        Object e = "*".equals(transit.on()) ? null : (Object)this.eventConverter.convertFromString(transit.on());
        DeferBoundActionInfo deferBoundActionInfo = new DeferBoundActionInfo(s, s2, e);
        if (!transit.callMethod().isEmpty()) {
            Condition condition;
            Action action = FSM.newMethodCallActionProxy(transit.callMethod(), this.executionContext);
            if (!transit.whenMvel().isEmpty()) {
                condition = FSM.newMvelCondition(transit.whenMvel(), this.scriptManager);
                action = this.warpConditionalAction(action, condition);
            }
            if (transit.when() != Conditions.Always.class) {
                condition = ReflectUtils.newInstance(transit.when());
                action = this.warpConditionalAction(action, condition);
            }
            deferBoundActionInfo.setActions(Collections.singletonList(action));
        }
        this.deferBoundActionInfoList.add(deferBoundActionInfo);
    }

    /*
     * WARNING - void declaration
     */
    private void buildDeclareTransition(Transit transit) {
        void var7_15;
        When when;
        When when2;
        To<T, S, E, C> to;
        if (transit == null) {
            return;
        }
        Preconditions.checkState((this.stateConverter != null ? 1 : 0) != 0, (Object)"Do not register state converter");
        Preconditions.checkState((this.eventConverter != null ? 1 : 0) != 0, (Object)"Do not register event converter");
        if (this.isDeferBoundAction(transit)) {
            this.buildDeferBoundAction(transit);
            return;
        }
        Preconditions.checkArgument((boolean)this.isInstantiableType(transit.when()), (Object)"Condition 'when' should be concrete class or static inner class.");
        Preconditions.checkArgument((transit.type() != TransitionType.INTERNAL || transit.from().equals(transit.to()) ? 1 : 0) != 0, (Object)"Internal transition must transit to the same source state.");
        S s = this.stateConverter.convertFromString(this.parseStateId(transit.from()));
        Preconditions.checkNotNull(s, (Object)("Cannot convert state of name \"" + s + "\"."));
        S s2 = this.stateConverter.convertFromString(this.parseStateId(transit.to()));
        E e = this.eventConverter.convertFromString(transit.on());
        Preconditions.checkNotNull(e, (Object)("Cannot convert event of name \"" + e + "\"."));
        if (this.states.get(s) != null) {
            to = this.states.get(s);
            for (ImmutableTransition object2 : to.getAllTransitions()) {
                if (!object2.isMatch(s, s2, e, transit.priority(), transit.when(), transit.type())) continue;
                MutableTransition mutableTransition = (MutableTransition)object2;
                String string = transit.callMethod();
                if (string != null && string.length() > 0) {
                    MethodCallActionProxyImpl methodCallActionProxyImpl = FSM.newMethodCallActionProxy(string, this.executionContext);
                    mutableTransition.addAction(methodCallActionProxyImpl);
                }
                return;
            }
        }
        if (transit.type() == TransitionType.INTERNAL) {
            when2 = FSM.newInternalTransitionBuilder(this.states, transit.priority(), this.executionContext);
            to = when2.within(s);
        } else {
            when2 = transit.type() == TransitionType.LOCAL ? FSM.newLocalTransitionBuilder(this.states, transit.priority(), this.executionContext) : FSM.newExternalTransitionBuilder(this.states, transit.priority(), this.executionContext);
            From<T, S, E, C> from = when2.from(s);
            boolean bl = transit.isTargetFinal() || FSM.getState(this.states, s2).isFinalState();
            to = bl ? from.toFinal(s2) : from.to(s2);
        }
        when2 = to.on(e);
        Object var7_10 = null;
        try {
            if (transit.when() != Conditions.Always.class) {
                Constructor<? extends Condition> constructor = transit.when().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Condition condition = constructor.newInstance(new Object[0]);
            } else if (StringUtils.isNotEmpty((CharSequence)transit.whenMvel())) {
                Condition condition = FSM.newMvelCondition(transit.whenMvel(), this.scriptManager);
            }
        }
        catch (Exception exception) {
            logger.error("Instantiate Condition \"" + transit.when().getName() + "\" failed.");
            Condition condition = Conditions.never();
        }
        When when3 = when = var7_15 != null ? when2.when(var7_15) : when2;
        if (!Strings.isNullOrEmpty((String)transit.callMethod())) {
            MethodCallActionProxyImpl methodCallActionProxyImpl = FSM.newMethodCallActionProxy(transit.callMethod(), this.executionContext);
            when.perform(methodCallActionProxyImpl);
        }
    }

    private String parseStateId(String string) {
        return string != null && string.startsWith("#") ? this.stateAliasToDescription.get(string.substring(1)) : string;
    }

    private void buildDeclareState(State state) {
        Object object;
        if (state == null) {
            return;
        }
        Preconditions.checkState((this.stateConverter != null ? 1 : 0) != 0, (Object)"Do not register state converter");
        S s = this.stateConverter.convertFromString(state.name());
        Preconditions.checkNotNull(s, (Object)("Cannot convert state of name \"" + state.name() + "\"."));
        MutableState<T, S, E, C> mutableState = this.defineState(s);
        mutableState.setCompositeType(state.compositeType());
        if (!mutableState.isParallelState()) {
            mutableState.setHistoryType(state.historyType());
        }
        mutableState.setFinal(state.isFinal());
        if (!Strings.isNullOrEmpty((String)state.parent())) {
            object = this.stateConverter.convertFromString(this.parseStateId(state.parent()));
            MutableState<T, S, E, C> mutableState2 = this.defineState(object);
            mutableState.setParentState(mutableState2);
            mutableState2.addChildState(mutableState);
            if (!mutableState2.isParallelState() && state.initialState()) {
                mutableState2.setInitialState(mutableState);
            }
        }
        if (!Strings.isNullOrEmpty((String)state.entryCallMethod())) {
            object = FSM.newMethodCallActionProxy(state.entryCallMethod(), this.executionContext);
            this.onEntry(s).perform((Action<T, S, E, C>)object);
        }
        if (!Strings.isNullOrEmpty((String)state.exitCallMethod())) {
            object = FSM.newMethodCallActionProxy(state.exitCallMethod(), this.executionContext);
            this.onExit(s).perform((Action<T, S, E, C>)object);
        }
        this.rememberStateAlias(state);
    }

    private void rememberStateAlias(State state) {
        if (Strings.isNullOrEmpty((String)state.alias())) {
            return;
        }
        if (this.stateAliasToDescription == null) {
            this.stateAliasToDescription = Maps.newHashMap();
        }
        if (this.stateAliasToDescription.containsKey(state.alias())) {
            throw new RuntimeException("Cannot define duplicate state alias \"" + state.alias() + "\" for state \"" + state.name() + "\" and " + this.stateAliasToDescription.get(state.alias()) + "\".");
        }
        this.stateAliasToDescription.put(state.alias(), state.name());
    }

    private void walkThroughStateMachineClass(Function<Class<?>, Boolean> function) {
        Class clazz;
        boolean bl;
        Stack stack = new Stack();
        stack.push(this.stateMachineImplClazz);
        while (!stack.isEmpty() && (bl = ((Boolean)function.apply((Object)(clazz = (Class)stack.pop()))).booleanValue())) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!this.isStateMachineInterface(clazz2)) continue;
                stack.push(clazz2);
            }
            if (!this.isStateMachineType(clazz.getSuperclass())) continue;
            stack.push(clazz.getSuperclass());
        }
    }

    private void verifyStateMachineDefinition() {
        for (MutableState<T, S, E, C> mutableState : this.states.values()) {
            mutableState.verify();
        }
    }

    private void installDeferBoundActions() {
        if (this.deferBoundActionInfoList.isEmpty()) {
            return;
        }
        for (DeferBoundActionInfo<T, S, E, C> deferBoundActionInfo : this.deferBoundActionInfoList) {
            this.installDeferBoundAction(deferBoundActionInfo);
        }
    }

    private void installDeferBoundAction(DeferBoundActionInfo<T, S, E, C> deferBoundActionInfo) {
        for (MutableState<T, S, E, C> mutableState : this.states.values()) {
            if (!deferBoundActionInfo.isFromStateMatch(mutableState.getStateId())) continue;
            for (ImmutableTransition immutableTransition : mutableState.getAllTransitions()) {
                if (!deferBoundActionInfo.isToStateMatch(immutableTransition.getTargetState().getStateId()) || !deferBoundActionInfo.isEventStateMatch(immutableTransition.getEvent())) continue;
                MutableTransition mutableTransition = (MutableTransition)immutableTransition;
                mutableTransition.addActions(deferBoundActionInfo.getActions());
            }
        }
    }

    private synchronized void prepare() {
        if (this.prepared) {
            return;
        }
        if (this.isScanAnnotations) {
            this.walkThroughStateMachineClass(new DeclareStateFunction());
            this.walkThroughStateMachineClass(new DeclareTransitionFunction());
            this.installDeferBoundActions();
        }
        this.installExtensionMethods();
        this.prioritizeTransitions();
        this.installFinalStateActions();
        this.verifyStateMachineDefinition();
        this.proxyUntypedStates();
        this.prepared = true;
    }

    private void proxyUntypedStates() {
        if (UntypedStateMachine.class.isAssignableFrom(this.stateMachineImplClazz)) {
            HashMap hashMap = Maps.newHashMap();
            for (final MutableState<T, S, E, C> mutableState : this.states.values()) {
                UntypedMutableState untypedMutableState = (UntypedMutableState)Proxy.newProxyInstance(UntypedMutableState.class.getClassLoader(), new Class[]{UntypedMutableState.class, UntypedImmutableState.class}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                        if (method.getName().equals("getStateId")) {
                            return mutableState.getStateId();
                        }
                        if (method.getName().equals("getThis")) {
                            return mutableState.getThis();
                        }
                        if (method.getName().equals("equals")) {
                            return mutableState.equals(objectArray[0]);
                        }
                        if (method.getName().equals("hashCode")) {
                            return mutableState.hashCode();
                        }
                        return method.invoke((Object)mutableState, objectArray);
                    }
                });
                hashMap.put(mutableState.getStateId(), MutableState.class.cast(untypedMutableState));
            }
            this.states.clear();
            this.states.putAll(hashMap);
        }
    }

    private String[] getEntryExitStateMethodNames(ImmutableState<T, S, E, C> immutableState, boolean bl) {
        String string = bl ? "entry" : "exit";
        String string2 = bl ? "EntryAny" : "ExitAny";
        return new String[]{"before" + string2, string + (this.stateConverter != null && !immutableState.isFinalState() ? this.stateConverter.convertToString(immutableState.getStateId()) : StringUtils.capitalize((String)immutableState.toString())), "after" + string2};
    }

    private String[] getTransitionMethodNames(ImmutableTransition<T, S, E, C> immutableTransition) {
        ImmutableState<T, S, E, C> immutableState = immutableTransition.getSourceState();
        ImmutableState<T, S, E, C> immutableState2 = immutableTransition.getTargetState();
        E e = immutableTransition.getEvent();
        String string = this.stateConverter != null ? this.stateConverter.convertToString(immutableState.getStateId()) : StringUtils.capitalize((String)immutableState.toString());
        String string2 = this.stateConverter != null && !immutableState2.isFinalState() ? this.stateConverter.convertToString(immutableState2.getStateId()) : StringUtils.capitalize((String)immutableState2.toString());
        String string3 = this.eventConverter != null ? this.eventConverter.convertToString(e) : StringUtils.capitalize((String)e.toString());
        String string4 = immutableTransition.getCondition().name();
        return new String[]{"transitFrom" + string + "To" + string2 + "On" + string3 + "When" + string4, "transitFrom" + string + "To" + string2 + "On" + string3, "transitFromAnyTo" + string2 + "On" + string3, "transitFrom" + string + "ToAnyOn" + string3, "transitFrom" + string + "To" + string2, "on" + string3};
    }

    /*
     * WARNING - void declaration
     */
    private void installExtensionMethods() {
        for (MutableState<T, S, E, C> mutableState : this.states.values()) {
            void var7_10;
            if (mutableState.isFinalState()) continue;
            String[] stringArray = this.getEntryExitStateMethodNames(mutableState, false);
            for (String stringArray2 : stringArray) {
                this.addStateEntryExitMethodCallAction(stringArray2, this.methodCallParamTypes, mutableState, false);
            }
            Object object = mutableState.getAllTransitions().iterator();
            while (object.hasNext()) {
                String[] stringArray3;
                ImmutableTransition immutableTransition = (ImmutableTransition)object.next();
                for (String string : stringArray3 = this.getTransitionMethodNames(immutableTransition)) {
                    this.addTransitionMethodCallAction(string, this.methodCallParamTypes, (MutableTransition)immutableTransition);
                }
            }
            Object object2 = object = this.getEntryExitStateMethodNames(mutableState, true);
            int n = ((Object)object2).length;
            boolean bl = false;
            while (var7_10 < n) {
                Object object3 = object2[var7_10];
                this.addStateEntryExitMethodCallAction((String)object3, this.methodCallParamTypes, mutableState, true);
                ++var7_10;
            }
        }
    }

    private void prioritizeTransitions() {
        for (MutableState<T, S, E, C> mutableState : this.states.values()) {
            if (mutableState.isFinalState()) continue;
            mutableState.prioritizeTransitions();
        }
    }

    private void installFinalStateActions() {
        for (MutableState<T, S, E, C> mutableState : this.states.values()) {
            if (!mutableState.isFinalState()) continue;
            mutableState.addExitAction(new AnonymousAction<T, S, E, C>(){

                @Override
                public void execute(S s, S s2, E e, C c, T t) {
                    throw new IllegalStateException("Final state cannot be exited anymore.");
                }

                @Override
                public String name() {
                    return "__FINAL_STATE_ACTION_GUARD";
                }
            });
        }
    }

    private boolean isInstantiableType(Class<?> clazz) {
        return clazz != null && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers()) && (clazz.getEnclosingClass() == null || Modifier.isStatic(clazz.getModifiers()));
    }

    private boolean isStateMachineType(Class<?> clazz) {
        return clazz != null && AbstractStateMachine.class != clazz && AbstractStateMachine.class.isAssignableFrom(clazz);
    }

    private boolean isStateMachineInterface(Class<?> clazz) {
        return clazz != null && clazz.isInterface() && StateMachine.class.isAssignableFrom(clazz);
    }

    private static Method searchMethod(Class<?> clazz, Class<?> clazz2, String string, Class<?>[] classArray) {
        if (clazz2.isAssignableFrom(clazz)) {
            Class<?> clazz3 = clazz;
            while (!clazz2.equals(clazz3)) {
                try {
                    return clazz3.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    clazz3 = clazz3.getSuperclass();
                }
            }
        }
        return null;
    }

    static Method findMethodCallActionInternal(Class<?> clazz, String string, Class<?>[] classArray) {
        return StateMachineBuilderImpl.searchMethod(clazz, AbstractStateMachine.class, string, classArray);
    }

    @Override
    public T newStateMachine(S s) {
        return this.newStateMachine(s, new Object[0]);
    }

    @Override
    public T newStateMachine(S s, Object ... objectArray) {
        return this.newStateMachine(s, this.defaultConfiguration, objectArray);
    }

    @Override
    public T newStateMachine(S s, StateMachineConfiguration stateMachineConfiguration, Object ... objectArray) {
        StateMachine stateMachine;
        if (!this.prepared) {
            this.prepare();
        }
        if (!this.isValidState(s)) {
            throw new IllegalArgumentException(this.getClass() + " cannot find Initial state '" + s + "' in state machine.");
        }
        Class<?>[] classArray = this.constructor.getParameterTypes();
        try {
            stateMachine = classArray == null || classArray.length == 0 ? (StateMachine)ReflectUtils.newInstance(this.constructor) : (StateMachine)ReflectUtils.newInstance(this.constructor, objectArray);
        }
        catch (SquirrelRuntimeException squirrelRuntimeException) {
            throw new IllegalStateException("New state machine instance failed.", squirrelRuntimeException.getTargetException());
        }
        final AbstractStateMachine abstractStateMachine = (AbstractStateMachine)stateMachine;
        abstractStateMachine.prePostConstruct(s, this.states, stateMachineConfiguration, new Runnable(){

            @Override
            public void run() {
                abstractStateMachine.setStartEvent(StateMachineBuilderImpl.this.startEvent);
                abstractStateMachine.setFinishEvent(StateMachineBuilderImpl.this.finishEvent);
                abstractStateMachine.setTerminateEvent(StateMachineBuilderImpl.this.terminateEvent);
                abstractStateMachine.setExtraParamTypes(StateMachineBuilderImpl.this.extraParamTypes);
                abstractStateMachine.setTypeOfStateMachine(StateMachineBuilderImpl.this.stateMachineImplClazz);
                abstractStateMachine.setTypeOfState(StateMachineBuilderImpl.this.stateClazz);
                abstractStateMachine.setTypeOfEvent(StateMachineBuilderImpl.this.eventClazz);
                abstractStateMachine.setTypeOfContext(StateMachineBuilderImpl.this.contextClazz);
                abstractStateMachine.setScriptManager(StateMachineBuilderImpl.this.scriptManager);
            }
        });
        if (this.postConstructMethod != null && this.extraParamTypes.length == objectArray.length) {
            try {
                ReflectUtils.invoke(this.postConstructMethod, stateMachine, objectArray);
            }
            catch (SquirrelRuntimeException squirrelRuntimeException) {
                throw new IllegalStateException("Invoke state machine postConstruct method failed.", squirrelRuntimeException.getTargetException());
            }
        }
        this.postProcessStateMachine(this.stateMachineImplClazz, stateMachine);
        if (stateMachineConfiguration.isRemoteMonitorEnabled()) {
            this.getManagementService().register(stateMachine);
        }
        return (T)stateMachine;
    }

    private ManagementService getManagementService() {
        if (this.managementService == null) {
            this.managementService = new ManagementService();
        }
        return this.managementService;
    }

    private boolean isValidState(S s) {
        return s != null && this.states.get(s) != null;
    }

    private T postProcessStateMachine(Class<T> clazz, T t) {
        if (t != null) {
            List<SquirrelPostProcessor<T>> list = SquirrelPostProcessorProvider.getInstance().getCallablePostProcessors(clazz);
            for (SquirrelPostProcessor<T> squirrelPostProcessor : list) {
                squirrelPostProcessor.postProcess(t);
            }
        }
        return t;
    }

    @Override
    public MutableState<T, S, E, C> defineState(S s) {
        this.checkState();
        return FSM.getState(this.states, s);
    }

    @Override
    public MutableState<T, S, E, C> defineFinalState(S s) {
        this.checkState();
        MutableState<T, S, E, C> mutableState = this.defineState(s);
        mutableState.setFinal(true);
        return mutableState;
    }

    @Override
    public MutableState<T, S, E, C> defineLinkedState(S s, final StateMachineBuilder<? extends StateMachine<?, S, E, C>, S, E, C> stateMachineBuilder, final S s2, final Object ... objectArray) {
        this.checkState();
        MutableState<T, S, E, C> mutableState = this.states.get(s);
        if (mutableState == null) {
            MutableLinkedState mutableLinkedState = FSM.newLinkedState(s);
            SquirrelInstanceProvider squirrelInstanceProvider = new SquirrelInstanceProvider<StateMachine<?, S, E, C>>(){

                @Override
                public StateMachine<?, S, E, C> get() {
                    return stateMachineBuilder.newStateMachine(s2, objectArray);
                }
            };
            mutableLinkedState.setLinkedStateMachineProvider(squirrelInstanceProvider);
            this.states.put(s, mutableLinkedState);
            mutableState = mutableLinkedState;
        }
        return mutableState;
    }

    @Override
    public MutableState<T, S, E, C> defineTimedState(S s, long l, long l2, E e, C c) {
        this.checkState();
        MutableState<T, S, E, C> mutableState = this.states.get(s);
        if (mutableState == null) {
            MutableTimedState mutableTimedState = FSM.newTimedState(s);
            mutableTimedState.setAutoFireContext(c);
            mutableTimedState.setAutoFireEvent(e);
            mutableTimedState.setInitialDelay(l);
            mutableTimedState.setTimeInterval(l2);
            this.states.put(s, mutableTimedState);
            mutableState = mutableTimedState;
        }
        return mutableState;
    }

    @Override
    public void defineSequentialStatesOn(S s, S ... SArray) {
        this.checkState();
        this.defineSequentialStatesOn(s, HistoryType.NONE, SArray);
    }

    @Override
    public void defineNoInitSequentialStatesOn(S s, S ... SArray) {
        this.checkState();
        this.defineNoInitSequentialStatesOn(s, HistoryType.NONE, SArray);
    }

    @Override
    public void defineNoInitSequentialStatesOn(S s, HistoryType historyType, S ... SArray) {
        this.checkState();
        this.defineChildStatesOn(s, StateCompositeType.SEQUENTIAL, historyType, true, SArray);
    }

    @Override
    public void defineSequentialStatesOn(S s, HistoryType historyType, S ... SArray) {
        this.checkState();
        this.defineChildStatesOn(s, StateCompositeType.SEQUENTIAL, historyType, false, SArray);
    }

    @Override
    public void defineParallelStatesOn(S s, S ... SArray) {
        this.checkState();
        this.defineChildStatesOn(s, StateCompositeType.PARALLEL, HistoryType.NONE, true, SArray);
    }

    private void defineChildStatesOn(S s, StateCompositeType stateCompositeType, HistoryType historyType, boolean bl, S ... SArray) {
        this.checkState();
        if (SArray != null && SArray.length > 0) {
            MutableState<T, S, E, C> mutableState = FSM.getState(this.states, s);
            mutableState.setCompositeType(stateCompositeType);
            mutableState.setHistoryType(historyType);
            int n = SArray.length;
            for (int i = 0; i < n; ++i) {
                MutableState<T, S, E, C> mutableState2 = FSM.getState(this.states, SArray[i]);
                if (!bl && i == 0) {
                    mutableState.setInitialState(mutableState2);
                }
                mutableState2.setParentState(mutableState);
                mutableState.addChildState(mutableState2);
            }
        }
    }

    @Override
    public EntryExitActionBuilder<T, S, E, C> onEntry(S s) {
        this.checkState();
        MutableState<T, S, E, C> mutableState = FSM.getState(this.states, s);
        return FSM.newEntryExitActionBuilder(mutableState, true, this.executionContext);
    }

    @Override
    public EntryExitActionBuilder<T, S, E, C> onExit(S s) {
        this.checkState();
        MutableState<T, S, E, C> mutableState = FSM.getState(this.states, s);
        return FSM.newEntryExitActionBuilder(mutableState, false, this.executionContext);
    }

    @Override
    public void defineFinishEvent(E e) {
        this.checkState();
        this.finishEvent = e;
    }

    @Override
    public void defineStartEvent(E e) {
        this.checkState();
        this.startEvent = e;
    }

    @Override
    public void defineTerminateEvent(E e) {
        this.checkState();
        this.terminateEvent = e;
    }

    void setScanAnnotations(boolean bl) {
        this.isScanAnnotations = bl;
    }

    @Override
    public void setStateMachineConfiguration(StateMachineConfiguration stateMachineConfiguration) {
        this.checkState();
        this.defaultConfiguration = stateMachineConfiguration;
    }

    static {
        DuplicateChecker.checkDuplicate(StateMachineBuilder.class);
        logger = LogManager.getLogger(StateMachineBuilderImpl.class);
    }

    private class DeclareStateFunction
    implements Function<Class<?>, Boolean> {
        private DeclareStateFunction() {
        }

        public Boolean apply(Class<?> clazz) {
            StateMachineBuilderImpl.this.buildDeclareState(clazz.getAnnotation(State.class));
            States states = clazz.getAnnotation(States.class);
            if (states != null && states.value() != null) {
                for (State state : states.value()) {
                    StateMachineBuilderImpl.this.buildDeclareState(state);
                }
            }
            return true;
        }
    }

    private class DeclareTransitionFunction
    implements Function<Class<?>, Boolean> {
        private DeclareTransitionFunction() {
        }

        public Boolean apply(Class<?> clazz) {
            StateMachineBuilderImpl.this.buildDeclareTransition(clazz.getAnnotation(Transit.class));
            Transitions transitions = clazz.getAnnotation(Transitions.class);
            if (transitions != null && transitions.value() != null) {
                for (Transit transit : transitions.value()) {
                    StateMachineBuilderImpl.this.buildDeclareTransition(transit);
                }
            }
            return true;
        }
    }
}

