/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.TransitionResult;

class TransitionResultImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements TransitionResult<T, S, E, C> {
    private boolean accepted;
    private ImmutableState<T, S, E, C> targetState;
    private TransitionResult<T, S, E, C> parent;
    private List<TransitionResult<T, S, E, C>> subResults;

    TransitionResultImpl() {
    }

    private void addSubResult(TransitionResult<T, S, E, C> transitionResult) {
        if (this.subResults == null) {
            this.subResults = Lists.newArrayList();
        }
        this.subResults.add(transitionResult);
    }

    @Override
    public boolean isAccepted() {
        if (this.accepted) {
            return true;
        }
        if (this.subResults != null) {
            for (TransitionResult<T, S, E, C> transitionResult : this.getSubResults()) {
                if (!transitionResult.isAccepted()) continue;
                return true;
            }
        }
        return false;
    }

    private TransitionResult<T, S, E, C> getRootResult() {
        if (this.parent == null) {
            return this;
        }
        return ((TransitionResultImpl)this.parent).getRootResult();
    }

    @Override
    public ImmutableState<T, S, E, C> getTargetState() {
        return this.targetState;
    }

    @Override
    public List<TransitionResult<T, S, E, C>> getSubResults() {
        return this.subResults != null ? Lists.newArrayList(this.subResults) : Collections.emptyList();
    }

    @Override
    public List<TransitionResult<T, S, E, C>> getAcceptedResults() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.subResults != null) {
            for (TransitionResult<T, S, E, C> transitionResult : this.getSubResults()) {
                arrayList.addAll(transitionResult.getAcceptedResults());
            }
        }
        if (this.accepted) {
            arrayList.add(this);
        }
        return arrayList;
    }

    @Override
    public TransitionResult<T, S, E, C> getParentResut() {
        return this.parent;
    }

    @Override
    public TransitionResult<T, S, E, C> setAccepted(boolean bl) {
        this.accepted = bl;
        return this;
    }

    @Override
    public TransitionResult<T, S, E, C> setTargetState(ImmutableState<T, S, E, C> immutableState) {
        this.targetState = immutableState;
        return this;
    }

    @Override
    public TransitionResult<T, S, E, C> setParent(TransitionResult<T, S, E, C> transitionResult) {
        this.parent = transitionResult;
        if (transitionResult != null && transitionResult instanceof TransitionResultImpl) {
            ((TransitionResultImpl)transitionResult).addSubResult(this);
        }
        return this;
    }

    @Override
    public boolean isDeclined() {
        return !this.isAccepted();
    }
}

