/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.util.common.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class ArrayUtilTest
extends TestCase {
    public void testGetListFromByteArray() {
        byte[] testArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        List list = ArrayUtil.getListFromByteArray(testArray);
        ArrayUtilTest.assertTrue((list.size() == 9 ? 1 : 0) != 0);
        for (int ii = 0; ii < testArray.length; ++ii) {
            byte nextByteFromList = (Byte)list.get(ii);
            ArrayUtilTest.assertEquals((byte)testArray[ii], (byte)nextByteFromList);
        }
    }

    public void testGetByteArrayFromList() {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (int ii = 0; ii < 9; ++ii) {
            list.add(new Byte((byte)ii));
        }
        list.add(null);
        list.add(new Byte(0));
        byte[] data = ArrayUtil.getByteArrayFromList(list);
        ArrayUtilTest.assertTrue((data.length == 11 ? 1 : 0) != 0);
        for (int ii = 0; ii < 9; ++ii) {
            ArrayUtilTest.assertEquals((int)ii, (int)data[ii]);
        }
        ArrayUtilTest.assertEquals((int)0, (int)data[9]);
        ArrayUtilTest.assertEquals((int)0, (int)data[10]);
        data = ArrayUtil.getByteArrayFromList(list, 5);
        ArrayUtilTest.assertTrue((data.length == 6 ? 1 : 0) != 0);
        ArrayUtilTest.assertEquals((int)5, (int)data[0]);
        ArrayUtilTest.assertEquals((int)6, (int)data[1]);
        ArrayUtilTest.assertEquals((int)7, (int)data[2]);
        ArrayUtilTest.assertEquals((int)8, (int)data[3]);
        ArrayUtilTest.assertEquals((int)0, (int)data[4]);
        ArrayUtilTest.assertEquals((int)0, (int)data[5]);
        data = ArrayUtil.getByteArrayFromList(list, 5, 4);
        ArrayUtilTest.assertTrue((data.length == 4 ? 1 : 0) != 0);
        ArrayUtilTest.assertEquals((int)5, (int)data[0]);
        ArrayUtilTest.assertEquals((int)6, (int)data[1]);
        ArrayUtilTest.assertEquals((int)7, (int)data[2]);
        ArrayUtilTest.assertEquals((int)8, (int)data[3]);
        data = ArrayUtil.getByteArrayFromList(list, 0, 0);
        ArrayUtilTest.assertTrue((data.length == 0 ? 1 : 0) != 0);
        data = ArrayUtil.getByteArrayFromList(list, 0, 1);
        ArrayUtilTest.assertTrue((data.length == 1 ? 1 : 0) != 0);
        ArrayUtilTest.assertEquals((int)0, (int)data[0]);
        data = ArrayUtil.getByteArrayFromList(new ArrayList(), 0, 0);
        ArrayUtilTest.assertNotNull((Object)data);
        ArrayUtilTest.assertTrue((data.length == 0 ? 1 : 0) != 0);
    }

    public void testAddBytesToArrayList() {
        byte nextByteFromList;
        int ii;
        ArrayList list = new ArrayList();
        byte[] testArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        ArrayUtil.addBytesToList(testArray, list, 0);
        ArrayUtilTest.assertTrue((list.size() == 9 ? 1 : 0) != 0);
        for (ii = 0; ii < testArray.length; ++ii) {
            nextByteFromList = (Byte)list.get(ii);
            ArrayUtilTest.assertEquals((byte)testArray[ii], (byte)nextByteFromList);
        }
        ArrayUtil.addBytesToList(testArray, 1, 3, list, 9);
        ArrayUtilTest.assertTrue((list.size() == 12 ? 1 : 0) != 0);
        for (ii = 0; ii < testArray.length; ++ii) {
            nextByteFromList = (Byte)list.get(ii);
            ArrayUtilTest.assertEquals((byte)testArray[ii], (byte)nextByteFromList);
        }
        ArrayUtilTest.assertEquals((int)1, (int)((Byte)list.get(9)).byteValue());
        ArrayUtilTest.assertEquals((int)2, (int)((Byte)list.get(10)).byteValue());
        ArrayUtilTest.assertEquals((int)3, (int)((Byte)list.get(11)).byteValue());
        ArrayUtil.addBytesToList(testArray, 1, 3, list, 0);
        ArrayUtilTest.assertTrue((list.size() == 12 ? 1 : 0) != 0);
        ArrayUtilTest.assertEquals((int)1, (int)((Byte)list.get(0)).byteValue());
        ArrayUtilTest.assertEquals((int)2, (int)((Byte)list.get(1)).byteValue());
        ArrayUtilTest.assertEquals((int)3, (int)((Byte)list.get(2)).byteValue());
        ArrayUtilTest.assertEquals((int)3, (int)((Byte)list.get(3)).byteValue());
        ArrayUtil.addBytesToList(testArray, list, 100);
        ArrayUtilTest.assertTrue((list.size() == 109 ? 1 : 0) != 0);
        for (ii = 12; ii < 100; ++ii) {
            ArrayUtilTest.assertNull(list.get(ii));
        }
        for (ii = 100; ii < 109; ++ii) {
            nextByteFromList = (Byte)list.get(ii);
            ArrayUtilTest.assertEquals((byte)testArray[ii - 100], (byte)nextByteFromList);
        }
    }

    public void testTruncateArray() {
        String[] stringArray = new String[]{"This", "is", "an", "array", "of", "strings"};
        ArrayUtilTest.assertTrue(((stringArray = (String[])ArrayUtil.truncateArray(stringArray, 3)).length == 3 ? 1 : 0) != 0);
        ArrayUtilTest.assertEquals((String)"This", (String)stringArray[0]);
        ArrayUtilTest.assertEquals((String)"is", (String)stringArray[1]);
        ArrayUtilTest.assertEquals((String)"an", (String)stringArray[2]);
        boolean[] booleanArray = new boolean[]{true, true, false, true, false, false};
        booleanArray = (boolean[])ArrayUtil.truncateArray(booleanArray, 2, 3);
        ArrayUtilTest.assertTrue((booleanArray.length == 3 ? 1 : 0) != 0);
        ArrayUtilTest.assertEquals((boolean)false, (boolean)booleanArray[0]);
        ArrayUtilTest.assertEquals((boolean)true, (boolean)booleanArray[1]);
        ArrayUtilTest.assertEquals((boolean)false, (boolean)booleanArray[2]);
    }

    public void testIndexOf() {
        byte[] testArray = new byte[]{1, 1, 5, 3, 4, 5, 7, 7, 8, 3, 2};
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.indexOf(testArray, new byte[]{0}));
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.indexOf(testArray, new byte[]{0, 2}));
        ArrayUtilTest.assertEquals((int)0, (int)ArrayUtil.indexOf(testArray, new byte[]{1}));
        ArrayUtilTest.assertEquals((int)1, (int)ArrayUtil.indexOf(testArray, new byte[]{1, 5}));
        ArrayUtilTest.assertEquals((int)6, (int)ArrayUtil.indexOf(testArray, new byte[]{7, 7, 8}));
        ArrayUtilTest.assertEquals((int)0, (int)ArrayUtil.indexOf(testArray, new byte[]{1, 1, 5, 3, 4, 5, 7, 7, 8, 3}));
        ArrayUtilTest.assertEquals((int)0, (int)ArrayUtil.indexOf(testArray, testArray));
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.indexOf(testArray, new byte[]{1, 1, 5, 3, 4, 5, 7, 7, 8, 3, 0}));
        ArrayUtilTest.assertEquals((int)10, (int)ArrayUtil.indexOf(testArray, new byte[]{2}));
        ArrayUtilTest.assertEquals((int)2, (int)ArrayUtil.indexOf(testArray, new byte[]{5, 3}));
        ArrayUtilTest.assertEquals((int)0, (int)ArrayUtil.indexOf(testArray, new byte[0]));
        ArrayUtilTest.assertEquals((float)2.0f, (float)ArrayUtil.indexOf(testArray, new byte[]{5, 3}), (float)1.0f);
        ArrayUtilTest.assertEquals((float)-1.0f, (float)ArrayUtil.indexOf(testArray, new byte[]{5, 3}), (float)5.0f);
        ArrayUtilTest.assertEquals((float)-1.0f, (float)ArrayUtil.indexOf(testArray, testArray), (float)1.0f);
        ArrayUtilTest.assertEquals((float)1.0f, (float)ArrayUtil.indexOf(testArray, new byte[]{1}), (float)1.0f);
        ArrayUtilTest.assertEquals((float)6.0f, (float)ArrayUtil.indexOf(testArray, new byte[]{7, 7, 8}), (float)6.0f);
    }

    public void testConvertToObjectArray() {
        int[] intArray = new int[]{1, 2, 3};
        Object[] integerWrappedArray = ArrayUtil.convertToObjectArray(intArray);
        ArrayUtilTest.assertTrue((boolean)(integerWrappedArray instanceof Integer[]));
        ArrayUtilTest.assertEquals((Object)new Integer(1), (Object)integerWrappedArray[0]);
        ArrayUtilTest.assertEquals((Object)new Integer(2), (Object)integerWrappedArray[1]);
        ArrayUtilTest.assertEquals((Object)new Integer(3), (Object)integerWrappedArray[2]);
        double[] doubleArray = new double[]{1.3};
        Object[] doubleWrappedArray = ArrayUtil.convertToObjectArray(doubleArray);
        ArrayUtilTest.assertTrue((boolean)(doubleWrappedArray instanceof Double[]));
        ArrayUtilTest.assertEquals((Object)new Double(1.3), (Object)doubleWrappedArray[0]);
        String[] stringArray = new String[]{"This", "is", "an", "array", "of", "strings"};
        Object[] stringTargetArray = ArrayUtil.convertToObjectArray(stringArray);
        ArrayUtilTest.assertTrue((stringArray == stringTargetArray ? 1 : 0) != 0);
        boolean[] booleanArray = new boolean[]{true, true, false};
        Object[] booleanWrappedArray = ArrayUtil.convertToObjectArray(booleanArray);
        ArrayUtilTest.assertTrue((boolean)(booleanWrappedArray instanceof Boolean[]));
        ArrayUtilTest.assertEquals((Object)Boolean.TRUE, (Object)booleanWrappedArray[0]);
        ArrayUtilTest.assertEquals((Object)Boolean.TRUE, (Object)booleanWrappedArray[1]);
        ArrayUtilTest.assertEquals((Object)Boolean.FALSE, (Object)booleanWrappedArray[2]);
    }

    public void testConvertToPrimitiveArray() {
        Object[] integerArray = new Integer[]{new Integer(1), new Integer(2), new Integer(3)};
        int[] intUnwrappedArray = (int[])ArrayUtil.convertToPrimitiveArray(integerArray);
        ArrayUtilTest.assertEquals((int)1, (int)intUnwrappedArray[0]);
        ArrayUtilTest.assertEquals((int)2, (int)intUnwrappedArray[1]);
        ArrayUtilTest.assertEquals((int)3, (int)intUnwrappedArray[2]);
        Object[] floatArray = new Float[]{new Float(1.0f)};
        float[] floatUnwrappedArray = (float[])ArrayUtil.convertToPrimitiveArray(floatArray);
        ArrayUtilTest.assertEquals((double)1.0, (double)floatUnwrappedArray[0], (double)0.0);
        Object[] booleanArray = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        boolean[] booleanUnwrappedArray = (boolean[])ArrayUtil.convertToPrimitiveArray(booleanArray);
        ArrayUtilTest.assertTrue((boolean)booleanUnwrappedArray[0]);
        ArrayUtilTest.assertFalse((boolean)booleanUnwrappedArray[1]);
        intUnwrappedArray = (int[])ArrayUtil.convertToPrimitiveArray(new Integer[0]);
        ArrayUtilTest.assertEquals((int)0, (int)intUnwrappedArray.length);
        try {
            ArrayUtil.convertToPrimitiveArray(new String[]{"1"});
            ArrayUtilTest.fail();
        }
        catch (IllegalArgumentException exc) {
            // empty catch block
        }
        try {
            ArrayUtil.convertToPrimitiveArray(new Integer[]{new Integer(1), null});
            ArrayUtilTest.fail();
        }
        catch (IllegalArgumentException exc) {
            // empty catch block
        }
    }

    public void testConvertToArray() {
        int[] intArray = new int[]{1, 2, 3};
        Object array = ArrayUtil.convertToArray(intArray);
        ArrayUtilTest.assertSame((Object)intArray, (Object)array);
        String[] stringArray = new String[]{"This", "is", "an", "array", "of", "strings"};
        array = ArrayUtil.convertToArray(stringArray);
        ArrayUtilTest.assertTrue((stringArray == array ? 1 : 0) != 0);
        array = ArrayUtil.convertToArray("Test");
        ArrayUtilTest.assertTrue((boolean)(array instanceof String[]));
        ArrayUtilTest.assertTrue((((String[])array).length == 1 ? 1 : 0) != 0);
        ArrayUtilTest.assertEquals((String)"Test", (String)((String[])array)[0]);
    }

    public void testCopyArray() {
        byte[] byteArray = new byte[]{1, 2, 3, 4, 5};
        byte[] copyByteArray = (byte[])ArrayUtil.copyArray(byteArray);
        ArrayUtilTest.assertNotSame((Object)byteArray, (Object)copyByteArray);
        ArrayUtilTest.assertTrue((boolean)Arrays.equals(byteArray, copyByteArray));
        String testWrong = (String)ArrayUtil.copyArray("testWrong");
        ArrayUtilTest.assertEquals((String)testWrong, (String)"testWrong");
        Object[] stringArray = new String[]{"This", "is", "an", "array", "of", "strings"};
        Object[] copyStringArray = (String[])ArrayUtil.copyArray(stringArray);
        ArrayUtilTest.assertNotSame((Object)stringArray, (Object)copyStringArray);
        ArrayUtilTest.assertTrue((boolean)Arrays.equals(stringArray, copyStringArray));
        Object myObject = new Object();
        Object[] myArray = new Object[]{myObject};
        Object[] myCopy = (Object[])ArrayUtil.copyArray(myArray);
        ArrayUtilTest.assertNotSame((Object)myArray, (Object)myCopy);
        ArrayUtilTest.assertSame((Object)myArray[0], (Object)myCopy[0]);
        String[] firstStringArray = new String[]{"1", "2", "3"};
        String[] secondStringArray = new String[]{"4", "5", "6"};
        String[][] dim2StringArray = new String[][]{firstStringArray, secondStringArray};
        String[][] copy2Dim = (String[][])ArrayUtil.copyArray(dim2StringArray);
        ArrayUtilTest.assertNotSame((Object)dim2StringArray, (Object)copy2Dim);
        ArrayUtilTest.assertSame((Object)firstStringArray, (Object)copy2Dim[0]);
        ArrayUtilTest.assertSame((Object)secondStringArray, (Object)copy2Dim[1]);
    }

    public void testAreArraysEqual() {
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.areArraysEqual(null, null));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.areArraysEqual("1", "1"));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.areArraysEqual(new Long(1L), new Long(1L)));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual(null, "1"));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual("1", null));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual("1", "2"));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual("1", new String[]{"1"}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual(new String[]{"1", "2"}, new Integer(2)));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual(new String[0], new String[]{"1"}));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.areArraysEqual(new String[]{"1"}, new String[]{"1"}));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.areArraysEqual(new int[]{1, 2, 3}, new int[]{1, 2, 3}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual(new int[]{1, 2}, new int[]{1, 2, 3}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual(new Object[]{new Object()}, new Object[]{new Object()}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual(new Object[]{new Object()}, new Object[]{new Object()}));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.areArraysEqual(new Object[]{"1"}, new String[]{"1"}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual(new String[]{"1"}, new String[][]{{"1"}}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.areArraysEqual(new String[][]{{"1"}}, new String[][]{{"1"}}));
        String[][][] dim3Array = new String[][][]{{{"1"}}, {{"2"}}, {{"3"}}};
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.areArraysEqual(dim3Array, dim3Array));
    }

    public void testComputeHashCode() {
        ArrayUtilTest.assertEquals((int)0, (int)ArrayUtil.computeHashCode(null));
        ArrayUtilTest.assertEquals((int)"123".hashCode(), (int)ArrayUtil.computeHashCode("123"));
        ArrayUtilTest.assertEquals((int)ArrayUtil.computeHashCode(new String[]{"1", null}), (int)ArrayUtil.computeHashCode(new String[]{null, "1"}));
        ArrayUtilTest.assertEquals((int)16369, (int)ArrayUtil.computeHashCode(new byte[]{1, 1}));
        ArrayUtilTest.assertFalse((ArrayUtil.computeHashCode(new String[]{"1", "2"}) == ArrayUtil.computeHashCode(new String[]{"1", "2", "3"}) ? 1 : 0) != 0);
    }

    public void testEnsureUnique() {
        Object[] testArray = new String[]{"test1", "test2"};
        ArrayUtil.ensureUnique((String[])testArray);
        ArrayUtilTest.assertTrue((boolean)Arrays.equals(new String[]{"test1", "test2"}, testArray));
        testArray = new String[]{"test", "test", "xyz"};
        ArrayUtil.ensureUnique((String[])testArray);
        ArrayUtilTest.assertTrue((boolean)Arrays.equals(new String[]{"test1", "test2", "xyz"}, testArray));
        testArray = new String[]{"x", "y", "z", "z", "x"};
        ArrayUtil.ensureUnique((String[])testArray);
        ArrayUtilTest.assertTrue((boolean)Arrays.equals(new String[]{"x1", "y", "z1", "z2", "x2"}, testArray));
    }
}

