/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.ClassUtil;
import com.mockrunner.util.common.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MethodUtil {
    public static Object invoke(Object object, String methodName) {
        try {
            Method method = object.getClass().getMethod(methodName, null);
            return method.invoke(object, null);
        }
        catch (Exception exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public static Object invoke(Object object, String methodName, Object parameter) {
        try {
            Method method = object.getClass().getMethod(methodName, parameter.getClass());
            return method.invoke(object, parameter);
        }
        catch (Exception exc) {
            throw new NestedApplicationException(exc);
        }
    }

    public static boolean areMethodsEqual(Method method1, Method method2) {
        if (method1.equals(method2)) {
            return true;
        }
        if (!method2.getName().equals(method1.getName())) {
            return false;
        }
        if (!method1.getReturnType().equals(method2.getReturnType())) {
            return false;
        }
        return Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }

    public static boolean overrides(Method method1, Method method2) {
        if (method1.equals(method2)) {
            return false;
        }
        if (Modifier.isPrivate(method1.getModifiers())) {
            return false;
        }
        if (Modifier.isPrivate(method2.getModifiers())) {
            return false;
        }
        if (!method1.getDeclaringClass().isAssignableFrom(method2.getDeclaringClass())) {
            return false;
        }
        if (!method2.getName().equals(method1.getName())) {
            return false;
        }
        if (method1.getDeclaringClass().isInterface()) {
            return false;
        }
        return Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }

    public static Set getOverriddenMethods(Class clazz, Method[] methods) {
        Method[][] declaredMethods = MethodUtil.getMethodsSortedByInheritanceHierarchy(clazz);
        HashSet<Method> overridingMethods = new HashSet<Method>();
        for (int ii = 0; ii < methods.length; ++ii) {
            Method currentAroundInvokeMethod = methods[ii];
            HashSet<Method> currentOverridingMethods = new HashSet<Method>();
            for (int yy = 0; yy < declaredMethods.length; ++yy) {
                for (int zz = 0; zz < declaredMethods[yy].length; ++zz) {
                    if (!MethodUtil.overrides(currentAroundInvokeMethod, declaredMethods[yy][zz])) continue;
                    currentOverridingMethods.add(declaredMethods[yy][zz]);
                }
            }
            if (currentOverridingMethods.isEmpty()) continue;
            overridingMethods.add(currentAroundInvokeMethod);
            overridingMethods.addAll(currentOverridingMethods);
        }
        return overridingMethods;
    }

    public static Method[] getMatchingDeclaredMethods(Class theClass, String expr) {
        Method[] methods = theClass.getDeclaredMethods();
        ArrayList<Method> resultList = new ArrayList<Method>();
        for (int ii = 0; ii < methods.length; ++ii) {
            if (!StringUtil.matchesPerl5(methods[ii].getName(), expr, true)) continue;
            resultList.add(methods[ii]);
        }
        return resultList.toArray(new Method[resultList.size()]);
    }

    public static Method[][] getMethodsSortedByInheritanceHierarchy(Class theClass) {
        ArrayList hierarchyList = new ArrayList();
        Class[] hierarchyClasses = ClassUtil.getInheritanceHierarchy(theClass);
        for (int ii = 0; ii < hierarchyClasses.length; ++ii) {
            MethodUtil.addMethodsForClass(hierarchyList, hierarchyClasses[ii]);
        }
        return (Method[][])hierarchyList.toArray((T[])new Method[hierarchyList.size()][]);
    }

    private static void addMethodsForClass(List hierarchyList, Class clazz) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        Method[] methods = clazz.getDeclaredMethods();
        for (int ii = 0; ii < methods.length; ++ii) {
            if (Modifier.isStatic(methods[ii].getModifiers())) continue;
            methodList.add(methods[ii]);
        }
        hierarchyList.add(methodList.toArray(new Method[methodList.size()]));
    }
}

