/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.gen;

import com.mockrunner.gen.proc.PackageImportSorter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class PackageImportSorterTest
extends TestCase {
    private PackageImportSorter sorter;

    protected void setUp() throws Exception {
        this.sorter = new PackageImportSorter();
    }

    private List<String> getMatchingTestList() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("com.abc.base.Base");
        imports.add("java.util.List");
        imports.add("com.mockrunner.struts.ActionTestCaseAdapter");
        imports.add("java.util.Enumeration");
        imports.add("javax.servlet.jsp.JspException");
        imports.add("org.apache.commons.beanutils.BeanUtils");
        imports.add("javax.sql.DataSource");
        imports.add("java.io.BufferedWriter");
        imports.add("org.apache.struts.action.DynaActionFormClass");
        imports.add("org.mypack.TestClass");
        imports.add("javax.servlet.ServletRequest");
        imports.add("javax.swing.Box");
        imports.add("java.net.URL");
        imports.add("com.mockrunner.test.gen.PackageImportSorterTest");
        return imports;
    }

    private List<String> getNonMatchingTestList() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("co.bc.DEF");
        imports.add("co.ac.ABC");
        imports.add("abc.def.Base");
        imports.add("zzzz.yyy.YYY");
        imports.add("uuu.ooo.PPP");
        imports.add("coy.ooo.PPP");
        imports.add("mem.abc.ABC");
        return imports;
    }

    public void testMatchingGroups() {
        List<Set<String>> result = this.sorter.sortBlocks(this.getMatchingTestList());
        PackageImportSorterTest.assertEquals((int)4, (int)result.size());
        Iterator<String> block1 = result.get(0).iterator();
        PackageImportSorterTest.assertEquals((String)"java.io.BufferedWriter", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"java.net.URL", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"java.util.Enumeration", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"java.util.List", (String)block1.next());
        Iterator<String> block2 = result.get(1).iterator();
        PackageImportSorterTest.assertEquals((String)"javax.servlet.ServletRequest", (String)block2.next());
        PackageImportSorterTest.assertEquals((String)"javax.servlet.jsp.JspException", (String)block2.next());
        PackageImportSorterTest.assertEquals((String)"javax.sql.DataSource", (String)block2.next());
        PackageImportSorterTest.assertEquals((String)"javax.swing.Box", (String)block2.next());
        Iterator<String> block3 = result.get(2).iterator();
        PackageImportSorterTest.assertEquals((String)"org.apache.commons.beanutils.BeanUtils", (String)block3.next());
        PackageImportSorterTest.assertEquals((String)"org.apache.struts.action.DynaActionFormClass", (String)block3.next());
        PackageImportSorterTest.assertEquals((String)"org.mypack.TestClass", (String)block3.next());
        Iterator<String> block4 = result.get(3).iterator();
        PackageImportSorterTest.assertEquals((String)"com.abc.base.Base", (String)block4.next());
        PackageImportSorterTest.assertEquals((String)"com.mockrunner.struts.ActionTestCaseAdapter", (String)block4.next());
        PackageImportSorterTest.assertEquals((String)"com.mockrunner.test.gen.PackageImportSorterTest", (String)block4.next());
    }

    public void testNonMatchingGroups() {
        List<Set<String>> result = this.sorter.sortBlocks(this.getNonMatchingTestList());
        PackageImportSorterTest.assertEquals((int)1, (int)result.size());
        Iterator<String> block = result.get(0).iterator();
        PackageImportSorterTest.assertEquals((String)"abc.def.Base", (String)block.next());
        PackageImportSorterTest.assertEquals((String)"co.ac.ABC", (String)block.next());
        PackageImportSorterTest.assertEquals((String)"co.bc.DEF", (String)block.next());
        PackageImportSorterTest.assertEquals((String)"coy.ooo.PPP", (String)block.next());
        PackageImportSorterTest.assertEquals((String)"mem.abc.ABC", (String)block.next());
        PackageImportSorterTest.assertEquals((String)"uuu.ooo.PPP", (String)block.next());
        PackageImportSorterTest.assertEquals((String)"zzzz.yyy.YYY", (String)block.next());
    }

    public void testMixedGroups() {
        ArrayList<String> testList = new ArrayList<String>();
        testList.addAll(this.getNonMatchingTestList());
        testList.addAll(this.getMatchingTestList());
        List<Set<String>> result = this.sorter.sortBlocks(testList);
        PackageImportSorterTest.assertEquals((int)8, (int)result.size());
        Iterator<String> block1 = result.get(0).iterator();
        PackageImportSorterTest.assertEquals((String)"java.io.BufferedWriter", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"java.net.URL", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"java.util.Enumeration", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"java.util.List", (String)block1.next());
        Iterator<String> block2 = result.get(1).iterator();
        PackageImportSorterTest.assertEquals((String)"javax.servlet.ServletRequest", (String)block2.next());
        PackageImportSorterTest.assertEquals((String)"javax.servlet.jsp.JspException", (String)block2.next());
        PackageImportSorterTest.assertEquals((String)"javax.sql.DataSource", (String)block2.next());
        PackageImportSorterTest.assertEquals((String)"javax.swing.Box", (String)block2.next());
        Iterator<String> block3 = result.get(2).iterator();
        PackageImportSorterTest.assertEquals((String)"mem.abc.ABC", (String)block3.next());
        Iterator<String> block4 = result.get(3).iterator();
        PackageImportSorterTest.assertEquals((String)"org.apache.commons.beanutils.BeanUtils", (String)block4.next());
        PackageImportSorterTest.assertEquals((String)"org.apache.struts.action.DynaActionFormClass", (String)block4.next());
        PackageImportSorterTest.assertEquals((String)"org.mypack.TestClass", (String)block4.next());
        Iterator<String> block5 = result.get(4).iterator();
        PackageImportSorterTest.assertEquals((String)"uuu.ooo.PPP", (String)block5.next());
        PackageImportSorterTest.assertEquals((String)"zzzz.yyy.YYY", (String)block5.next());
        Iterator<String> block6 = result.get(5).iterator();
        PackageImportSorterTest.assertEquals((String)"abc.def.Base", (String)block6.next());
        PackageImportSorterTest.assertEquals((String)"co.ac.ABC", (String)block6.next());
        PackageImportSorterTest.assertEquals((String)"co.bc.DEF", (String)block6.next());
        Iterator<String> block7 = result.get(6).iterator();
        PackageImportSorterTest.assertEquals((String)"com.abc.base.Base", (String)block7.next());
        PackageImportSorterTest.assertEquals((String)"com.mockrunner.struts.ActionTestCaseAdapter", (String)block7.next());
        PackageImportSorterTest.assertEquals((String)"com.mockrunner.test.gen.PackageImportSorterTest", (String)block7.next());
        Iterator<String> block8 = result.get(7).iterator();
        PackageImportSorterTest.assertEquals((String)"coy.ooo.PPP", (String)block8.next());
    }

    public void testMixedWithSingleGroup() {
        ArrayList<String> testList = new ArrayList<String>();
        testList.addAll(this.getNonMatchingTestList());
        testList.add("java.util.Enumeration");
        List<Set<String>> result = this.sorter.sortBlocks(testList);
        PackageImportSorterTest.assertEquals((int)3, (int)result.size());
        Iterator<String> block1 = result.get(0).iterator();
        PackageImportSorterTest.assertEquals((String)"abc.def.Base", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"co.ac.ABC", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"co.bc.DEF", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"coy.ooo.PPP", (String)block1.next());
        Iterator<String> block2 = result.get(1).iterator();
        PackageImportSorterTest.assertEquals((String)"java.util.Enumeration", (String)block2.next());
        Iterator<String> block3 = result.get(2).iterator();
        PackageImportSorterTest.assertEquals((String)"mem.abc.ABC", (String)block3.next());
        PackageImportSorterTest.assertEquals((String)"uuu.ooo.PPP", (String)block3.next());
        PackageImportSorterTest.assertEquals((String)"zzzz.yyy.YYY", (String)block3.next());
    }

    public void testMixedWithTwoGroups() {
        ArrayList<String> testList = new ArrayList<String>();
        testList.addAll(this.getNonMatchingTestList());
        testList.add("java.util.Enumeration");
        testList.add("org.mypack.TestClass");
        List<Set<String>> result = this.sorter.sortBlocks(testList);
        PackageImportSorterTest.assertEquals((int)5, (int)result.size());
        Iterator<String> block1 = result.get(0).iterator();
        PackageImportSorterTest.assertEquals((String)"abc.def.Base", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"co.ac.ABC", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"co.bc.DEF", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"coy.ooo.PPP", (String)block1.next());
        Iterator<String> block2 = result.get(1).iterator();
        PackageImportSorterTest.assertEquals((String)"java.util.Enumeration", (String)block2.next());
        Iterator<String> block3 = result.get(2).iterator();
        PackageImportSorterTest.assertEquals((String)"mem.abc.ABC", (String)block3.next());
        Iterator<String> block4 = result.get(3).iterator();
        PackageImportSorterTest.assertEquals((String)"org.mypack.TestClass", (String)block4.next());
        Iterator<String> block5 = result.get(4).iterator();
        PackageImportSorterTest.assertEquals((String)"uuu.ooo.PPP", (String)block5.next());
        PackageImportSorterTest.assertEquals((String)"zzzz.yyy.YYY", (String)block5.next());
    }

    public void testMixedWithThreeGroups() {
        ArrayList<String> testList = new ArrayList<String>();
        testList.addAll(this.getNonMatchingTestList());
        testList.add("java.util.Enumeration");
        testList.add("org.mypack.TestClass");
        testList.add("javax.sql.DataSource");
        List<Set<String>> result = this.sorter.sortBlocks(testList);
        PackageImportSorterTest.assertEquals((int)6, (int)result.size());
        Iterator<String> block1 = result.get(0).iterator();
        PackageImportSorterTest.assertEquals((String)"abc.def.Base", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"co.ac.ABC", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"co.bc.DEF", (String)block1.next());
        PackageImportSorterTest.assertEquals((String)"coy.ooo.PPP", (String)block1.next());
        Iterator<String> block2 = result.get(1).iterator();
        PackageImportSorterTest.assertEquals((String)"java.util.Enumeration", (String)block2.next());
        Iterator<String> block3 = result.get(2).iterator();
        PackageImportSorterTest.assertEquals((String)"javax.sql.DataSource", (String)block3.next());
        Iterator<String> block4 = result.get(3).iterator();
        PackageImportSorterTest.assertEquals((String)"mem.abc.ABC", (String)block4.next());
        Iterator<String> block5 = result.get(4).iterator();
        PackageImportSorterTest.assertEquals((String)"org.mypack.TestClass", (String)block5.next());
        Iterator<String> block6 = result.get(5).iterator();
        PackageImportSorterTest.assertEquals((String)"uuu.ooo.PPP", (String)block6.next());
        PackageImportSorterTest.assertEquals((String)"zzzz.yyy.YYY", (String)block6.next());
    }
}

