/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.util.common.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import junit.framework.TestCase;

public class StringUtilTest
extends TestCase {
    public void testIsEmptyOrNull() {
        StringUtilTest.assertTrue((boolean)StringUtil.isEmptyOrNull(null));
        StringUtilTest.assertTrue((boolean)StringUtil.isEmptyOrNull(""));
        StringUtilTest.assertFalse((boolean)StringUtil.isEmptyOrNull("x"));
        StringUtilTest.assertFalse((boolean)StringUtil.isEmptyOrNull(" "));
        StringUtilTest.assertFalse((boolean)StringUtil.isEmptyOrNull("abc"));
    }

    public void testEmptyStringToNull() {
        StringUtilTest.assertNull((Object)StringUtil.emptyStringToNull(null));
        StringUtilTest.assertNull((Object)StringUtil.emptyStringToNull(""));
        StringUtilTest.assertEquals((String)"x", (String)StringUtil.emptyStringToNull("x"));
        StringUtilTest.assertEquals((String)" ", (String)StringUtil.emptyStringToNull(" "));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.emptyStringToNull("abc"));
    }

    public void testReplaceAll() {
        try {
            StringUtil.replaceAll(null, "test", "test");
            StringUtilTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringUtil.replaceAll("test", null, "test");
            StringUtilTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringUtil.replaceAll("test", "test", null);
            StringUtilTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringUtil.replaceAll("test", "", "test");
            StringUtilTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        StringUtilTest.assertEquals((String)"test", (String)StringUtil.replaceAll("test", "test", "test"));
        StringUtilTest.assertEquals((String)"", (String)StringUtil.replaceAll("", "test", "test"));
        StringUtilTest.assertEquals((String)"abcd", (String)StringUtil.replaceAll("abcd", "test", "test"));
        StringUtilTest.assertEquals((String)"test", (String)StringUtil.replaceAll("abcd", "abcd", "test"));
        StringUtilTest.assertEquals((String)"test", (String)StringUtil.replaceAll("test", "testabc", "1"));
        StringUtilTest.assertEquals((String)"tfst", (String)StringUtil.replaceAll("test", "e", "f"));
        StringUtilTest.assertEquals((String)"tft", (String)StringUtil.replaceAll("test", "es", "f"));
        StringUtilTest.assertEquals((String)"", (String)StringUtil.replaceAll("test", "test", ""));
        StringUtilTest.assertEquals((String)"hello world", (String)StringUtil.replaceAll("test", "test", "hello world"));
        StringUtilTest.assertEquals((String)"hello worldhello world", (String)StringUtil.replaceAll("testtest", "test", "hello world"));
        StringUtilTest.assertEquals((String)"ab123abkkjuuababab", (String)StringUtil.replaceAll("a123akkjuuaaa", "a", "ab"));
        StringUtilTest.assertEquals((String)"aaaa", (String)StringUtil.replaceAll("aaaaaaa", "aa", "a"));
        StringUtilTest.assertEquals((String)"this is a test", (String)StringUtil.replaceAll("this is a xxxx", "xxxx", "test"));
        StringUtilTest.assertEquals((String)"aaaaa", (String)StringUtil.replaceAll("aaaaa", "a", "a"));
        StringUtilTest.assertEquals((String)"bbbbb", (String)StringUtil.replaceAll("aaaaa", "a", "b"));
        StringUtilTest.assertEquals((String)"bbbb", (String)StringUtil.replaceAll("aabbaa", "aa", "b"));
        StringUtilTest.assertEquals((String)"Hella warld", (String)StringUtil.replaceAll("Hello world", "o", "a"));
        StringUtilTest.assertEquals((String)"Hello world", (String)StringUtil.replaceAll("a", "a", "Hello world"));
        StringUtilTest.assertEquals((String)"Hello world ", (String)StringUtil.replaceAll("   ", "  ", "Hello world"));
        StringUtilTest.assertEquals((String)"aabc", (String)StringUtil.replaceAll("abcdabc", "abcd", "a"));
    }

    public void testCompare() {
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.compare("", ""));
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.compare("", "abc"));
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.compare("123", ""));
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.compare("123", "abc"));
        StringUtilTest.assertEquals((int)-1, (int)StringUtil.compare("ASD", "asd"));
        StringUtilTest.assertEquals((int)0, (int)StringUtil.compare("a", "a"));
        StringUtilTest.assertEquals((int)0, (int)StringUtil.compare("a", "ab"));
        StringUtilTest.assertEquals((int)0, (int)StringUtil.compare("123", "1bc"));
        StringUtilTest.assertEquals((int)2, (int)StringUtil.compare("123", "123"));
        StringUtilTest.assertEquals((int)2, (int)StringUtil.compare("123", "1234"));
        StringUtilTest.assertEquals((int)2, (int)StringUtil.compare("1234", "123"));
        StringUtilTest.assertEquals((int)11, (int)StringUtil.compare(" Hello World", " Hello World "));
    }

    public void testLowerCase() {
        StringUtilTest.assertEquals((String)"aBC", (String)StringUtil.lowerCase("ABC", 0));
        StringUtilTest.assertEquals((String)"ABc", (String)StringUtil.lowerCase("ABC", 2));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.lowerCase("abc", 1));
        try {
            StringUtil.lowerCase("abc", 3);
            StringUtilTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testLowerCaseWithEndIndex() {
        StringUtilTest.assertEquals((String)"abC", (String)StringUtil.lowerCase("ABC", 0, 2));
        StringUtilTest.assertEquals((String)"AbC", (String)StringUtil.lowerCase("ABC", 1, 2));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.lowerCase("abc", 0, 1));
        StringUtilTest.assertEquals((String)"aBC", (String)StringUtil.lowerCase("ABC", 0, 0));
        StringUtilTest.assertEquals((String)"aBC", (String)StringUtil.lowerCase("ABC", 0, -1));
        StringUtilTest.assertEquals((String)"abc", (String)StringUtil.lowerCase("ABC", 0, 3));
        try {
            StringUtil.lowerCase("abc", 0, 4);
            StringUtilTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSplit() {
        String test = "This;;is;a;;  ;test; String;;";
        String[] tokens = StringUtil.split(test, ";", true);
        StringUtilTest.assertTrue((tokens.length == 9 ? 1 : 0) != 0);
        StringUtilTest.assertEquals((String)"This", (String)tokens[0]);
        StringUtilTest.assertEquals(null, (String)tokens[1]);
        StringUtilTest.assertEquals((String)"is", (String)tokens[2]);
        StringUtilTest.assertEquals((String)"a", (String)tokens[3]);
        StringUtilTest.assertEquals(null, (String)tokens[4]);
        StringUtilTest.assertEquals(null, (String)tokens[5]);
        StringUtilTest.assertEquals((String)"test", (String)tokens[6]);
        StringUtilTest.assertEquals((String)"String", (String)tokens[7]);
        StringUtilTest.assertEquals(null, (String)tokens[8]);
        tokens = StringUtil.split(test, "test", false);
        StringUtilTest.assertTrue((tokens.length == 2 ? 1 : 0) != 0);
        StringUtilTest.assertEquals((String)"This;;is;a;;  ;", (String)tokens[0]);
        StringUtilTest.assertEquals((String)"; String;;", (String)tokens[1]);
    }

    public void testAppendObjectsAsString() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("Test");
        list.add("Test");
        list.add(1000);
        list.add(null);
        list.add(3L);
        StringBuffer buffer = new StringBuffer();
        StringUtil.appendObjectsAsString(buffer, list);
        StringUtilTest.assertEquals((String)"Test\nTest\n1000\nnull\n3\n", (String)buffer.toString());
    }

    public void testCountMatches() {
        StringUtilTest.assertEquals((int)0, (int)StringUtil.countMatches(null, null));
        StringUtilTest.assertEquals((int)0, (int)StringUtil.countMatches(null, ""));
        StringUtilTest.assertEquals((int)0, (int)StringUtil.countMatches("", null));
        StringUtilTest.assertEquals((int)0, (int)StringUtil.countMatches("", ""));
        StringUtilTest.assertEquals((int)1, (int)StringUtil.countMatches("a", "a"));
        StringUtilTest.assertEquals((int)3, (int)StringUtil.countMatches("aaa", "a"));
        StringUtilTest.assertEquals((int)2, (int)StringUtil.countMatches("abcabcab", "abc"));
        StringUtilTest.assertEquals((int)2, (int)StringUtil.countMatches("abcababc", "abc"));
        StringUtilTest.assertEquals((int)3, (int)StringUtil.countMatches("abcababc", "a"));
        StringUtilTest.assertEquals((int)1, (int)StringUtil.countMatches("Hello World", "ld"));
        StringUtilTest.assertEquals((int)3, (int)StringUtil.countMatches(" Hello World ", " "));
        StringUtilTest.assertEquals((int)3, (int)StringUtil.countMatches("112211111", "11"));
        StringUtilTest.assertEquals((int)1, (int)StringUtil.countMatches("aaaaa", "aaa"));
        StringUtilTest.assertEquals((int)1, (int)StringUtil.countMatches("bbb", "bb"));
        StringUtilTest.assertEquals((int)0, (int)StringUtil.countMatches("bbb", "bbbb"));
    }

    public void testMatchesExact() {
        StringUtilTest.assertTrue((boolean)StringUtil.matchesExact("", "", true));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesExact("", "", false));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesExact("abc", "abc", true));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesExact("aBc", "abc", false));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesExact("aBc", "abc", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesExact("", "abc", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesExact("abc", "abcd", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesExact("abcd", "abc", false));
    }

    public void testMatchesContains() {
        StringUtilTest.assertTrue((boolean)StringUtil.matchesContains("", "", true));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesContains("", "", false));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesContains("abc", "abc", true));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesContains("abcd", "abc", true));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesContains("aBcDDD", "abc", false));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesContains("aBcDDD", "", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesContains("aBc", "abc", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesContains("", "abc", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesContains("abc", "abcd", true));
    }

    public void testMatchesPerl5() {
        StringUtilTest.assertTrue((boolean)StringUtil.matchesPerl5("abc", "abc", true));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesPerl5("abc", "a[abc]c", true));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesPerl5("aBc", "a[abc]c", false));
        StringUtilTest.assertTrue((boolean)StringUtil.matchesPerl5("abc", ".*", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesPerl5("aBc", "abc", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesPerl5("aBc", "a[abc]c", true));
        StringUtilTest.assertFalse((boolean)StringUtil.matchesPerl5("a[abc]c", "abc", true));
    }

    public void testFieldToString() {
        StringUtilTest.assertEquals((String)"test: class java.lang.String", (String)StringUtil.fieldToString("test", String.class));
        StringUtilTest.assertEquals((String)"test: 3", (String)StringUtil.fieldToString("test", 3));
        StringUtilTest.assertEquals((String)"test: empty", (String)StringUtil.fieldToString("test", new ArrayList()));
        StringUtilTest.assertEquals((String)"test: empty", (String)StringUtil.fieldToString("test", new Object[0]));
        ArrayList<Object> testList = new ArrayList<Object>();
        testList.add(5);
        testList.add("abc");
        testList.add(((Object)((Object)this)).getClass());
        StringUtilTest.assertEquals((String)"test 0: 5\ntest 1: abc\ntest 2: class com.mockrunner.test.util.StringUtilTest", (String)StringUtil.fieldToString("test", testList));
        StringUtilTest.assertEquals((String)"test 0: 5\ntest 1: abc\ntest 2: class com.mockrunner.test.util.StringUtilTest", (String)StringUtil.fieldToString("test", testList.toArray()));
        TreeMap<String, String> testMap = new TreeMap<String, String>();
        testMap.put("5", "xyz");
        testMap.put("abc", "xyz");
        testMap.put("123", null);
        StringUtilTest.assertEquals((String)"test 123: null\ntest 5: xyz\ntest abc: xyz", (String)StringUtil.fieldToString("test", testMap));
        StringUtilTest.assertEquals((String)"test: empty", (String)StringUtil.fieldToString("test", new HashMap()));
    }
}

