/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.StreamUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;

public class FileUtil {
    public static List<String> getLinesFromFile(File file) {
        List<String> resultList = null;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            resultList = StreamUtil.getLinesFromReader(reader);
        }
        catch (FileNotFoundException exc) {
            throw new NestedApplicationException(exc);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception exc) {
                    throw new NestedApplicationException(exc);
                }
            }
        }
        return resultList;
    }

    public static File findFile(String fileName) throws FileNotFoundException {
        File file = new File(fileName);
        if (FileUtil.isExistingFile(file)) {
            return file;
        }
        file = new File(fileName = fileName.replace('\\', '/'));
        if (FileUtil.isExistingFile(file)) {
            return file;
        }
        URL fileURL = FileUtil.class.getClassLoader().getResource(fileName);
        file = FileUtil.decodeFileURL(fileURL);
        if (null != file) {
            return file;
        }
        fileURL = FileUtil.class.getResource(fileName);
        file = FileUtil.decodeFileURL(fileURL);
        if (null != file) {
            return file;
        }
        throw new FileNotFoundException("Could not find file: " + fileName);
    }

    private static File decodeFileURL(URL fileURL) {
        if (fileURL != null) {
            try {
                File file = new File(fileURL.getFile());
                if (FileUtil.isExistingFile(file)) {
                    return file;
                }
                file = new File(URLDecoder.decode(fileURL.getFile(), "UTF-8"));
                if (FileUtil.isExistingFile(file)) {
                    return file;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static boolean isExistingFile(File file) {
        return file.exists() && file.isFile();
    }

    public static void createEmptyFile(File file) {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create file: " + file.getPath(), e);
        }
    }
}

