/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.jar;

import com.kirkk.analyzer.Analyzer;
import com.kirkk.analyzer.Configuration;
import com.kirkk.analyzer.framework.Jar;
import com.kirkk.analyzer.textui.Summary;
import com.mockrunner.gen.jar.JarFileExtractor;
import com.mockrunner.gen.jar.MockrunnerJars;
import com.mockrunner.util.common.StreamUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockrunnerTextSummary
implements Summary {
    private static final String TEMPLATE_FILE = "dependtemplate.txt";
    private List mockrunnerJars = MockrunnerJars.getMockrunnerJars();
    private List standardJars = MockrunnerJars.getStandardInterfaceJars();

    public void createSummary(File srcDir, File destFile) throws Exception {
        this.createSummary(srcDir, destFile, null, null);
    }

    public void createSummary(File srcDir, File destFile, String packageFilter, String jarFilter) throws Exception {
        Analyzer analyzer = new Analyzer();
        if (null != packageFilter && null != jarFilter) {
            Configuration.initialize((String)packageFilter, (String)jarFilter);
        }
        Jar[] jar = analyzer.analyze(srcDir);
        JarFileExtractor extractor = new JarFileExtractor(this.mockrunnerJars, this.standardJars);
        Map<String, Set<String>> dependencyMap = extractor.createDependencies(jar);
        try {
            this.output(dependencyMap, destFile);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void output(Map dependencyMap, File destFile) throws Exception {
        try {
            FileWriter fileWriter = new FileWriter(destFile);
            PrintWriter writer = new PrintWriter(fileWriter);
            this.output(dependencyMap, writer);
            writer.flush();
            writer.close();
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void output(Map dependencyMap, PrintWriter writer) throws Exception {
        this.dumpTemplate(writer);
        SimpleDateFormat timestampFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");
        String timestamp = timestampFormat.format(new Date(System.currentTimeMillis()));
        writer.println("Created: " + timestamp);
        writer.println();
        Iterator jars = dependencyMap.keySet().iterator();
        while (jars.hasNext()) {
            String jar = (String)jars.next();
            writer.println("Jar file name: " + jar);
            Set dependendJars = (Set)dependencyMap.get(jar);
            if (null == dependendJars || dependendJars.isEmpty()) {
                writer.println();
                writer.println("No dependencies");
            } else {
                this.outputDependendJars(dependendJars, writer);
            }
            if (!jars.hasNext()) continue;
            writer.println();
            writer.println();
        }
    }

    private void outputDependendJars(Set dependendJars, PrintWriter writer) {
        writer.println();
        writer.println("Depends on: ");
        writer.println();
        for (Object dependendJar : dependendJars) {
            String jar = (String)dependendJar;
            writer.println(jar);
        }
    }

    private void dumpTemplate(PrintWriter writer) throws Exception {
        InputStream templateStream = MockrunnerTextSummary.class.getClassLoader().getResourceAsStream("/dependtemplate.txt");
        String templateText = StreamUtil.getReaderAsString(new InputStreamReader(templateStream, "ISO-8859-1"));
        writer.println(templateText);
        writer.println();
        writer.flush();
    }
}

