/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.jdbc;

import com.mockrunner.example.jdbc.Bank;
import com.mockrunner.jdbc.BasicJDBCTestCaseAdapter;
import com.mockrunner.jdbc.StatementResultSetHandler;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.sql.SQLException;
import org.junit.Test;

public class BankTest
extends BasicJDBCTestCaseAdapter {
    private void prepareEmptyResultSet() {
        StatementResultSetHandler statementHandler = this.getJDBCMockObjectFactory().getMockConnection().getStatementResultSetHandler();
        MockResultSet result = statementHandler.createResultSet();
        statementHandler.prepareGlobalResultSet(result);
    }

    private void prepareResultSet() {
        StatementResultSetHandler statementHandler = this.getJDBCMockObjectFactory().getMockConnection().getStatementResultSetHandler();
        MockResultSet result = statementHandler.createResultSet();
        result.addRow(new Integer[]{new Integer(10000)});
        statementHandler.prepareGlobalResultSet(result);
    }

    @Test
    public void testWrongId() throws SQLException {
        this.prepareEmptyResultSet();
        Bank bank = new Bank();
        bank.connect();
        bank.transfer(1, 2, 5000);
        bank.disconnect();
        this.verifySQLStatementExecuted("select balance");
        this.verifySQLStatementNotExecuted("update account");
        this.verifyNotCommitted();
        this.verifyRolledBack();
        this.verifyAllResultSetsClosed();
        this.verifyAllStatementsClosed();
        this.verifyConnectionClosed();
    }

    @Test
    public void testTransferOk() throws SQLException {
        this.prepareResultSet();
        Bank bank = new Bank();
        bank.connect();
        bank.transfer(1, 2, 5000);
        bank.disconnect();
        this.verifySQLStatementExecuted("select balance");
        this.verifySQLStatementExecuted("update account");
        this.verifySQLStatementParameter("update account", 0, 1, (Object)new Integer(-5000));
        this.verifySQLStatementParameter("update account", 0, 2, (Object)new Integer(1));
        this.verifySQLStatementParameter("update account", 1, 1, (Object)new Integer(5000));
        this.verifySQLStatementParameter("update account", 1, 2, (Object)new Integer(2));
        this.verifyCommitted();
        this.verifyNotRolledBack();
        this.verifyAllResultSetsClosed();
        this.verifyAllStatementsClosed();
        this.verifyConnectionClosed();
    }

    @Test
    public void testTransferFailure() throws SQLException {
        this.prepareResultSet();
        Bank bank = new Bank();
        bank.connect();
        bank.transfer(1, 2, 20000);
        bank.disconnect();
        this.verifySQLStatementExecuted("select balance");
        this.verifySQLStatementNotExecuted("update account");
        this.verifyNotCommitted();
        this.verifyRolledBack();
        this.verifyAllResultSetsClosed();
        this.verifyAllStatementsClosed();
        this.verifyConnectionClosed();
    }
}

