/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.mock.jdbc.MockResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetIterator
implements Iterator<List<?>> {
    private final MockResultSet resultSet;

    public ResultSetIterator(MockResultSet resultSet) {
        this.resultSet = (MockResultSet)resultSet.clone();
        try {
            this.resultSet.beforeFirst();
            this.resultSet.setFetchDirection(1000);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.resultSet.getRow() < this.resultSet.getFetchSize();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public List<?> next() {
        try {
            if (this.resultSet.next()) {
                List row = this.resultSet.getRow(this.resultSet.getRow());
                return row;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

