/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.AbstractParameterResultSetHandler;
import com.mockrunner.jdbc.SQLStatementMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractOutParameterResultSetHandler
extends AbstractParameterResultSetHandler {
    private boolean mustRegisterOutParameters = false;
    private Map globalOutParameter = null;
    private Map outParameterForStatement = new TreeMap();
    private Map outParameterForStatementParameters = new TreeMap();

    public void setMustRegisterOutParameters(boolean mustOutParameterBeRegistered) {
        this.mustRegisterOutParameters = mustOutParameterBeRegistered;
    }

    public boolean getMustRegisterOutParameters() {
        return this.mustRegisterOutParameters;
    }

    public Map getOutParameter(String sql) {
        SQLStatementMatcher matcher = new SQLStatementMatcher(this.getCaseSensitive(), this.getExactMatch(), this.getUseRegularExpressions());
        List list = matcher.getMatchingObjects(this.outParameterForStatement, sql, true, true);
        if (null != list && list.size() > 0) {
            return (Map)list.get(0);
        }
        return null;
    }

    public Map getOutParameter(String sql, Map parameters) {
        MockOutParameterWrapper wrapper = (MockOutParameterWrapper)this.getMatchingParameterWrapper(sql, parameters, this.outParameterForStatementParameters);
        if (null != wrapper) {
            return wrapper.getOutParameter();
        }
        return null;
    }

    public void clearOutParameter() {
        this.outParameterForStatement.clear();
        this.outParameterForStatementParameters.clear();
    }

    public Map getGlobalOutParameter() {
        return this.globalOutParameter;
    }

    public void prepareGlobalOutParameter(Map outParameters) {
        this.globalOutParameter = new HashMap(outParameters);
    }

    public void prepareOutParameter(String sql, Map outParameters) {
        this.outParameterForStatement.put(sql, new HashMap(outParameters));
    }

    public void prepareOutParameter(String sql, Map outParameters, Object[] parameters) {
        this.prepareOutParameter(sql, outParameters, Arrays.asList(parameters));
    }

    public void prepareOutParameter(String sql, Map outParameters, List parameters) {
        HashMap params = new HashMap();
        for (int ii = 0; ii < parameters.size(); ++ii) {
            params.put(new Integer(ii + 1), parameters.get(ii));
        }
        this.prepareOutParameter(sql, outParameters, params);
    }

    public void prepareOutParameter(String sql, Map outParameters, Map parameters) {
        ArrayList<MockOutParameterWrapper> list = (ArrayList<MockOutParameterWrapper>)this.outParameterForStatementParameters.get(sql);
        if (null == list) {
            list = new ArrayList<MockOutParameterWrapper>();
            this.outParameterForStatementParameters.put(sql, list);
        }
        list.add(new MockOutParameterWrapper(new HashMap(outParameters), new HashMap(parameters)));
    }

    private class MockOutParameterWrapper
    extends AbstractParameterResultSetHandler.ParameterWrapper {
        private Map outParameter;

        public MockOutParameterWrapper(Map outParameter, Map parameters) {
            super(AbstractOutParameterResultSetHandler.this, parameters);
            this.outParameter = outParameter;
        }

        public Map getOutParameter() {
            return this.outParameter;
        }
    }
}

