/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import java.sql.RowId;
import java.util.Arrays;

public class MockRowId
implements RowId,
Cloneable {
    private byte[] rowIdData;

    public MockRowId(byte[] data) {
        this.rowIdData = (byte[])data.clone();
    }

    @Override
    public byte[] getBytes() {
        return this.rowIdData;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (null == otherObject) {
            return false;
        }
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        MockRowId otherRowId = (MockRowId)otherObject;
        return Arrays.equals(this.rowIdData, otherRowId.getBytes());
    }

    @Override
    public int hashCode() {
        int value = 17;
        for (int ii = 0; ii < this.rowIdData.length; ++ii) {
            value = 31 * value + this.rowIdData[ii];
        }
        return value;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName() + ": [");
        for (int ii = 0; ii < this.rowIdData.length; ++ii) {
            buffer.append(this.rowIdData[ii]);
            if (ii >= this.rowIdData.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Object clone() {
        try {
            MockRowId copy = (MockRowId)super.clone();
            copy.rowIdData = (byte[])this.rowIdData.clone();
            return copy;
        }
        catch (CloneNotSupportedException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }
}

