/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockDataSource;
import com.mockrunner.mock.jdbc.MockDriver;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JDBCMockObjectFactory {
    private final MockDataSource dataSource = this.createMockDataSource();
    private final MockDriver driver = this.createMockDriver();
    private final MockConnection connection = this.createMockConnection();
    private final Set<Driver> preservedDrivers = new HashSet<Driver>();

    public JDBCMockObjectFactory() {
        this.setUpDependencies();
    }

    private void setUpDependencies() {
        this.dataSource.setupConnection(this.connection);
        this.driver.setupConnection(this.connection);
        this.registerMockDriver();
    }

    private void deregisterDrivers() {
        try {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                DriverManager.deregisterDriver(drivers.nextElement());
            }
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    private void deregisterMockDrivers() {
        try {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver currentDriver = drivers.nextElement();
                if (!(currentDriver instanceof MockDriver)) continue;
                DriverManager.deregisterDriver(currentDriver);
            }
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    private void preserveDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver currentDriver = drivers.nextElement();
            if (currentDriver instanceof MockDriver) continue;
            this.preservedDrivers.add(currentDriver);
        }
    }

    public void registerMockDriver() {
        try {
            this.preserveDrivers();
            this.deregisterDrivers();
            DriverManager.registerDriver(this.driver);
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void restoreDrivers() {
        this.deregisterMockDrivers();
        try {
            Iterator<Driver> drivers = this.preservedDrivers.iterator();
            while (drivers.hasNext()) {
                DriverManager.registerDriver(drivers.next());
            }
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
        this.preservedDrivers.clear();
    }

    public MockConnection createMockConnection() {
        return new MockConnection();
    }

    public MockDriver createMockDriver() {
        return new MockDriver();
    }

    public MockDataSource createMockDataSource() {
        return new MockDataSource();
    }

    public MockDataSource getMockDataSource() {
        return this.dataSource;
    }

    public MockDriver getMockDriver() {
        return this.driver;
    }

    public MockConnection getMockConnection() {
        return this.connection;
    }
}

