/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockMessageProducer;
import com.mockrunner.mock.jms.MockQueueSender;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopicPublisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageProducer;

public class GenericTransmissionManager {
    private MockConnection connection;
    private MockSession session;
    private List messageProducerList;

    public GenericTransmissionManager(MockConnection mockConnection, MockSession mockSession) {
        this.connection = mockConnection;
        this.session = mockSession;
        this.messageProducerList = new ArrayList();
    }

    public void closeAll() {
        this.closeAllMessageProducers();
    }

    public void closeAllMessageProducers() {
        int n = 0;
        while (n < this.messageProducerList.size()) {
            MessageProducer messageProducer = (MessageProducer)this.messageProducerList.get(n);
            try {
                messageProducer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            ++n;
        }
    }

    public MockMessageProducer createMessageProducer() {
        MockMessageProducer mockMessageProducer = new MockMessageProducer(this.connection, this.session, null);
        this.messageProducerList.add(mockMessageProducer);
        return mockMessageProducer;
    }

    public MockQueueSender createQueueSender() {
        MockQueueSender mockQueueSender = new MockQueueSender(this.connection, this.session, null);
        this.messageProducerList.add(mockQueueSender);
        return mockQueueSender;
    }

    public MockTopicPublisher createTopicPublisher() {
        MockTopicPublisher mockTopicPublisher = new MockTopicPublisher(this.connection, this.session, null);
        this.messageProducerList.add(mockTopicPublisher);
        return mockTopicPublisher;
    }

    public MockMessageProducer getMessageProducer(int n) {
        if (this.messageProducerList.size() <= n || n < 0) {
            return null;
        }
        return (MockMessageProducer)this.messageProducerList.get(n);
    }

    public List getMessageProducerList() {
        return Collections.unmodifiableList(this.messageProducerList);
    }
}

