/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.ClassUtil;
import com.mockrunner.util.common.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MethodUtil {
    public static Object invoke(Object object, String string) {
        try {
            Method method = object.getClass().getMethod(string, null);
            return method.invoke(object, null);
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public static Object invoke(Object object, String string, Object object2) {
        try {
            Method method = object.getClass().getMethod(string, object2.getClass());
            return method.invoke(object, object2);
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public static boolean areMethodsEqual(Method method, Method method2) {
        if (method.equals(method2)) {
            return true;
        }
        if (!method2.getName().equals(method.getName())) {
            return false;
        }
        if (!method.getReturnType().equals(method2.getReturnType())) {
            return false;
        }
        return Arrays.equals(method.getParameterTypes(), method2.getParameterTypes());
    }

    public static boolean overrides(Method method, Method method2) {
        if (method.equals(method2)) {
            return false;
        }
        if (!method.getDeclaringClass().isAssignableFrom(method2.getDeclaringClass())) {
            return false;
        }
        if (!method2.getName().equals(method.getName())) {
            return false;
        }
        if (method.getDeclaringClass().isInterface()) {
            return false;
        }
        return Arrays.equals(method.getParameterTypes(), method2.getParameterTypes());
    }

    public static Set getOverriddenMethods(Class clazz, Method[] methodArray) {
        Method[][] methodArray2 = MethodUtil.getMethodsSortedByInheritanceHierarchy(clazz);
        HashSet<Method> hashSet = new HashSet<Method>();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            HashSet<Method> hashSet2 = new HashSet<Method>();
            int n2 = 0;
            while (n2 < methodArray2.length) {
                int n3 = 0;
                while (n3 < methodArray2[n2].length) {
                    if (MethodUtil.overrides(method, methodArray2[n2][n3])) {
                        hashSet2.add(methodArray2[n2][n3]);
                    }
                    ++n3;
                }
                ++n2;
            }
            if (!hashSet2.isEmpty()) {
                hashSet.add(method);
                hashSet.addAll(hashSet2);
            }
            ++n;
        }
        return hashSet;
    }

    public static Method[] getMatchingDeclaredMethods(Class clazz, String string) {
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        int n = 0;
        while (n < methodArray.length) {
            if (StringUtil.matchesPerl5(methodArray[n].getName(), string, true)) {
                arrayList.add(methodArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    public static Method[][] getMethodsSortedByInheritanceHierarchy(Class clazz) {
        ArrayList arrayList = new ArrayList();
        Class[] classArray = ClassUtil.getInheritanceHierarchy(clazz);
        int n = 0;
        while (n < classArray.length) {
            MethodUtil.addMethodsForClass(arrayList, classArray[n]);
            ++n;
        }
        return (Method[][])arrayList.toArray((T[])new Method[arrayList.size()][]);
    }

    private static void addMethodsForClass(List list, Class clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (!Modifier.isStatic(methodArray[n].getModifiers())) {
                arrayList.add(methodArray[n]);
            }
            ++n;
        }
        list.add(arrayList.toArray(new Method[arrayList.size()]));
    }
}

