/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.jdbc.CallableStatementResultSetHandler;
import com.mockrunner.jdbc.ParameterSets;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.jdbc.PreparedStatementResultSetHandler;
import com.mockrunner.jdbc.SQLStatementMatcher;
import com.mockrunner.jdbc.StatementResultSetHandler;
import com.mockrunner.mock.jdbc.JDBCMockObjectFactory;
import com.mockrunner.mock.jdbc.MockCallableStatement;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockSavepoint;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.util.common.StringUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class JDBCTestModule {
    private JDBCMockObjectFactory mockFactory;
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;

    public JDBCTestModule(JDBCMockObjectFactory jDBCMockObjectFactory) {
        this.mockFactory = jDBCMockObjectFactory;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setExactMatch(boolean bl) {
        this.exactMatch = bl;
    }

    public void setUseRegularExpressions(boolean bl) {
        this.useRegularExpressions = bl;
    }

    public StatementResultSetHandler getStatementResultSetHandler() {
        return this.mockFactory.getMockConnection().getStatementResultSetHandler();
    }

    public PreparedStatementResultSetHandler getPreparedStatementResultSetHandler() {
        return this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler();
    }

    public CallableStatementResultSetHandler getCallableStatementResultSetHandler() {
        return this.mockFactory.getMockConnection().getCallableStatementResultSetHandler();
    }

    public MockStatement getStatement(int n) {
        List list = this.getStatements();
        if (n < list.size()) {
            return (MockStatement)list.get(n);
        }
        return null;
    }

    public List getStatements() {
        return this.mockFactory.getMockConnection().getStatementResultSetHandler().getStatements();
    }

    public List getExecutedSQLStatements() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.mockFactory.getMockConnection().getStatementResultSetHandler().getExecutedStatements());
        arrayList.addAll(this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getExecutedStatements());
        arrayList.addAll(this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getExecutedStatements());
        return arrayList;
    }

    public Map getExecutedSQLStatementParameter() {
        return this.getExecutedSQLStatementParameterMap();
    }

    public Map getExecutedSQLStatementParameterMap() {
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getExecutedStatementParameterMap());
        treeMap.putAll(this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getExecutedStatementParameterMap());
        return treeMap;
    }

    public ParameterSets getExecutedSQLStatementParameterSets(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        Map map = this.getExecutedSQLStatementParameterMap();
        List list = sQLStatementMatcher.getMatchingObjects(map, string, false, false);
        if (list != null && list.size() > 0) {
            return (ParameterSets)list.get(0);
        }
        return null;
    }

    public MockResultSet getReturnedResultSet(String string) {
        List list = this.getReturnedResultSets(string);
        if (list != null && list.size() > 0) {
            return (MockResultSet)list.get(0);
        }
        return null;
    }

    public List getReturnedResultSets(String string) {
        List list = this.getReturnedResultSets();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof MockResultSet) {
                this.addIfIdMatches((MockResultSet)e, string, arrayList);
                continue;
            }
            if (!(e instanceof MockResultSet[])) continue;
            MockResultSet[] mockResultSetArray = (MockResultSet[])e;
            for (int j = 0; j < mockResultSetArray.length; ++j) {
                this.addIfIdMatches(mockResultSetArray[j], string, arrayList);
            }
        }
        return arrayList;
    }

    private void addIfIdMatches(MockResultSet mockResultSet, String string, List list) {
        if (null == string) {
            return;
        }
        if (string.equals(mockResultSet.getId())) {
            list.add(mockResultSet);
        }
    }

    public List getReturnedResultSets() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.mockFactory.getMockConnection().getStatementResultSetHandler().getReturnedResultSets());
        arrayList.addAll(this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getReturnedResultSets());
        arrayList.addAll(this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getReturnedResultSets());
        return arrayList;
    }

    public MockPreparedStatement getPreparedStatement(int n) {
        List list = this.getPreparedStatements();
        if (n < list.size()) {
            return (MockPreparedStatement)list.get(n);
        }
        return null;
    }

    public MockPreparedStatement getPreparedStatement(String string) {
        List list = this.getPreparedStatements(string);
        if (null != list && list.size() > 0) {
            return (MockPreparedStatement)list.get(0);
        }
        return null;
    }

    public List getPreparedStatements() {
        return this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getPreparedStatements();
    }

    public List getPreparedStatements(String string) {
        Map map = this.mockFactory.getMockConnection().getPreparedStatementResultSetHandler().getPreparedStatementMap();
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        return sQLStatementMatcher.getMatchingObjects(map, string, true, false);
    }

    public MockCallableStatement getCallableStatement(int n) {
        List list = this.getCallableStatements();
        if (n < list.size()) {
            return (MockCallableStatement)list.get(n);
        }
        return null;
    }

    public MockCallableStatement getCallableStatement(String string) {
        List list = this.getCallableStatements(string);
        if (null != list && list.size() > 0) {
            return (MockCallableStatement)list.get(0);
        }
        return null;
    }

    public List getCallableStatements() {
        return this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getCallableStatements();
    }

    public List getCallableStatements(String string) {
        Map map = this.mockFactory.getMockConnection().getCallableStatementResultSetHandler().getCallableStatementMap();
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        return sQLStatementMatcher.getMatchingObjects(map, string, true, false);
    }

    public Object getPreparedStatementParameter(PreparedStatement preparedStatement, int n) {
        if (null == preparedStatement) {
            return null;
        }
        return ((MockPreparedStatement)preparedStatement).getParameter(n);
    }

    public Object getPreparedStatementParameter(String string, int n) {
        return this.getPreparedStatementParameter(this.getPreparedStatement(string), n);
    }

    public Object getPreparedStatementParameter(int n, int n2) {
        return this.getPreparedStatementParameter(this.getPreparedStatement(n), n2);
    }

    public Object getCallableStatementParameter(CallableStatement callableStatement, int n) {
        if (null == callableStatement) {
            return null;
        }
        return ((MockCallableStatement)callableStatement).getParameter(n);
    }

    public Object getCallableStatementParameter(String string, int n) {
        return this.getCallableStatementParameter((CallableStatement)this.getCallableStatement(string), n);
    }

    public Object getCallableStatementParameter(int n, int n2) {
        return this.getCallableStatementParameter((CallableStatement)this.getCallableStatement(n), n2);
    }

    public Object getCallableStatementParameter(CallableStatement callableStatement, String string) {
        if (null == callableStatement) {
            return null;
        }
        return ((MockCallableStatement)callableStatement).getParameter(string);
    }

    public Object getCallableStatementParameter(String string, String string2) {
        return this.getCallableStatementParameter((CallableStatement)this.getCallableStatement(string), string2);
    }

    public Object getCallableStatementParameter(int n, String string) {
        return this.getCallableStatementParameter((CallableStatement)this.getCallableStatement(n), string);
    }

    public List getSavepoints() {
        return new ArrayList(this.mockFactory.getMockConnection().getSavepointMap().values());
    }

    public MockSavepoint getSavepoint(int n) {
        List list = this.getSavepoints();
        for (int i = 0; i < list.size(); ++i) {
            MockSavepoint mockSavepoint = (MockSavepoint)list.get(i);
            if (mockSavepoint.getNumber() != n) continue;
            return mockSavepoint;
        }
        return null;
    }

    public MockSavepoint getSavepoint(String string) {
        List list = this.getSavepoints();
        for (int i = 0; i < list.size(); ++i) {
            MockSavepoint mockSavepoint = (MockSavepoint)list.get(i);
            try {
                if (!mockSavepoint.getSavepointName().equals(string)) continue;
                return mockSavepoint;
            }
            catch (SQLException sQLException) {
                throw new NestedApplicationException(sQLException);
            }
        }
        return null;
    }

    public void verifySQLStatementExecuted(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        if (!sQLStatementMatcher.contains(this.getExecutedSQLStatements(), string, false)) {
            throw new VerifyFailedException("Statement " + string + " not executed.");
        }
    }

    public void verifySQLStatementNotExecuted(String string) {
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        if (sQLStatementMatcher.contains(this.getExecutedSQLStatements(), string, false)) {
            throw new VerifyFailedException("Statement " + string + " was executed.");
        }
    }

    public void verifySQLStatementParameterNumber(String string, int n, int n2) {
        Map map = this.verifyAndGetParametersForSQL(string, n);
        if (map.size() != n2) {
            throw new VerifyFailedException("Expected " + n2 + " parameter, actual " + map.size() + " parameter");
        }
    }

    public void verifySQLStatementParameter(String string, int n, Map map) {
        this.verifySQLStatementParameterNumber(string, n, map.size());
        Map map2 = this.verifyAndGetParametersForSQL(string, n);
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            Object v2 = map2.get(k);
            if (null == v2) {
                throw new VerifyFailedException("No parameter " + k + " found.");
            }
            if (ParameterUtil.compareParameter(v, v2)) continue;
            throw new VerifyFailedException("Expected " + v + " for parameter " + k + ", but was " + v2);
        }
    }

    public void verifySQLStatementParameter(String string, int n, int n2, Object object) {
        Map map = this.verifyAndGetParametersForSQL(string, n);
        Object v = map.get(new Integer(n2));
        if (!ParameterUtil.compareParameter(object, v)) {
            throw new VerifyFailedException("Expected " + object + " for parameter " + n2 + ", but was " + v);
        }
    }

    public void verifySQLStatementParameter(String string, int n, String string2, Object object) {
        Map map = this.verifyAndGetParametersForSQL(string, n);
        Object v = map.get(string2);
        if (!ParameterUtil.compareParameter(object, v)) {
            throw new VerifyFailedException("Expected " + object + " for parameter " + string2 + ", but was " + v);
        }
    }

    private Map verifyAndGetParametersForSQL(String string, int n) {
        this.verifySQLStatementExecuted(string);
        SQLStatementMatcher sQLStatementMatcher = new SQLStatementMatcher(this.caseSensitive, this.exactMatch, this.useRegularExpressions);
        List list = sQLStatementMatcher.getMatchingObjects(this.getExecutedSQLStatementParameterMap(), string, true, false);
        if (null == list || list.size() == 0) {
            throw new VerifyFailedException("No parameter sets for SQL " + string + " found. Maybe the SQL has been executed by a regular " + "statement instead of a prepared statement or callable statement.");
        }
        ParameterSets parameterSets = (ParameterSets)list.get(0);
        if (null == parameterSets || n >= parameterSets.getNumberParameterSets()) {
            throw new VerifyFailedException("Statement " + string + " has no parameter set with index " + n + ". Maybe it has been executed less than " + (n + 1) + " times.");
        }
        return parameterSets.getParameterSet(n);
    }

    public void verifyConnectionClosed() {
        try {
            if (!this.mockFactory.getMockConnection().isClosed()) {
                throw new VerifyFailedException("Connection not closed.");
            }
        }
        catch (SQLException sQLException) {
            throw new NestedApplicationException(sQLException);
        }
    }

    public void verifyAllStatementsClosed() {
        MockStatement mockStatement;
        int n;
        List list = this.getStatements();
        for (n = 0; n < list.size(); ++n) {
            mockStatement = (MockStatement)list.get(n);
            if (mockStatement.isClosed()) continue;
            throw new VerifyFailedException("Statement with index " + n + " not closed.");
        }
        list = this.getPreparedStatements();
        for (n = 0; n < list.size(); ++n) {
            mockStatement = (MockPreparedStatement)list.get(n);
            if (mockStatement.isClosed()) continue;
            throw new VerifyFailedException("Prepared statement with index " + n + " (SQL " + ((MockPreparedStatement)mockStatement).getSQL() + ") not closed.");
        }
        list = this.getCallableStatements();
        for (n = 0; n < list.size(); ++n) {
            mockStatement = (MockCallableStatement)list.get(n);
            if (mockStatement.isClosed()) continue;
            throw new VerifyFailedException("Callable statement with index " + n + " (SQL " + ((MockPreparedStatement)mockStatement).getSQL() + ") not closed.");
        }
    }

    public void verifyResultSetClosed(String string) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        if (!mockResultSet.isClosed()) {
            throw new VerifyFailedException("ResultSet with id " + string + " not closed.");
        }
    }

    public void verifyResultSetRowInserted(MockResultSet mockResultSet, int n) {
        if (!mockResultSet.rowInserted(n)) {
            throw new VerifyFailedException("Row number " + n + " of ResultSet " + mockResultSet.getId() + " not inserted.");
        }
    }

    public void verifyResultSetRowInserted(String string, int n) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetRowInserted(mockResultSet, n);
    }

    public void verifyResultSetRowNotInserted(MockResultSet mockResultSet, int n) {
        if (mockResultSet.rowInserted(n)) {
            throw new VerifyFailedException("Row number " + n + " of ResultSet " + mockResultSet.getId() + " was inserted.");
        }
    }

    public void verifyResultSetRowNotInserted(String string, int n) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetRowNotInserted(mockResultSet, n);
    }

    public void verifyResultSetRowUpdated(MockResultSet mockResultSet, int n) {
        if (!mockResultSet.rowUpdated(n)) {
            throw new VerifyFailedException("Row number " + n + " of ResultSet " + mockResultSet.getId() + " not updated.");
        }
    }

    public void verifyResultSetRowUpdated(String string, int n) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetRowUpdated(mockResultSet, n);
    }

    public void verifyResultSetRowNotUpdated(MockResultSet mockResultSet, int n) {
        if (mockResultSet.rowUpdated(n)) {
            throw new VerifyFailedException("Row number " + n + " of ResultSet " + mockResultSet.getId() + " was updated.");
        }
    }

    public void verifyResultSetRowNotUpdated(String string, int n) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetRowNotUpdated(mockResultSet, n);
    }

    public void verifyResultSetRowDeleted(MockResultSet mockResultSet, int n) {
        if (!mockResultSet.rowDeleted(n)) {
            throw new VerifyFailedException("Row number " + n + " of ResultSet " + mockResultSet.getId() + " not deleted.");
        }
    }

    public void verifyResultSetRowDeleted(String string, int n) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetRowDeleted(mockResultSet, n);
    }

    public void verifyResultSetRowNotDeleted(MockResultSet mockResultSet, int n) {
        if (mockResultSet.rowDeleted(n)) {
            throw new VerifyFailedException("Row number " + n + " of ResultSet " + mockResultSet.getId() + " was deleted.");
        }
    }

    public void verifyResultSetRowNotDeleted(String string, int n) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetRowNotDeleted(mockResultSet, n);
    }

    public void verifyAllResultSetsClosed() {
        List list = this.getReturnedResultSets();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof MockResultSet) {
                this.throwExceptionIfNotClosed((MockResultSet)e);
                continue;
            }
            if (!(e instanceof MockResultSet[])) continue;
            MockResultSet[] mockResultSetArray = (MockResultSet[])e;
            for (int j = 0; j < mockResultSetArray.length; ++j) {
                this.throwExceptionIfNotClosed(mockResultSetArray[j]);
            }
        }
    }

    private void throwExceptionIfNotClosed(MockResultSet mockResultSet) {
        if (!mockResultSet.isClosed()) {
            throw new VerifyFailedException("ResultSet with id " + mockResultSet.getId() + " not closed.");
        }
    }

    public void verifyCommitted() {
        int n = this.mockFactory.getMockConnection().getNumberCommits();
        if (n <= 0) {
            throw new VerifyFailedException("Connection received no commits.");
        }
    }

    public void verifyNotCommitted() {
        int n = this.mockFactory.getMockConnection().getNumberCommits();
        if (n > 0) {
            throw new VerifyFailedException("Connection was committed");
        }
    }

    public void verifyRolledBack() {
        int n = this.mockFactory.getMockConnection().getNumberRollbacks();
        if (n <= 0) {
            throw new VerifyFailedException("Connection received no rollbacks.");
        }
    }

    public void verifyNotRolledBack() {
        int n = this.mockFactory.getMockConnection().getNumberRollbacks();
        if (n > 0) {
            throw new VerifyFailedException("Connection was rolled back.");
        }
    }

    public void verifyNumberCommits(int n) {
        int n2 = this.mockFactory.getMockConnection().getNumberCommits();
        if (n2 != n) {
            throw new VerifyFailedException("Connection received " + n2 + " commits, expected " + n);
        }
    }

    public void verifyNumberRollbacks(int n) {
        int n2 = this.mockFactory.getMockConnection().getNumberRollbacks();
        if (n2 != n) {
            throw new VerifyFailedException("Connection received " + n2 + " rollbacks, expected " + n);
        }
    }

    public void verifyNumberStatements(int n) {
        this.verifyNumberStatements(n, this.getStatements());
    }

    public void verifyNumberPreparedStatements(int n) {
        this.verifyNumberStatements(n, this.getPreparedStatements());
    }

    public void verifyNumberPreparedStatements(int n, String string) {
        this.verifyNumberStatements(n, this.getPreparedStatements(string));
    }

    public void verifyNumberCallableStatements(int n) {
        this.verifyNumberStatements(n, this.getCallableStatements());
    }

    public void verifyNumberCallableStatements(int n, String string) {
        this.verifyNumberStatements(n, this.getCallableStatements(string));
    }

    private void verifyNumberStatements(int n, List list) {
        if (null == list || list.size() == 0) {
            if (n == 0) {
                return;
            }
            throw new VerifyFailedException("Expected " + n + " statements, received 0 statements");
        }
        if (list.size() != n) {
            throw new VerifyFailedException("Expected " + n + " statements, received " + list.size() + " statements");
        }
    }

    public void verifyStatementClosed(int n) {
        MockStatement mockStatement = this.getStatement(n);
        if (null == mockStatement) {
            throw new VerifyFailedException("No statement with index " + n + " present.");
        }
        if (!mockStatement.isClosed()) {
            throw new VerifyFailedException("Statement with index " + n + " not closed.");
        }
    }

    public void verifyPreparedStatementClosed(int n) {
        MockPreparedStatement mockPreparedStatement = this.getPreparedStatement(n);
        if (null == mockPreparedStatement) {
            throw new VerifyFailedException("No prepared statement with index " + n + " present.");
        }
        if (!mockPreparedStatement.isClosed()) {
            throw new VerifyFailedException("Prepared statement with index " + n + " not closed.");
        }
    }

    public void verifyPreparedStatementClosed(String string) {
        MockPreparedStatement mockPreparedStatement = this.getPreparedStatement(string);
        if (null == mockPreparedStatement) {
            throw new VerifyFailedException("No prepared statement with SQL " + string + " present.");
        }
        if (!mockPreparedStatement.isClosed()) {
            throw new VerifyFailedException("Prepared statement with SQL " + string + " not closed.");
        }
    }

    public void verifyCallableStatementClosed(int n) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(n);
        if (null == mockCallableStatement) {
            throw new VerifyFailedException("No callable statement with index " + n + " present.");
        }
        if (!mockCallableStatement.isClosed()) {
            throw new VerifyFailedException("Callable statement with index " + n + " not closed.");
        }
    }

    public void verifyCallableStatementClosed(String string) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(string);
        if (null == mockCallableStatement) {
            throw new VerifyFailedException("No callable statement with SQL " + string + " present.");
        }
        if (!mockCallableStatement.isClosed()) {
            throw new VerifyFailedException("Callable statement with SQL " + string + " not closed.");
        }
    }

    public void verifyResultSetRow(MockResultSet mockResultSet, int n, List list) {
        if (null == mockResultSet.getRow(n)) {
            throw new VerifyFailedException("ResultSet " + mockResultSet.getId() + " has no row " + n);
        }
        if (!mockResultSet.isRowEqual(n, list)) {
            StringBuffer stringBuffer = new StringBuffer("Actual row data:\n");
            StringUtil.appendObjectsAsString(stringBuffer, mockResultSet.getRow(n));
            stringBuffer.append("\n");
            stringBuffer.append("Expected row data:\n");
            StringUtil.appendObjectsAsString(stringBuffer, list);
            throw new VerifyFailedException("Mismatch in row data.\n" + stringBuffer.toString());
        }
    }

    public void verifyResultSetRow(MockResultSet mockResultSet, int n, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.verifyResultSetRow(mockResultSet, n, list);
    }

    public void verifyResultSetRow(String string, int n, List list) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetRow(mockResultSet, n, list);
    }

    public void verifyResultSetRow(String string, int n, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.verifyResultSetRow(string, n, list);
    }

    public void verifyResultSetColumn(MockResultSet mockResultSet, int n, List list) {
        if (null == mockResultSet.getColumn(n)) {
            throw new VerifyFailedException("ResultSet " + mockResultSet.getId() + " has no column " + n);
        }
        if (!mockResultSet.isColumnEqual(n, list)) {
            StringBuffer stringBuffer = new StringBuffer("Actual column data:\n");
            StringUtil.appendObjectsAsString(stringBuffer, mockResultSet.getColumn(n));
            stringBuffer.append("\n");
            stringBuffer.append("Expected column data:\n");
            StringUtil.appendObjectsAsString(stringBuffer, list);
            throw new VerifyFailedException("Mismatch in column data.\n" + stringBuffer.toString());
        }
    }

    public void verifyResultSetColumn(MockResultSet mockResultSet, int n, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.verifyResultSetColumn(mockResultSet, n, list);
    }

    public void verifyResultSetColumn(String string, int n, List list) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetColumn(mockResultSet, n, list);
    }

    public void verifyResultSetColumn(String string, int n, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.verifyResultSetColumn(string, n, list);
    }

    public void verifyResultSetColumn(MockResultSet mockResultSet, String string, List list) {
        if (null == mockResultSet.getColumn(string)) {
            throw new VerifyFailedException("ResultSet " + mockResultSet.getId() + " has no column " + string);
        }
        if (!mockResultSet.isColumnEqual(string, list)) {
            StringBuffer stringBuffer = new StringBuffer("Actual column data:\n");
            StringUtil.appendObjectsAsString(stringBuffer, mockResultSet.getColumn(string));
            stringBuffer.append("\n");
            stringBuffer.append("Expected column data:\n");
            StringUtil.appendObjectsAsString(stringBuffer, list);
            throw new VerifyFailedException("Mismatch in column data.\n" + stringBuffer.toString());
        }
    }

    public void verifyResultSetColumn(MockResultSet mockResultSet, String string, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.verifyResultSetColumn(mockResultSet, string, list);
    }

    public void verifyResultSetColumn(String string, String string2, List list) {
        MockResultSet mockResultSet = this.getReturnedResultSet(string);
        if (null == mockResultSet) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetColumn(mockResultSet, string2, list);
    }

    public void verifyResultSetColumn(String string, String string2, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.verifyResultSetColumn(string, string2, list);
    }

    public void verifyResultSetEquals(MockResultSet mockResultSet, MockResultSet mockResultSet2) {
        if (!mockResultSet.isEqual(mockResultSet2)) {
            StringBuffer stringBuffer = new StringBuffer("Source data:\n");
            stringBuffer.append(mockResultSet.toString());
            stringBuffer.append("\n");
            stringBuffer.append("Target data:\n");
            stringBuffer.append(mockResultSet2.toString());
            throw new VerifyFailedException("Mismatch in ResultSet data.\n" + stringBuffer.toString());
        }
    }

    public void verifyResultSetEquals(String string, MockResultSet mockResultSet) {
        MockResultSet mockResultSet2 = this.getReturnedResultSet(string);
        if (null == mockResultSet2) {
            throw new VerifyFailedException("ResultSet with id " + string + " not present.");
        }
        this.verifyResultSetEquals(mockResultSet2, mockResultSet);
    }

    public void verifyPreparedStatementPresent(String string) {
        if (null == this.getPreparedStatement(string)) {
            throw new VerifyFailedException("Prepared statement with SQL " + string + " present.");
        }
    }

    public void verifyPreparedStatementNotPresent(String string) {
        if (null != this.getPreparedStatement(string)) {
            throw new VerifyFailedException("Prepared statement with SQL " + string + " not present.");
        }
    }

    public void verifyCallableStatementPresent(String string) {
        if (null == this.getCallableStatement(string)) {
            throw new VerifyFailedException("Callable statement with SQL " + string + " present.");
        }
    }

    public void verifyCallableStatementNotPresent(String string) {
        if (null != this.getCallableStatement(string)) {
            throw new VerifyFailedException("Callable statement with SQL " + string + " not present.");
        }
    }

    public void verifyPreparedStatementParameterPresent(PreparedStatement preparedStatement, int n) {
        if (!this.containsPreparedStatementParameter(preparedStatement, n)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n + " not present.");
        }
    }

    public void verifyPreparedStatementParameterPresent(String string, int n) {
        if (!this.containsPreparedStatementParameter(string, n)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n + " not present.");
        }
    }

    public void verifyPreparedStatementParameterPresent(int n, int n2) {
        if (!this.containsPreparedStatementParameter(n, n2)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n2 + " not present.");
        }
    }

    public void verifyPreparedStatementParameterNotPresent(PreparedStatement preparedStatement, int n) {
        if (this.containsPreparedStatementParameter(preparedStatement, n)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n + " present.");
        }
    }

    public void verifyPreparedStatementParameterNotPresent(String string, int n) {
        if (this.containsPreparedStatementParameter(string, n)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n + " present.");
        }
    }

    public void verifyPreparedStatementParameterNotPresent(int n, int n2) {
        if (this.containsPreparedStatementParameter(n, n2)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n2 + " present.");
        }
    }

    private boolean containsPreparedStatementParameter(int n, int n2) {
        MockPreparedStatement mockPreparedStatement = this.getPreparedStatement(n);
        if (null == mockPreparedStatement) {
            return false;
        }
        return this.containsPreparedStatementParameter(mockPreparedStatement, n2);
    }

    private boolean containsPreparedStatementParameter(String string, int n) {
        MockPreparedStatement mockPreparedStatement = this.getPreparedStatement(string);
        if (null == mockPreparedStatement) {
            return false;
        }
        return this.containsPreparedStatementParameter(mockPreparedStatement, n);
    }

    private boolean containsPreparedStatementParameter(PreparedStatement preparedStatement, int n) {
        return ((MockPreparedStatement)preparedStatement).getParameterMap().containsKey(new Integer(n));
    }

    public void verifyCallableStatementParameterPresent(CallableStatement callableStatement, int n) {
        if (!this.containsCallableStatementParameter(callableStatement, n)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n + " not present.");
        }
    }

    public void verifyCallableStatementParameterPresent(String string, int n) {
        if (!this.containsCallableStatementParameter(string, n)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n + " not present.");
        }
    }

    public void verifyCallableStatementParameterPresent(int n, int n2) {
        if (!this.containsCallableStatementParameter(n, n2)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n2 + " not present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(CallableStatement callableStatement, int n) {
        if (this.containsCallableStatementParameter(callableStatement, n)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n + " present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(String string, int n) {
        if (this.containsCallableStatementParameter(string, n)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n + " present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(int n, int n2) {
        if (this.containsCallableStatementParameter(n, n2)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n2 + " present.");
        }
    }

    public void verifyCallableStatementParameterPresent(CallableStatement callableStatement, String string) {
        if (!this.containsCallableStatementParameter(callableStatement, string)) {
            throw new VerifyFailedException("Callable statement parameter with index " + string + " not present.");
        }
    }

    public void verifyCallableStatementParameterPresent(String string, String string2) {
        if (!this.containsCallableStatementParameter(string, string2)) {
            throw new VerifyFailedException("Callable statement parameter with index " + string2 + " not present.");
        }
    }

    public void verifyCallableStatementParameterPresent(int n, String string) {
        if (!this.containsCallableStatementParameter(n, string)) {
            throw new VerifyFailedException("Callable statement parameter with index " + string + " not present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(CallableStatement callableStatement, String string) {
        if (this.containsCallableStatementParameter(callableStatement, string)) {
            throw new VerifyFailedException("Callable statement parameter with index " + string + " present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(String string, String string2) {
        if (this.containsCallableStatementParameter(string, string2)) {
            throw new VerifyFailedException("Callable statement parameter with index " + string2 + " present.");
        }
    }

    public void verifyCallableStatementParameterNotPresent(int n, String string) {
        if (this.containsCallableStatementParameter(n, string)) {
            throw new VerifyFailedException("Callable statement parameter with index " + string + " present.");
        }
    }

    private boolean containsCallableStatementParameter(int n, int n2) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(n);
        if (null == mockCallableStatement) {
            return false;
        }
        return this.containsCallableStatementParameter((CallableStatement)mockCallableStatement, n2);
    }

    private boolean containsCallableStatementParameter(String string, int n) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(string);
        if (null == mockCallableStatement) {
            return false;
        }
        return this.containsCallableStatementParameter((CallableStatement)mockCallableStatement, n);
    }

    private boolean containsCallableStatementParameter(CallableStatement callableStatement, int n) {
        return ((MockCallableStatement)callableStatement).getParameterMap().containsKey(new Integer(n));
    }

    private boolean containsCallableStatementParameter(int n, String string) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(n);
        if (null == mockCallableStatement) {
            return false;
        }
        return this.containsCallableStatementParameter((CallableStatement)mockCallableStatement, string);
    }

    private boolean containsCallableStatementParameter(String string, String string2) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(string);
        if (null == mockCallableStatement) {
            return false;
        }
        return this.containsCallableStatementParameter((CallableStatement)mockCallableStatement, string2);
    }

    private boolean containsCallableStatementParameter(CallableStatement callableStatement, String string) {
        return ((MockCallableStatement)callableStatement).getParameterMap().containsKey(string);
    }

    public void verifyPreparedStatementParameter(PreparedStatement preparedStatement, int n, Object object) {
        this.verifyPreparedStatementParameterPresent(preparedStatement, n);
        Object object2 = this.getPreparedStatementParameter(preparedStatement, n);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyPreparedStatementParameter(String string, int n, Object object) {
        this.verifyPreparedStatementParameterPresent(string, n);
        Object object2 = this.getPreparedStatementParameter(string, n);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyPreparedStatementParameter(int n, int n2, Object object) {
        this.verifyPreparedStatementParameterPresent(n, n2);
        Object object2 = this.getPreparedStatementParameter(n, n2);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Prepared statement parameter with index " + n2 + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyCallableStatementParameter(CallableStatement callableStatement, int n, Object object) {
        this.verifyCallableStatementParameterPresent(callableStatement, n);
        Object object2 = this.getCallableStatementParameter(callableStatement, n);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyCallableStatementParameter(String string, int n, Object object) {
        this.verifyCallableStatementParameterPresent(string, n);
        Object object2 = this.getCallableStatementParameter(string, n);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyCallableStatementParameter(int n, int n2, Object object) {
        this.verifyCallableStatementParameterPresent(n, n2);
        Object object2 = this.getCallableStatementParameter(n, n2);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Callable statement parameter with index " + n2 + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyCallableStatementParameter(CallableStatement callableStatement, String string, Object object) {
        this.verifyCallableStatementParameterPresent(callableStatement, string);
        Object object2 = this.getCallableStatementParameter(callableStatement, string);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Callable statement parameter with name " + string + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyCallableStatementParameter(String string, String string2, Object object) {
        this.verifyCallableStatementParameterPresent(string, string2);
        Object object2 = this.getCallableStatementParameter(string, string2);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Callable statement parameter with name " + string2 + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyCallableStatementParameter(int n, String string, Object object) {
        this.verifyCallableStatementParameterPresent(n, string);
        Object object2 = this.getCallableStatementParameter(n, string);
        if (!ParameterUtil.compareParameter(object2, object)) {
            throw new VerifyFailedException("Callable statement parameter with name " + string + " has the value " + object2.toString() + ", expected " + object.toString());
        }
    }

    public void verifyCallableStatementOutParameterRegistered(CallableStatement callableStatement, int n) {
        if (!((MockCallableStatement)callableStatement).isOutParameterRegistered(n)) {
            throw new VerifyFailedException("Out parameter with index " + n + " not registered in callable statement ");
        }
    }

    public void verifyCallableStatementOutParameterRegistered(String string, int n) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(string);
        if (null == mockCallableStatement) {
            throw new VerifyFailedException("No callable statement " + string + " present");
        }
        if (!mockCallableStatement.isOutParameterRegistered(n)) {
            throw new VerifyFailedException("Out parameter with index " + n + " not registered in callable statement " + string);
        }
    }

    public void verifyCallableStatementOutParameterRegistered(int n, int n2) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(n);
        if (null == mockCallableStatement) {
            throw new VerifyFailedException("No callable statement with index " + n + " present");
        }
        if (!mockCallableStatement.isOutParameterRegistered(n2)) {
            throw new VerifyFailedException("Out parameter with index " + n2 + " not registered in callable statement with index " + n);
        }
    }

    public void verifyCallableStatementOutParameterRegistered(CallableStatement callableStatement, String string) {
        if (!((MockCallableStatement)callableStatement).isOutParameterRegistered(string)) {
            throw new VerifyFailedException("Out parameter with name " + string + " not registered in callable statement ");
        }
    }

    public void verifyCallableStatementOutParameterRegistered(String string, String string2) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(string);
        if (null == mockCallableStatement) {
            throw new VerifyFailedException("No callable statement " + string + " present");
        }
        if (!mockCallableStatement.isOutParameterRegistered(string2)) {
            throw new VerifyFailedException("Out parameter with name " + string2 + " not registered in callable statement " + string);
        }
    }

    public void verifyCallableStatementOutParameterRegistered(int n, String string) {
        MockCallableStatement mockCallableStatement = this.getCallableStatement(n);
        if (null == mockCallableStatement) {
            throw new VerifyFailedException("No callable statement with index " + n + " present");
        }
        if (!mockCallableStatement.isOutParameterRegistered(string)) {
            throw new VerifyFailedException("Out parameter with name " + string + " not registered in callable statement with index " + n);
        }
    }

    public void verifySavepointPresent(int n) {
        MockSavepoint mockSavepoint = this.getSavepoint(n);
        if (null == mockSavepoint) {
            throw new VerifyFailedException("No savepoint with index " + n + " present.");
        }
    }

    public void verifySavepointPresent(String string) {
        MockSavepoint mockSavepoint = this.getSavepoint(string);
        if (null == mockSavepoint) {
            throw new VerifyFailedException("No savepoint with name " + string + " present.");
        }
    }

    public void verifySavepointReleased(int n) {
        this.verifySavepointPresent(n);
        if (!this.getSavepoint(n).isReleased()) {
            throw new VerifyFailedException("Savepoint with index " + n + " not released.");
        }
    }

    public void verifySavepointReleased(String string) {
        this.verifySavepointPresent(string);
        if (!this.getSavepoint(string).isReleased()) {
            throw new VerifyFailedException("Savepoint with name " + string + " not released.");
        }
    }

    public void verifySavepointNotReleased(int n) {
        this.verifySavepointPresent(n);
        if (this.getSavepoint(n).isReleased()) {
            throw new VerifyFailedException("Savepoint with index " + n + " is released.");
        }
    }

    public void verifySavepointNotReleased(String string) {
        this.verifySavepointPresent(string);
        if (this.getSavepoint(string).isReleased()) {
            throw new VerifyFailedException("Savepoint with name " + string + " is released.");
        }
    }

    public void verifySavepointRolledBack(int n) {
        this.verifySavepointPresent(n);
        if (!this.getSavepoint(n).isRolledBack()) {
            throw new VerifyFailedException("Savepoint with index " + n + " not rolled back.");
        }
    }

    public void verifySavepointRolledBack(String string) {
        this.verifySavepointPresent(string);
        if (!this.getSavepoint(string).isRolledBack()) {
            throw new VerifyFailedException("Savepoint with name " + string + " not rolled back.");
        }
    }

    public void verifySavepointNotRolledBack(int n) {
        this.verifySavepointPresent(n);
        if (this.getSavepoint(n).isRolledBack()) {
            throw new VerifyFailedException("Savepoint with index " + n + " is rolled back.");
        }
    }

    public void verifySavepointNotRolledBack(String string) {
        this.verifySavepointPresent(string);
        if (this.getSavepoint(string).isRolledBack()) {
            throw new VerifyFailedException("Savepoint with name " + string + " is rolled back.");
        }
    }

    public void verifySavepointRollbacked(int n) {
        this.verifySavepointRolledBack(n);
    }

    public void verifySavepointRollbacked(String string) {
        this.verifySavepointRolledBack(string);
    }

    public void verifySavepointNotRollbacked(int n) {
        this.verifySavepointNotRolledBack(n);
    }

    public void verifySavepointNotRollbacked(String string) {
        this.verifySavepointNotRolledBack(string);
    }
}

