/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.base.NestedApplicationException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class StringUtil {
    public static String replaceAll(String string, String string2, String string3) {
        if (null == string || null == string2 || null == string3) {
            throw new IllegalArgumentException("null strings not allowed");
        }
        if (string2.length() <= 0) {
            throw new IllegalArgumentException("match must not be empty");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(string3);
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static int compare(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return i - 1;
        }
        return n - 1;
    }

    public static String lowerCase(String string, int n) {
        return StringUtil.lowerCase(string, n, -1);
    }

    public static String lowerCase(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n2 <= n) {
            n2 = n + 1;
        }
        for (int i = n; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            stringBuffer.setCharAt(i, Character.toLowerCase(c));
        }
        return stringBuffer.toString();
    }

    public static String fieldToString(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == object) {
            stringBuffer.append(string + ": " + "null");
        } else if (object.getClass().isArray()) {
            StringUtil.arrayToString(string, object, stringBuffer);
        } else if (object instanceof Collection) {
            StringUtil.collectionToString(string, object, stringBuffer);
        } else if (object instanceof Map) {
            StringUtil.mapToString(string, object, stringBuffer);
        } else {
            stringBuffer.append(string + ": " + object.toString());
        }
        return stringBuffer.toString();
    }

    private static void arrayToString(String string, Object object, StringBuffer stringBuffer) {
        int n = Array.getLength(object);
        if (0 >= n) {
            stringBuffer.append(string + ": " + "empty");
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(StringUtil.fieldToString(string + " " + i, Array.get(object, i)));
                if (i >= n - 1) continue;
                stringBuffer.append("\n");
            }
        }
    }

    private static void collectionToString(String string, Object object, StringBuffer stringBuffer) {
        ArrayList arrayList = new ArrayList((Collection)object);
        if (0 >= arrayList.size()) {
            stringBuffer.append(string + ": " + "empty");
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append(StringUtil.fieldToString(string + " " + i, arrayList.get(i)));
                if (i >= arrayList.size() - 1) continue;
                stringBuffer.append("\n");
            }
        }
    }

    private static void mapToString(String string, Object object, StringBuffer stringBuffer) {
        if (0 >= ((Map)object).size()) {
            stringBuffer.append(string + ": " + "empty");
        } else {
            Iterator iterator = ((Map)object).keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = ((Map)object).get(k);
                stringBuffer.append(StringUtil.fieldToString(string + " " + k, v));
                if (n < ((Map)object).size() - 1) {
                    stringBuffer.append("\n");
                }
                ++n;
            }
        }
    }

    public static void appendObjectsAsString(StringBuffer stringBuffer, List list) {
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(list.get(i));
            stringBuffer.append("\n");
        }
    }

    public static void appendTabs(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
    }

    public static String[] split(String string, String string2, boolean bl) {
        String string3;
        int n = 0;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (-1 != (n = string.indexOf(string2, n2)) && n2 < string.length()) {
            string3 = string.substring(n2, n);
            if (bl) {
                string3 = string3.trim();
            }
            if (string3.length() == 0) {
                string3 = null;
            }
            arrayList.add(string3);
            n2 = n + string2.length();
        }
        if (n2 < string.length()) {
            string3 = string.substring(n2);
            if (bl) {
                string3 = string3.trim();
            }
            if (string3.length() == 0) {
                string3 = null;
            }
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int countMatches(String string, String string2) {
        if (null == string) {
            return 0;
        }
        if (null == string2) {
            return 0;
        }
        if (0 >= string.length()) {
            return 0;
        }
        if (0 >= string2.length()) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i <= string.length() - string2.length() && -1 != (i = string.indexOf(string2, i)); i += string2.length()) {
            ++n;
        }
        return n;
    }

    public static boolean matchesExact(String string, String string2, boolean bl) {
        if (!bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        return string.equals(string2);
    }

    public static boolean matchesContains(String string, String string2, boolean bl) {
        if (!bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        return -1 != string.indexOf(string2);
    }

    public static boolean matchesPerl5(String string, String string2, boolean bl) {
        int n = 1;
        if (bl) {
            n = 0;
        }
        try {
            Pattern pattern = new Perl5Compiler().compile(string2, n);
            return new Perl5Matcher().matches(string, pattern);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new NestedApplicationException(malformedPatternException);
        }
    }
}

