/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockDestination;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopicSubscriber;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;

public class MockTopic
extends MockDestination
implements Topic {
    private String name;

    public MockTopic(String name) {
        this.name = name;
    }

    public String getTopicName() throws JMSException {
        return this.name;
    }

    @Override
    public void addMessage(Message message) throws JMSException {
        this.addReceivedMessage(message);
        boolean isConsumed = false;
        for (MockSession session : this.sessionSet()) {
            MessageListener globalListener = session.getMessageListener();
            if (null != globalListener) {
                globalListener.onMessage(message);
                isConsumed = true;
                this.acknowledgeMessage(message, session);
                continue;
            }
            List subscribers = session.getTopicTransmissionManager().getTopicSubscriberList(this.name);
            for (int ii = 0; ii < subscribers.size(); ++ii) {
                MockTopicSubscriber subscriber = (MockTopicSubscriber)subscribers.get(ii);
                if (!subscriber.canConsume(message)) continue;
                subscriber.receiveMessage(message);
                isConsumed = true;
                this.acknowledgeMessage(message, session);
            }
            Map durableSubscribers = session.getTopicTransmissionManager().getDurableTopicSubscriberMap(this.name);
            Iterator keys = durableSubscribers.keySet().iterator();
            while (keys.hasNext()) {
                MockTopicSubscriber subscriber = (MockTopicSubscriber)durableSubscribers.get(keys.next());
                if (!subscriber.canConsume(message)) continue;
                subscriber.receiveMessage(message);
                isConsumed = true;
                this.acknowledgeMessage(message, session);
            }
        }
        if (!isConsumed) {
            this.addCurrentMessage(message);
        }
    }
}

