/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.jms.ConfigurationManager;
import com.mockrunner.jms.DestinationManager;
import com.mockrunner.jms.MessageManager;
import com.mockrunner.jms.QueueTransmissionManager;
import com.mockrunner.jms.TopicTransmissionManager;
import com.mockrunner.jms.TransmissionManagerWrapper;
import com.mockrunner.mock.jms.JMSMockObjectFactory;
import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockMessage;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockMessageProducer;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockQueueBrowser;
import com.mockrunner.mock.jms.MockQueueConnection;
import com.mockrunner.mock.jms.MockQueueConnectionFactory;
import com.mockrunner.mock.jms.MockQueueReceiver;
import com.mockrunner.mock.jms.MockQueueSender;
import com.mockrunner.mock.jms.MockQueueSession;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTemporaryQueue;
import com.mockrunner.mock.jms.MockTemporaryTopic;
import com.mockrunner.mock.jms.MockTopic;
import com.mockrunner.mock.jms.MockTopicConnection;
import com.mockrunner.mock.jms.MockTopicConnectionFactory;
import com.mockrunner.mock.jms.MockTopicPublisher;
import com.mockrunner.mock.jms.MockTopicSession;
import com.mockrunner.mock.jms.MockTopicSubscriber;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class JMSTestModule {
    private JMSMockObjectFactory mockFactory;
    private int currentQueueConnectionIndex;
    private int currentTopicConnectionIndex;
    private int currentConnectionIndex;

    public JMSTestModule(JMSMockObjectFactory mockFactory) {
        this.mockFactory = mockFactory;
        this.currentQueueConnectionIndex = -1;
        this.currentTopicConnectionIndex = -1;
        this.currentConnectionIndex = -1;
    }

    public void setCurrentQueueConnectionIndex(int connectionIndex) {
        this.currentQueueConnectionIndex = connectionIndex;
    }

    public MockQueueConnection getCurrentQueueConnection() {
        if (0 > this.currentQueueConnectionIndex) {
            return this.mockFactory.getMockQueueConnectionFactory().getLatestQueueConnection();
        }
        return this.mockFactory.getMockQueueConnectionFactory().getQueueConnection(this.currentQueueConnectionIndex);
    }

    public void setCurrentTopicConnectionIndex(int connectionIndex) {
        this.currentTopicConnectionIndex = connectionIndex;
    }

    public MockTopicConnection getCurrentTopicConnection() {
        if (0 > this.currentTopicConnectionIndex) {
            return this.mockFactory.getMockTopicConnectionFactory().getLatestTopicConnection();
        }
        return this.mockFactory.getMockTopicConnectionFactory().getTopicConnection(this.currentTopicConnectionIndex);
    }

    public void setCurrentConnectionIndex(int connectionIndex) {
        this.currentConnectionIndex = connectionIndex;
    }

    public MockConnection getCurrentConnection() {
        if (0 > this.currentConnectionIndex) {
            return this.mockFactory.getMockConnectionFactory().getLatestConnection();
        }
        return this.mockFactory.getMockConnectionFactory().getConnection(this.currentConnectionIndex);
    }

    public void registerTestMessageListenerForQueue(String queueName, MessageListener listener) {
        try {
            MockQueueConnectionFactory factory = this.mockFactory.getMockQueueConnectionFactory();
            MockQueueConnection connection = (MockQueueConnection)factory.createQueueConnection();
            this.registerTestMessageListenerForQueue(connection, queueName, listener);
        }
        catch (JMSException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void registerTestMessageListenerForQueue(MockConnection connection, String queueName, MessageListener listener) {
        this.registerTestMessageListenerForQueue(connection, queueName, true, 1, listener);
    }

    public void registerTestMessageListenerForQueue(MockConnection connection, String queueName, boolean transacted, int acknowledgeMode, MessageListener listener) {
        this.registerTestMessageListenerForQueue(connection, queueName, transacted, acknowledgeMode, null, listener);
    }

    public void registerTestMessageListenerForQueue(MockConnection connection, String queueName, boolean transacted, int acknowledgeMode, String messageSelector, MessageListener listener) {
        try {
            MockQueue queue = this.getDestinationManager().getQueue(queueName);
            MockSession session = (MockSession)connection.createSession(transacted, acknowledgeMode);
            MessageConsumer consumer = session.createConsumer(queue, messageSelector);
            consumer.setMessageListener(listener);
            connection.start();
        }
        catch (JMSException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void registerTestMessageListenerForTopic(String topicName, MessageListener listener) {
        try {
            MockTopicConnectionFactory factory = this.mockFactory.getMockTopicConnectionFactory();
            MockTopicConnection connection = (MockTopicConnection)factory.createTopicConnection();
            this.registerTestMessageListenerForTopic(connection, topicName, listener);
        }
        catch (JMSException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void registerTestMessageListenerForTopic(MockConnection connection, String topicName, MessageListener listener) {
        this.registerTestMessageListenerForTopic(connection, topicName, true, 1, listener);
    }

    public void registerTestMessageListenerForTopic(MockConnection connection, String topicName, boolean transacted, int acknowledgeMode, MessageListener listener) {
        this.registerTestMessageListenerForTopic(connection, topicName, transacted, acknowledgeMode, null, listener);
    }

    public void registerTestMessageListenerForTopic(MockConnection connection, String topicName, boolean transacted, int acknowledgeMode, String messageSelector, MessageListener listener) {
        try {
            MockTopic topic = this.getDestinationManager().getTopic(topicName);
            MockSession session = (MockSession)connection.createSession(transacted, acknowledgeMode);
            MessageConsumer consumer = session.createConsumer(topic, messageSelector);
            consumer.setMessageListener(listener);
            connection.start();
        }
        catch (JMSException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public DestinationManager getDestinationManager() {
        return this.mockFactory.getDestinationManager();
    }

    public ConfigurationManager getConfigurationManager() {
        return this.mockFactory.getConfigurationManager();
    }

    public MessageManager getQueueMessageManager(int indexOfSession) {
        MockQueueSession session = this.getQueueSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getMessageManager();
    }

    public MessageManager getTopicMessageManager(int indexOfSession) {
        MockTopicSession session = this.getTopicSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getMessageManager();
    }

    public MessageManager getMessageManager(int indexOfSession) {
        MockSession session = this.getSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getMessageManager();
    }

    public QueueTransmissionManager getQueueTransmissionManager(int indexOfSession) {
        MockQueueSession session = this.getQueueSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getQueueTransmissionManager();
    }

    public TopicTransmissionManager getTopicTransmissionManager(int indexOfSession) {
        MockTopicSession session = this.getTopicSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getTopicTransmissionManager();
    }

    public TransmissionManagerWrapper getTransmissionManager(int indexOfSession) {
        return this.getTransmissionManagerWrapper(indexOfSession);
    }

    public TransmissionManagerWrapper getTransmissionManagerWrapper(int indexOfSession) {
        MockSession session = this.getSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getTransmissionManagerWrapper();
    }

    public TransmissionManagerWrapper getQueueTransmissionManagerWrapper(int indexOfSession) {
        MockQueueSession session = this.getQueueSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getTransmissionManagerWrapper();
    }

    public TransmissionManagerWrapper getTopicTransmissionManagerWrapper(int indexOfSession) {
        MockTopicSession session = this.getTopicSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getTransmissionManagerWrapper();
    }

    public List getQueueSessionList() {
        if (null == this.getCurrentQueueConnection()) {
            return null;
        }
        return this.getCurrentQueueConnection().getQueueSessionList();
    }

    public List getTopicSessionList() {
        if (null == this.getCurrentTopicConnection()) {
            return null;
        }
        return this.getCurrentTopicConnection().getTopicSessionList();
    }

    public List getSessionList() {
        if (null == this.getCurrentConnection()) {
            return null;
        }
        return this.getCurrentConnection().getSessionList();
    }

    public MockQueueSession getQueueSession(int indexOfSession) {
        if (null == this.getCurrentQueueConnection()) {
            return null;
        }
        return this.getCurrentQueueConnection().getQueueSession(indexOfSession);
    }

    public MockTopicSession getTopicSession(int indexOfSession) {
        if (null == this.getCurrentTopicConnection()) {
            return null;
        }
        return this.getCurrentTopicConnection().getTopicSession(indexOfSession);
    }

    public MockSession getSession(int indexOfSession) {
        if (null == this.getCurrentConnection()) {
            return null;
        }
        return this.getCurrentConnection().getSession(indexOfSession);
    }

    public MockQueue getQueue(String name) {
        return this.getDestinationManager().getQueue(name);
    }

    public MockTopic getTopic(String name) {
        return this.getDestinationManager().getTopic(name);
    }

    public List getTemporaryQueueList(int indexOfSession) {
        MockQueueSession session = this.getQueueSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getTemporaryQueueList();
    }

    public List getTemporaryTopicList(int indexOfSession) {
        MockTopicSession session = this.getTopicSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getTemporaryTopicList();
    }

    public MockTemporaryQueue getTemporaryQueue(int indexOfSession, int indexOfQueue) {
        MockQueueSession session = this.getQueueSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getTemporaryQueue(indexOfQueue);
    }

    public MockTemporaryTopic getTemporaryTopic(int indexOfSession, int indexOfTopic) {
        MockTopicSession session = this.getTopicSession(indexOfSession);
        if (null == session) {
            return null;
        }
        return session.getTemporaryTopic(indexOfTopic);
    }

    public List getCurrentMessageListFromQueue(String name) {
        MockQueue queue = this.getQueue(name);
        if (null == queue) {
            return null;
        }
        return queue.getCurrentMessageList();
    }

    public List getCurrentMessageListFromTemporaryQueue(int indexOfSession, int indexOfQueue) {
        MockTemporaryQueue queue = this.getTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == queue) {
            return null;
        }
        return queue.getCurrentMessageList();
    }

    public List getReceivedMessageListFromQueue(String name) {
        MockQueue queue = this.getQueue(name);
        if (null == queue) {
            return null;
        }
        return queue.getReceivedMessageList();
    }

    public List getReceivedMessageListFromTemporaryQueue(int indexOfSession, int indexOfQueue) {
        MockTemporaryQueue queue = this.getTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == queue) {
            return null;
        }
        return queue.getReceivedMessageList();
    }

    public List getCurrentMessageListFromTopic(String name) {
        MockTopic topic = this.getTopic(name);
        if (null == topic) {
            return null;
        }
        return topic.getCurrentMessageList();
    }

    public List getCurrentMessageListFromTemporaryTopic(int indexOfSession, int indexOfTopic) {
        MockTemporaryTopic topic = this.getTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == topic) {
            return null;
        }
        return topic.getCurrentMessageList();
    }

    public List getReceivedMessageListFromTopic(String name) {
        MockTopic topic = this.getTopic(name);
        if (null == topic) {
            return null;
        }
        return topic.getReceivedMessageList();
    }

    public List getReceivedMessageListFromTemporaryTopic(int indexOfSession, int indexOfTopic) {
        MockTemporaryTopic topic = this.getTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == topic) {
            return null;
        }
        return topic.getReceivedMessageList();
    }

    public void verifyQueueConnectionClosed() {
        if (null == this.getCurrentQueueConnection()) {
            throw new VerifyFailedException("No QueueConnection present.");
        }
        if (!this.getCurrentQueueConnection().isClosed()) {
            throw new VerifyFailedException("QueueConnection is not closed.");
        }
    }

    public void verifyQueueConnectionStarted() {
        if (null == this.getCurrentQueueConnection()) {
            throw new VerifyFailedException("No QueueConnection present.");
        }
        if (!this.getCurrentQueueConnection().isStarted()) {
            throw new VerifyFailedException("QueueConnection is not started.");
        }
    }

    public void verifyQueueConnectionStopped() {
        if (null == this.getCurrentQueueConnection()) {
            throw new VerifyFailedException("No QueueConnection present.");
        }
        if (!this.getCurrentQueueConnection().isStopped()) {
            throw new VerifyFailedException("QueueConnection is not stopped.");
        }
    }

    public void verifyTopicConnectionClosed() {
        if (null == this.getCurrentTopicConnection()) {
            throw new VerifyFailedException("No TopicConnection present.");
        }
        if (!this.getCurrentTopicConnection().isClosed()) {
            throw new VerifyFailedException("TopicConnection is not closed.");
        }
    }

    public void verifyTopicConnectionStarted() {
        if (null == this.getCurrentTopicConnection()) {
            throw new VerifyFailedException("No TopicConnection present.");
        }
        if (!this.getCurrentTopicConnection().isStarted()) {
            throw new VerifyFailedException("TopicConnection is not started.");
        }
    }

    public void verifyTopicConnectionStopped() {
        if (null == this.getCurrentTopicConnection()) {
            throw new VerifyFailedException("No TopicConnection present.");
        }
        if (!this.getCurrentTopicConnection().isStopped()) {
            throw new VerifyFailedException("TopicConnection is not stopped.");
        }
    }

    public void verifyConnectionClosed() {
        if (null == this.getCurrentConnection()) {
            throw new VerifyFailedException("No Connection present.");
        }
        if (!this.getCurrentConnection().isClosed()) {
            throw new VerifyFailedException("Connection is not closed.");
        }
    }

    public void verifyConnectionStarted() {
        if (null == this.getCurrentConnection()) {
            throw new VerifyFailedException("No Connection present.");
        }
        if (!this.getCurrentConnection().isStarted()) {
            throw new VerifyFailedException("Connection is not started.");
        }
    }

    public void verifyConnectionStopped() {
        if (null == this.getCurrentConnection()) {
            throw new VerifyFailedException("No Connection present.");
        }
        if (!this.getCurrentConnection().isStopped()) {
            throw new VerifyFailedException("Connection is not stopped.");
        }
    }

    public void verifyQueueSessionClosed(int indexOfSession) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (!session.isClosed()) {
            throw new VerifyFailedException("QueueSession with index " + indexOfSession + " is not closed.");
        }
    }

    public void verifyQueueSessionCommitted(int indexOfSession) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (!session.isCommitted()) {
            throw new VerifyFailedException("QueueSession is not committed.");
        }
    }

    public void verifyQueueSessionNotCommitted(int indexOfSession) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (session.isCommitted()) {
            throw new VerifyFailedException("QueueSession is committed.");
        }
    }

    public void verifyQueueSessionNumberCommits(int indexOfSession, int numberOfCommits) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (numberOfCommits != session.getNumberCommits()) {
            throw new VerifyFailedException("QueueSession was commited " + session.getNumberCommits() + " times, expected " + numberOfCommits + " times");
        }
    }

    public void verifyQueueSessionRolledBack(int indexOfSession) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (!session.isRolledBack()) {
            throw new VerifyFailedException("QueueSession is not rolled back.");
        }
    }

    public void verifyQueueSessionNotRolledBack(int indexOfSession) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (session.isRolledBack()) {
            throw new VerifyFailedException("QueueSession is rolled back.");
        }
    }

    public void verifyQueueSessionNumberRollbacks(int indexOfSession, int numberOfRollbacks) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (numberOfRollbacks != session.getNumberRollbacks()) {
            throw new VerifyFailedException("QueueSession was rolled back " + session.getNumberRollbacks() + " times, expected " + numberOfRollbacks + " times");
        }
    }

    public void verifyQueueSessionRecovered(int indexOfSession) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (!session.isRecovered()) {
            throw new VerifyFailedException("QueueSession is not recovered.");
        }
    }

    public void verifyQueueSessionNotRecovered(int indexOfSession) {
        MockQueueSession session = this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (session.isRecovered()) {
            throw new VerifyFailedException("QueueSession is recovered.");
        }
    }

    public void verifyTopicSessionClosed(int indexOfSession) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (!session.isClosed()) {
            throw new VerifyFailedException("TopicSession with index " + indexOfSession + " is not closed.");
        }
    }

    public void verifyTopicSessionCommitted(int indexOfSession) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (!session.isCommitted()) {
            throw new VerifyFailedException("TopicSession is not committed.");
        }
    }

    public void verifyTopicSessionNotCommitted(int indexOfSession) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (session.isCommitted()) {
            throw new VerifyFailedException("TopicSession is committed.");
        }
    }

    public void verifyTopicSessionNumberCommits(int indexOfSession, int numberOfCommits) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (numberOfCommits != session.getNumberCommits()) {
            throw new VerifyFailedException("TopicSession was commited " + session.getNumberCommits() + " times, expected " + numberOfCommits + " times");
        }
    }

    public void verifyTopicSessionRolledBack(int indexOfSession) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (!session.isRolledBack()) {
            throw new VerifyFailedException("TopicSession is not rolled back.");
        }
    }

    public void verifyTopicSessionNotRolledBack(int indexOfSession) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (session.isRolledBack()) {
            throw new VerifyFailedException("TopicSession is rolled back.");
        }
    }

    public void verifyTopicSessionNumberRollbacks(int indexOfSession, int numberOfRollbacks) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (numberOfRollbacks != session.getNumberRollbacks()) {
            throw new VerifyFailedException("TopicSession was rolled back " + session.getNumberRollbacks() + " times, expected " + numberOfRollbacks + " times");
        }
    }

    public void verifyTopicSessionRecovered(int indexOfSession) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (!session.isRecovered()) {
            throw new VerifyFailedException("TopicSession is not recovered.");
        }
    }

    public void verifyTopicSessionNotRecovered(int indexOfSession) {
        MockTopicSession session = this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (session.isRecovered()) {
            throw new VerifyFailedException("TopicSession is recovered.");
        }
    }

    public void verifySessionClosed(int indexOfSession) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (!session.isClosed()) {
            throw new VerifyFailedException("Session with index " + indexOfSession + " is not closed.");
        }
    }

    public void verifySessionCommitted(int indexOfSession) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (!session.isCommitted()) {
            throw new VerifyFailedException("Session is not committed.");
        }
    }

    public void verifySessionNotCommitted(int indexOfSession) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (session.isCommitted()) {
            throw new VerifyFailedException("Session is committed.");
        }
    }

    public void verifySessionNumberCommits(int indexOfSession, int numberOfCommits) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (numberOfCommits != session.getNumberCommits()) {
            throw new VerifyFailedException("Session was commited " + session.getNumberCommits() + " times, expected " + numberOfCommits + " times");
        }
    }

    public void verifySessionRolledBack(int indexOfSession) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (!session.isRolledBack()) {
            throw new VerifyFailedException("Session is not rolled back.");
        }
    }

    public void verifySessionNotRolledBack(int indexOfSession) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (session.isRolledBack()) {
            throw new VerifyFailedException("Session is rolled back.");
        }
    }

    public void verifySessionNumberRollbacks(int indexOfSession, int numberOfRollbacks) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (numberOfRollbacks != session.getNumberRollbacks()) {
            throw new VerifyFailedException("Session was rolled back " + session.getNumberRollbacks() + " times, expected " + numberOfRollbacks + " times");
        }
    }

    public void verifySessionRecovered(int indexOfSession) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (!session.isRecovered()) {
            throw new VerifyFailedException("Session is not recovered.");
        }
    }

    public void verifySessionNotRecovered(int indexOfSession) {
        MockSession session = this.checkAndGetSessionByIndex(indexOfSession);
        if (session.isRecovered()) {
            throw new VerifyFailedException("Session is recovered.");
        }
    }

    public void verifyAllQueueSessionsClosed() {
        List queueSessions = this.getQueueSessionList();
        if (null == queueSessions) {
            return;
        }
        for (int ii = 0; ii < queueSessions.size(); ++ii) {
            MockQueueSession currentSession = (MockQueueSession)queueSessions.get(ii);
            if (currentSession.isClosed()) continue;
            throw new VerifyFailedException("QueueSession with index " + ii + " is not closed.");
        }
    }

    public void verifyAllQueueSessionsRecovered() {
        List queueSessions = this.getQueueSessionList();
        if (null == queueSessions) {
            return;
        }
        for (int ii = 0; ii < queueSessions.size(); ++ii) {
            MockQueueSession currentSession = (MockQueueSession)queueSessions.get(ii);
            if (currentSession.isRecovered()) continue;
            throw new VerifyFailedException("QueueSession with index " + ii + " is not recovered.");
        }
    }

    public void verifyAllQueueSessionsCommitted() {
        List queueSessions = this.getQueueSessionList();
        if (null == queueSessions) {
            return;
        }
        for (int ii = 0; ii < queueSessions.size(); ++ii) {
            MockQueueSession currentSession = (MockQueueSession)queueSessions.get(ii);
            if (currentSession.isCommitted()) continue;
            throw new VerifyFailedException("QueueSession with index " + ii + " is not committed.");
        }
    }

    public void verifyAllQueueSessionsRolledBack() {
        List queueSessions = this.getQueueSessionList();
        if (null == queueSessions) {
            return;
        }
        for (int ii = 0; ii < queueSessions.size(); ++ii) {
            MockQueueSession currentSession = (MockQueueSession)queueSessions.get(ii);
            if (currentSession.isRolledBack()) continue;
            throw new VerifyFailedException("QueueSession with index " + ii + " is not rolled back.");
        }
    }

    public void verifyAllTopicSessionsClosed() {
        List topicSessions = this.getTopicSessionList();
        if (null == topicSessions) {
            return;
        }
        for (int ii = 0; ii < topicSessions.size(); ++ii) {
            MockTopicSession currentSession = (MockTopicSession)topicSessions.get(ii);
            if (currentSession.isClosed()) continue;
            throw new VerifyFailedException("TopicSession with index " + ii + " is not closed.");
        }
    }

    public void verifyAllTopicSessionsRecovered() {
        List topicSessions = this.getTopicSessionList();
        if (null == topicSessions) {
            return;
        }
        for (int ii = 0; ii < topicSessions.size(); ++ii) {
            MockTopicSession currentSession = (MockTopicSession)topicSessions.get(ii);
            if (currentSession.isRecovered()) continue;
            throw new VerifyFailedException("TopicSession with index " + ii + " is not recovered.");
        }
    }

    public void verifyAllTopicSessionsCommitted() {
        List topicSessions = this.getTopicSessionList();
        if (null == topicSessions) {
            return;
        }
        for (int ii = 0; ii < topicSessions.size(); ++ii) {
            MockTopicSession currentSession = (MockTopicSession)topicSessions.get(ii);
            if (currentSession.isCommitted()) continue;
            throw new VerifyFailedException("TopicSession with index " + ii + " is not committed.");
        }
    }

    public void verifyAllTopicSessionsRolledBack() {
        List topicSessions = this.getTopicSessionList();
        if (null == topicSessions) {
            return;
        }
        for (int ii = 0; ii < topicSessions.size(); ++ii) {
            MockTopicSession currentSession = (MockTopicSession)topicSessions.get(ii);
            if (currentSession.isRolledBack()) continue;
            throw new VerifyFailedException("TopicSession with index " + ii + " is not rolled back.");
        }
    }

    public void verifyAllSessionsClosed() {
        List sessions = this.getSessionList();
        if (null == sessions) {
            return;
        }
        for (int ii = 0; ii < sessions.size(); ++ii) {
            MockSession currentSession = (MockSession)sessions.get(ii);
            if (currentSession.isClosed()) continue;
            throw new VerifyFailedException("Session with index " + ii + " is not closed.");
        }
    }

    public void verifyAllSessionsRecovered() {
        List sessions = this.getSessionList();
        if (null == sessions) {
            return;
        }
        for (int ii = 0; ii < sessions.size(); ++ii) {
            MockSession currentSession = (MockSession)sessions.get(ii);
            if (currentSession.isRecovered()) continue;
            throw new VerifyFailedException("Session with index " + ii + " is not recovered.");
        }
    }

    public void verifyAllSessionsCommitted() {
        List sessions = this.getSessionList();
        if (null == sessions) {
            return;
        }
        for (int ii = 0; ii < sessions.size(); ++ii) {
            MockSession currentSession = (MockSession)sessions.get(ii);
            if (currentSession.isCommitted()) continue;
            throw new VerifyFailedException("Session with index " + ii + " is not committed.");
        }
    }

    public void verifyAllSessionsRolledBack() {
        List sessions = this.getSessionList();
        if (null == sessions) {
            return;
        }
        for (int ii = 0; ii < sessions.size(); ++ii) {
            MockSession currentSession = (MockSession)sessions.get(ii);
            if (currentSession.isRolledBack()) continue;
            throw new VerifyFailedException("Session with index " + ii + " is not rolled back.");
        }
    }

    public void verifyNumberMessageProducers(int indexOfSession, int numberOfProducers) {
        this.checkAndGetSessionByIndex(indexOfSession);
        TransmissionManagerWrapper manager = this.getTransmissionManagerWrapper(indexOfSession);
        if (numberOfProducers != manager.getMessageProducerList().size()) {
            throw new VerifyFailedException("Expected " + numberOfProducers + " producers, actually " + manager.getMessageProducerList().size() + " producers present");
        }
    }

    public void verifyAllMessageProducersClosed(int indexOfSession) {
        this.checkAndGetSessionByIndex(indexOfSession);
        TransmissionManagerWrapper manager = this.getTransmissionManagerWrapper(indexOfSession);
        List producers = manager.getMessageProducerList();
        for (int ii = 0; ii < producers.size(); ++ii) {
            MockMessageProducer currentProducer = (MockMessageProducer)producers.get(ii);
            if (currentProducer.isClosed()) continue;
            throw new VerifyFailedException("MessageProducer with index " + ii + " not closed.");
        }
    }

    public void verifyNumberQueueSenders(int indexOfSession, int numberOfSenders) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        TransmissionManagerWrapper manager = this.getQueueTransmissionManagerWrapper(indexOfSession);
        if (numberOfSenders != manager.getQueueSenderList().size()) {
            throw new VerifyFailedException("Expected " + numberOfSenders + " senders, actually " + manager.getQueueSenderList().size() + " senders present");
        }
    }

    public void verifyNumberQueueSenders(int indexOfSession, String queueName, int numberOfSenders) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        this.checkQueueByName(queueName);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        if (numberOfSenders != manager.getQueueSenderList(queueName).size()) {
            throw new VerifyFailedException("Expected " + numberOfSenders + " senders for queue " + queueName + ", actually " + manager.getQueueSenderList(queueName).size() + " senders present");
        }
    }

    public void verifyQueueSenderClosed(int indexOfSession, String queueName, int indexOfSender) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        this.checkQueueByName(queueName);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        List senders = manager.getQueueSenderList(queueName);
        if (indexOfSender >= senders.size()) {
            throw new VerifyFailedException("QueueSender with index " + indexOfSender + " is not present.");
        }
        MockQueueSender sender = (MockQueueSender)senders.get(indexOfSender);
        if (!sender.isClosed()) {
            throw new VerifyFailedException("QueueSender of queue " + queueName + " with index " + indexOfSender + " not closed.");
        }
    }

    public void verifyAllQueueSendersClosed(int indexOfSession) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        TransmissionManagerWrapper manager = this.getQueueTransmissionManagerWrapper(indexOfSession);
        List senders = manager.getQueueSenderList();
        for (int ii = 0; ii < senders.size(); ++ii) {
            MockQueueSender currentSender = (MockQueueSender)senders.get(ii);
            if (currentSender.isClosed()) continue;
            throw new VerifyFailedException("QueueSender with index " + ii + " not closed.");
        }
    }

    public void verifyNumberTopicPublishers(int indexOfSession, int numberOfPublishers) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        TransmissionManagerWrapper manager = this.getTopicTransmissionManagerWrapper(indexOfSession);
        if (numberOfPublishers != manager.getTopicPublisherList().size()) {
            throw new VerifyFailedException("Expected " + numberOfPublishers + " publishers, actually " + manager.getTopicPublisherList().size() + " publishers present");
        }
    }

    public void verifyNumberTopicPublishers(int indexOfSession, String topicName, int numberOfPublishers) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        this.checkTopicByName(topicName);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        if (numberOfPublishers != manager.getTopicPublisherList(topicName).size()) {
            throw new VerifyFailedException("Expected " + numberOfPublishers + " publishers for topic " + topicName + ", actually " + manager.getTopicPublisherList(topicName).size() + " publishers present");
        }
    }

    public void verifyTopicPublisherClosed(int indexOfSession, String topicName, int indexOfPublisher) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        this.checkTopicByName(topicName);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        List publishers = manager.getTopicPublisherList(topicName);
        if (indexOfPublisher >= publishers.size()) {
            throw new VerifyFailedException("TopicPublisher with index " + indexOfPublisher + " is not present.");
        }
        MockTopicPublisher publisher = (MockTopicPublisher)publishers.get(indexOfPublisher);
        if (!publisher.isClosed()) {
            throw new VerifyFailedException("TopicPublisher of topic " + topicName + " with index " + indexOfPublisher + " not closed.");
        }
    }

    public void verifyAllTopicPublishersClosed(int indexOfSession) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        TransmissionManagerWrapper manager = this.getTopicTransmissionManagerWrapper(indexOfSession);
        List publishers = manager.getTopicPublisherList();
        for (int ii = 0; ii < publishers.size(); ++ii) {
            MockTopicPublisher currentPublisher = (MockTopicPublisher)publishers.get(ii);
            if (currentPublisher.isClosed()) continue;
            throw new VerifyFailedException("TopicPublisher with index " + ii + " not closed.");
        }
    }

    public void verifyNumberMessageConsumers(int indexOfSession, int numberOfConsumers) {
        this.checkAndGetSessionByIndex(indexOfSession);
        TransmissionManagerWrapper manager = this.getTransmissionManagerWrapper(indexOfSession);
        if (numberOfConsumers != manager.getMessageConsumerList().size()) {
            throw new VerifyFailedException("Expected " + numberOfConsumers + " consumers, actually " + manager.getMessageConsumerList().size() + " consumers present");
        }
    }

    public void verifyAllMessageConsumersClosed(int indexOfSession) {
        this.checkAndGetSessionByIndex(indexOfSession);
        TransmissionManagerWrapper manager = this.getTransmissionManagerWrapper(indexOfSession);
        List consumers = manager.getMessageConsumerList();
        for (int ii = 0; ii < consumers.size(); ++ii) {
            MockMessageConsumer currentConsumer = (MockMessageConsumer)consumers.get(ii);
            if (currentConsumer.isClosed()) continue;
            throw new VerifyFailedException("MessageConsumer with index " + ii + " not closed.");
        }
    }

    public void verifyNumberQueueReceivers(int indexOfSession, int numberOfReceivers) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        if (numberOfReceivers != manager.getQueueReceiverList().size()) {
            throw new VerifyFailedException("Expected " + numberOfReceivers + " receivers, actually " + manager.getQueueReceiverList().size() + " receivers present");
        }
    }

    public void verifyNumberQueueReceivers(int indexOfSession, String queueName, int numberOfReceivers) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        this.checkQueueByName(queueName);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        if (numberOfReceivers != manager.getQueueReceiverList(queueName).size()) {
            throw new VerifyFailedException("Expected " + numberOfReceivers + " receivers for queue " + queueName + ", actually " + manager.getQueueReceiverList(queueName).size() + " receivers present");
        }
    }

    public void verifyQueueReceiverClosed(int indexOfSession, String queueName, int indexOfReceiver) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        this.checkQueueByName(queueName);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        List receivers = manager.getQueueReceiverList(queueName);
        if (indexOfReceiver >= receivers.size()) {
            throw new VerifyFailedException("QueueReceiver with index " + indexOfReceiver + " is not present.");
        }
        MockQueueReceiver receiver = (MockQueueReceiver)receivers.get(indexOfReceiver);
        if (!receiver.isClosed()) {
            throw new VerifyFailedException("QueueReceiver of queue " + queueName + " with index " + indexOfReceiver + " not closed.");
        }
    }

    public void verifyAllQueueReceiversClosed(int indexOfSession) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        List receivers = manager.getQueueReceiverList();
        for (int ii = 0; ii < receivers.size(); ++ii) {
            MockQueueReceiver currentReceiver = (MockQueueReceiver)receivers.get(ii);
            if (currentReceiver.isClosed()) continue;
            throw new VerifyFailedException("QueueReceiver with index " + ii + " not closed.");
        }
    }

    public void verifyNumberTopicSubscribers(int indexOfSession, int numberOfSubscribers) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        if (numberOfSubscribers != manager.getTopicSubscriberList().size()) {
            throw new VerifyFailedException("Expected " + numberOfSubscribers + " subscribers, actually " + manager.getTopicSubscriberList().size() + " subscribers present");
        }
    }

    public void verifyNumberTopicSubscribers(int indexOfSession, String topicName, int numberOfSubscribers) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        this.checkTopicByName(topicName);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        if (numberOfSubscribers != manager.getTopicSubscriberList(topicName).size()) {
            throw new VerifyFailedException("Expected " + numberOfSubscribers + " subscribers for topic " + topicName + ", actually " + manager.getTopicSubscriberList(topicName).size() + " subscribers present");
        }
    }

    public void verifyTopicSubscriberClosed(int indexOfSession, String topicName, int indexOfSubscriber) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        this.checkTopicByName(topicName);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        List subscribers = manager.getTopicSubscriberList(topicName);
        if (indexOfSubscriber >= subscribers.size()) {
            throw new VerifyFailedException("TopicSubscriber with index " + indexOfSubscriber + " is not present.");
        }
        MockTopicSubscriber subscriber = (MockTopicSubscriber)subscribers.get(indexOfSubscriber);
        if (!subscriber.isClosed()) {
            throw new VerifyFailedException("TopicSubscriber of topic " + topicName + " with index " + indexOfSubscriber + " not closed.");
        }
    }

    public void verifyAllTopicSubscribersClosed(int indexOfSession) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        List subscribers = manager.getTopicSubscriberList();
        for (int ii = 0; ii < subscribers.size(); ++ii) {
            MockTopicSubscriber currentSubscriber = (MockTopicSubscriber)subscribers.get(ii);
            if (currentSubscriber.isClosed()) continue;
            throw new VerifyFailedException("TopicSubscriber with index " + ii + " not closed.");
        }
    }

    public void verifyNumberQueueBrowsers(int indexOfSession, int numberOfBrowsers) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        if (numberOfBrowsers != manager.getQueueBrowserList().size()) {
            throw new VerifyFailedException("Expected " + numberOfBrowsers + " browsers, actually " + manager.getQueueBrowserList().size() + " browsers present");
        }
    }

    public void verifyNumberQueueBrowsers(int indexOfSession, String queueName, int numberOfBrowsers) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        this.checkQueueByName(queueName);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        if (numberOfBrowsers != manager.getQueueBrowserList(queueName).size()) {
            throw new VerifyFailedException("Expected " + numberOfBrowsers + " browsers for queue " + queueName + ", actually " + manager.getQueueBrowserList(queueName).size() + " browsers present");
        }
    }

    public void verifyQueueBrowserClosed(int indexOfSession, String queueName, int indexOfBrowser) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        this.checkQueueByName(queueName);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        List browsers = manager.getQueueBrowserList(queueName);
        if (indexOfBrowser >= browsers.size()) {
            throw new VerifyFailedException("QueueBrowser with index " + indexOfBrowser + " is not present.");
        }
        MockQueueBrowser browser = (MockQueueBrowser)browsers.get(indexOfBrowser);
        if (!browser.isClosed()) {
            throw new VerifyFailedException("QueueBrowser of queue " + queueName + " with index " + indexOfBrowser + " not closed.");
        }
    }

    public void verifyAllQueueBrowsersClosed(int indexOfSession) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        QueueTransmissionManager manager = this.getQueueTransmissionManager(indexOfSession);
        List browsers = manager.getQueueBrowserList();
        for (int ii = 0; ii < browsers.size(); ++ii) {
            MockQueueBrowser currentBrowser = (MockQueueBrowser)browsers.get(ii);
            if (currentBrowser.isClosed()) continue;
            throw new VerifyFailedException("QueueBrowser with index " + ii + " not closed.");
        }
    }

    public void verifyDurableTopicSubscriberPresent(int indexOfSession, String name) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        if (null == manager.getDurableTopicSubscriber(name)) {
            throw new VerifyFailedException("Durable subscriber with subscription name " + name + " not present.");
        }
    }

    public void verifyNumberDurableTopicSubscribers(int indexOfSession, int numberOfSubscribers) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        if (numberOfSubscribers != manager.getDurableTopicSubscriberMap().size()) {
            throw new VerifyFailedException("Expected " + numberOfSubscribers + " durable subscribers, actually " + manager.getDurableTopicSubscriberMap().size() + " durable subscribers present");
        }
    }

    public void verifyNumberDurableTopicSubscribers(int indexOfSession, String topicName, int numberOfSubscribers) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        this.checkTopicByName(topicName);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        if (numberOfSubscribers != manager.getDurableTopicSubscriberMap(topicName).size()) {
            throw new VerifyFailedException("Expected " + numberOfSubscribers + " durable subscribers for topic " + topicName + ", actually " + manager.getDurableTopicSubscriberMap(topicName).size() + " durable subscribers present");
        }
    }

    public void verifyDurableTopicSubscriberClosed(int indexOfSession, String name) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        MockTopicSubscriber subscriber = manager.getDurableTopicSubscriber(name);
        if (null == subscriber) {
            throw new VerifyFailedException("Durable TopicSubscriber with subscription name " + name + " not present.");
        }
        if (!subscriber.isClosed()) {
            throw new VerifyFailedException("Durable TopicSubscriber with subscription name " + name + " not closed.");
        }
    }

    public void verifyAllDurableTopicSubscribersClosed(int indexOfSession) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        TopicTransmissionManager manager = this.getTopicTransmissionManager(indexOfSession);
        Iterator keys = manager.getDurableTopicSubscriberMap().keySet().iterator();
        while (keys.hasNext()) {
            MockTopicSubscriber currentSubscriber = (MockTopicSubscriber)manager.getDurableTopicSubscriberMap().get(keys.next());
            if (currentSubscriber.isClosed()) continue;
            throw new VerifyFailedException("Durable TopicSubscriber with name " + currentSubscriber.getName() + " not closed.");
        }
    }

    public void verifyNumberQueueSessions(int number) {
        if (number != this.getQueueSessionList().size()) {
            throw new VerifyFailedException("Expected " + number + " queue sessions, actually " + this.getQueueSessionList().size() + " sessions present");
        }
    }

    public void verifyNumberTopicSessions(int number) {
        if (number != this.getTopicSessionList().size()) {
            throw new VerifyFailedException("Expected " + number + " topic sessions, actually " + this.getTopicSessionList().size() + " sessions present");
        }
    }

    public void verifyNumberSessions(int number) {
        if (number != this.getSessionList().size()) {
            throw new VerifyFailedException("Expected " + number + " sessions, actually " + this.getSessionList().size() + " sessions present");
        }
    }

    public void verifyNumberTemporaryQueues(int indexOfSession, int numberQueues) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (numberQueues != this.getTemporaryQueueList(indexOfSession).size()) {
            throw new VerifyFailedException("Expected " + numberQueues + " temporary queues, actually " + this.getTemporaryQueueList(indexOfSession).size() + " temporary queues present");
        }
    }

    public void verifyNumberTemporaryTopics(int indexOfSession, int numberTopics) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (numberTopics != this.getTemporaryTopicList(indexOfSession).size()) {
            throw new VerifyFailedException("Expected " + numberTopics + " temporary topics, actually " + this.getTemporaryTopicList(indexOfSession).size() + " temporary topics present");
        }
    }

    public void verifyTemporaryQueueDeleted(int indexOfSession, int indexOfQueue) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        MockTemporaryQueue queue = this.getTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == queue) {
            throw new VerifyFailedException("TemporaryQueue with index " + indexOfQueue + " is not present.");
        }
        if (!queue.isDeleted()) {
            throw new VerifyFailedException("TemporaryQueue with index " + indexOfQueue + " not deleted.");
        }
    }

    public void verifyAllTemporaryQueuesDeleted(int indexOfSession) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List queueList = this.getTemporaryQueueList(indexOfSession);
        for (int ii = 0; ii < queueList.size(); ++ii) {
            MockTemporaryQueue currentQueue = (MockTemporaryQueue)queueList.get(ii);
            if (currentQueue.isDeleted()) continue;
            throw new VerifyFailedException("TemporaryQueue with index " + ii + " not deleted.");
        }
    }

    public void verifyTemporaryTopicDeleted(int indexOfSession, int indexOfTopic) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        MockTemporaryTopic topic = this.getTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == topic) {
            throw new VerifyFailedException("TemporaryTopic with index " + indexOfTopic + " is not present.");
        }
        if (!topic.isDeleted()) {
            throw new VerifyFailedException("TemporaryTopic with index " + indexOfTopic + " not deleted.");
        }
    }

    public void verifyAllTemporaryTopicsDeleted(int indexOfSession) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List topicList = this.getTemporaryTopicList(indexOfSession);
        for (int ii = 0; ii < topicList.size(); ++ii) {
            MockTemporaryTopic currentTopic = (MockTemporaryTopic)topicList.get(ii);
            if (currentTopic.isDeleted()) continue;
            throw new VerifyFailedException("TemporaryTopic with index " + ii + " not deleted.");
        }
    }

    public void verifyMessageEquals(MockMessage message1, MockMessage message2) {
        if (null == message1) {
            throw new VerifyFailedException("message1 is null");
        }
        if (null == message2) {
            throw new VerifyFailedException("message2 is null");
        }
        if (!message1.equals(message2)) {
            throw new VerifyFailedException("messages not equal: message1: " + message1.toString() + ", message2: " + message2.toString());
        }
    }

    public void verifyCurrentQueueMessageEquals(String nameOfQueue, int indexOfSourceMessage, MockMessage targetMessage) {
        this.checkQueueByName(nameOfQueue);
        List messageList = this.getCurrentMessageListFromQueue(nameOfQueue);
        if (indexOfSourceMessage >= messageList.size()) {
            throw new VerifyFailedException("Queue " + nameOfQueue + " contains only " + messageList.size() + " messages");
        }
        MockMessage sourceMessage = (MockMessage)messageList.get(indexOfSourceMessage);
        this.verifyMessageEquals(sourceMessage, targetMessage);
    }

    public void verifyReceivedQueueMessageEquals(String nameOfQueue, int indexOfSourceMessage, MockMessage targetMessage) {
        this.checkQueueByName(nameOfQueue);
        List messageList = this.getReceivedMessageListFromQueue(nameOfQueue);
        if (indexOfSourceMessage >= messageList.size()) {
            throw new VerifyFailedException("Queue " + nameOfQueue + " received only " + messageList.size() + " messages");
        }
        MockMessage sourceMessage = (MockMessage)messageList.get(indexOfSourceMessage);
        this.verifyMessageEquals(sourceMessage, targetMessage);
    }

    public void verifyCurrentQueueMessageEquals(int indexOfSession, int indexOfQueue, int indexOfSourceMessage, MockMessage targetMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getCurrentMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " of session with index " + indexOfSession + " does not exist");
        }
        if (indexOfSourceMessage >= messageList.size()) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " contains only " + messageList.size() + " messages");
        }
        MockMessage sourceMessage = (MockMessage)messageList.get(indexOfSourceMessage);
        this.verifyMessageEquals(sourceMessage, targetMessage);
    }

    public void verifyReceivedQueueMessageEquals(int indexOfSession, int indexOfQueue, int indexOfSourceMessage, MockMessage targetMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getReceivedMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " of session with index " + indexOfSession + " does not exist");
        }
        if (indexOfSourceMessage >= messageList.size()) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " received only " + messageList.size() + " messages");
        }
        MockMessage sourceMessage = (MockMessage)messageList.get(indexOfSourceMessage);
        this.verifyMessageEquals(sourceMessage, targetMessage);
    }

    public void verifyNumberOfCurrentQueueMessages(String nameOfQueue, int numberOfMessages) {
        this.checkQueueByName(nameOfQueue);
        List list = this.getCurrentMessageListFromQueue(nameOfQueue);
        if (numberOfMessages != list.size()) {
            throw new VerifyFailedException("Expected " + numberOfMessages + " messages in queue " + nameOfQueue + ", received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfReceivedQueueMessages(String nameOfQueue, int numberOfMessages) {
        this.checkQueueByName(nameOfQueue);
        List list = this.getReceivedMessageListFromQueue(nameOfQueue);
        if (numberOfMessages != list.size()) {
            throw new VerifyFailedException("Expected " + numberOfMessages + " messages received by queue " + nameOfQueue + ", received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfCurrentQueueMessages(int indexOfSession, int indexOfQueue, int numberOfMessages) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List list = this.getCurrentMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " of session with index " + indexOfSession + " does not exist");
        }
        if (numberOfMessages != list.size()) {
            throw new VerifyFailedException("Expected " + numberOfMessages + " messages, received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfReceivedQueueMessages(int indexOfSession, int indexOfQueue, int numberOfMessages) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List list = this.getReceivedMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == list) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " of session with index " + indexOfSession + " does not exist");
        }
        if (numberOfMessages != list.size()) {
            throw new VerifyFailedException("Expected " + numberOfMessages + " messages, received " + list.size() + " messages");
        }
    }

    public void verifyAllReceivedQueueMessagesAcknowledged(String nameOfQueue) {
        this.checkQueueByName(nameOfQueue);
        List messageList = this.getReceivedMessageListFromQueue(nameOfQueue);
        for (int ii = 0; ii < messageList.size(); ++ii) {
            MockMessage currentMessage = (MockMessage)messageList.get(ii);
            if (currentMessage.isAcknowledged()) continue;
            throw new VerifyFailedException("Message " + ii + " of queue " + nameOfQueue + " is not acknowledged");
        }
    }

    public void verifyAllReceivedQueueMessagesAcknowledged(int indexOfSession, int indexOfQueue) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getReceivedMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " of session with index " + indexOfSession + " does not exist");
        }
        for (int ii = 0; ii < messageList.size(); ++ii) {
            MockMessage currentMessage = (MockMessage)messageList.get(ii);
            if (currentMessage.isAcknowledged()) continue;
            throw new VerifyFailedException("Message " + ii + " of temporary queue " + indexOfQueue + " is not acknowledged");
        }
    }

    public void verifyReceivedQueueMessageAcknowledged(String nameOfQueue, int indexOfMessage) {
        this.checkQueueByName(nameOfQueue);
        List messageList = this.getReceivedMessageListFromQueue(nameOfQueue);
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Queue " + nameOfQueue + " received only " + messageList.size() + " messages");
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of queue " + nameOfQueue + " is not acknowledged");
        }
    }

    public void verifyReceivedQueueMessageNotAcknowledged(String nameOfQueue, int indexOfMessage) {
        this.checkQueueByName(nameOfQueue);
        List messageList = this.getReceivedMessageListFromQueue(nameOfQueue);
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Queue " + nameOfQueue + " received only " + messageList.size() + " messages");
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of queue " + nameOfQueue + " is acknowledged");
        }
    }

    public void verifyReceivedQueueMessageAcknowledged(int indexOfSession, int indexOfQueue, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getReceivedMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " of session with index " + indexOfSession + " does not exist");
        }
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " received only " + messageList.size() + " messages");
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of temporary queue " + indexOfQueue + " is not acknowledged");
        }
    }

    public void verifyReceivedQueueMessageNotAcknowledged(int indexOfSession, int indexOfQueue, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getReceivedMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " of session with index " + indexOfSession + " does not exist");
        }
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Temporary queue with index " + indexOfQueue + " received only " + messageList.size() + " messages");
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of temporary queue " + indexOfQueue + " is acknowledged");
        }
    }

    public void verifyNumberOfCreatedQueueMessages(int indexOfSession, int number) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (number != this.getQueueMessageManager(indexOfSession).getMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " messages, received " + this.getQueueMessageManager(indexOfSession).getMessageList().size() + " messages");
        }
    }

    public void verifyNumberOfCreatedQueueBytesMessages(int indexOfSession, int number) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (number != this.getQueueMessageManager(indexOfSession).getBytesMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " bytes messages, received " + this.getQueueMessageManager(indexOfSession).getBytesMessageList().size() + " bytes messages");
        }
    }

    public void verifyNumberOfCreatedQueueMapMessages(int indexOfSession, int number) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (number != this.getQueueMessageManager(indexOfSession).getMapMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " map messages, received " + this.getQueueMessageManager(indexOfSession).getMapMessageList().size() + " map messages");
        }
    }

    public void verifyNumberOfCreatedQueueTextMessages(int indexOfSession, int number) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (number != this.getQueueMessageManager(indexOfSession).getTextMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " text messages, received " + this.getQueueMessageManager(indexOfSession).getTextMessageList().size() + " text messages");
        }
    }

    public void verifyNumberOfCreatedQueueStreamMessages(int indexOfSession, int number) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (number != this.getQueueMessageManager(indexOfSession).getStreamMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " stream messages, received " + this.getQueueMessageManager(indexOfSession).getStreamMessageList().size() + " stream messages");
        }
    }

    public void verifyNumberOfCreatedQueueObjectMessages(int indexOfSession, int number) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        if (number != this.getQueueMessageManager(indexOfSession).getObjectMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " object messages, received " + this.getQueueMessageManager(indexOfSession).getObjectMessageList().size() + " object messages");
        }
    }

    public void verifyCreatedQueueMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedQueueBytesMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getBytesMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " bytes messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueBytesMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getBytesMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " bytes messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedQueueMapMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getMapMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " map messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueMapMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getMapMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " map messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedQueueTextMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getTextMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " text messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueTextMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getTextMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " text messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedQueueStreamMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getStreamMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " stream messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueStreamMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getStreamMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " stream messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedQueueObjectMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getObjectMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " object messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedQueueObjectMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetQueueSessionByIndex(indexOfSession);
        List messageList = this.getQueueMessageManager(indexOfSession).getObjectMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " object messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCurrentTopicMessageEquals(String nameOfTopic, int indexOfSourceMessage, MockMessage targetMessage) {
        this.checkTopicByName(nameOfTopic);
        List messageList = this.getCurrentMessageListFromTopic(nameOfTopic);
        if (indexOfSourceMessage >= messageList.size()) {
            throw new VerifyFailedException("Topic " + nameOfTopic + " contains only " + messageList.size() + " messages");
        }
        MockMessage sourceMessage = (MockMessage)messageList.get(indexOfSourceMessage);
        this.verifyMessageEquals(sourceMessage, targetMessage);
    }

    public void verifyReceivedTopicMessageEquals(String nameOfTopic, int indexOfSourceMessage, MockMessage targetMessage) {
        this.checkTopicByName(nameOfTopic);
        List messageList = this.getReceivedMessageListFromTopic(nameOfTopic);
        if (indexOfSourceMessage >= messageList.size()) {
            throw new VerifyFailedException("Topic " + nameOfTopic + " received only " + messageList.size() + " messages");
        }
        MockMessage sourceMessage = (MockMessage)messageList.get(indexOfSourceMessage);
        this.verifyMessageEquals(sourceMessage, targetMessage);
    }

    public void verifyCurrentTopicMessageEquals(int indexOfSession, int indexOfTopic, int indexOfSourceMessage, MockMessage targetMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getCurrentMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " of session with index " + indexOfSession + " does not exist");
        }
        if (indexOfSourceMessage >= messageList.size()) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " contains only " + messageList.size() + " messages");
        }
        MockMessage sourceMessage = (MockMessage)messageList.get(indexOfSourceMessage);
        this.verifyMessageEquals(sourceMessage, targetMessage);
    }

    public void verifyReceivedTopicMessageEquals(int indexOfSession, int indexOfTopic, int indexOfSourceMessage, MockMessage targetMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getReceivedMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " of session with index " + indexOfSession + " does not exist");
        }
        if (indexOfSourceMessage >= messageList.size()) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " received only " + messageList.size() + " messages");
        }
        MockMessage sourceMessage = (MockMessage)messageList.get(indexOfSourceMessage);
        this.verifyMessageEquals(sourceMessage, targetMessage);
    }

    public void verifyNumberOfCurrentTopicMessages(String nameOfTopic, int numberOfMessages) {
        this.checkTopicByName(nameOfTopic);
        List list = this.getCurrentMessageListFromTopic(nameOfTopic);
        if (numberOfMessages != list.size()) {
            throw new VerifyFailedException("Expected " + numberOfMessages + " messages in topic " + nameOfTopic + ", received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfReceivedTopicMessages(String nameOfTopic, int numberOfMessages) {
        this.checkTopicByName(nameOfTopic);
        List list = this.getReceivedMessageListFromTopic(nameOfTopic);
        if (numberOfMessages != list.size()) {
            throw new VerifyFailedException("Expected " + numberOfMessages + " messages received by topic " + nameOfTopic + ", received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfCurrentTopicMessages(int indexOfSession, int indexOfTopic, int numberOfMessages) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List list = this.getCurrentMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " of session with index " + indexOfSession + " does not exist");
        }
        if (numberOfMessages != list.size()) {
            throw new VerifyFailedException("Expected " + numberOfMessages + " messages, received " + list.size() + " messages");
        }
    }

    public void verifyNumberOfReceivedTopicMessages(int indexOfSession, int indexOfTopic, int numberOfMessages) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List list = this.getReceivedMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == list) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " of session with index " + indexOfSession + " does not exist");
        }
        if (numberOfMessages != list.size()) {
            throw new VerifyFailedException("Expected " + numberOfMessages + " messages, received " + list.size() + " messages");
        }
    }

    public void verifyAllReceivedTopicMessagesAcknowledged(String nameOfTopic) {
        this.checkTopicByName(nameOfTopic);
        List messageList = this.getReceivedMessageListFromTopic(nameOfTopic);
        for (int ii = 0; ii < messageList.size(); ++ii) {
            MockMessage currentMessage = (MockMessage)messageList.get(ii);
            if (currentMessage.isAcknowledged()) continue;
            throw new VerifyFailedException("Message " + ii + " of topic " + nameOfTopic + " is not acknowledged");
        }
    }

    public void verifyAllReceivedTopicMessagesAcknowledged(int indexOfSession, int indexOfTopic) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getReceivedMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " of session with index " + indexOfSession + " does not exist");
        }
        for (int ii = 0; ii < messageList.size(); ++ii) {
            MockMessage currentMessage = (MockMessage)messageList.get(ii);
            if (currentMessage.isAcknowledged()) continue;
            throw new VerifyFailedException("Message " + ii + " of temporary topic " + indexOfTopic + " is not acknowledged");
        }
    }

    public void verifyReceivedTopicMessageAcknowledged(String nameOfTopic, int indexOfMessage) {
        this.checkTopicByName(nameOfTopic);
        List messageList = this.getReceivedMessageListFromTopic(nameOfTopic);
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Topic " + nameOfTopic + " received only " + messageList.size() + " messages");
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of topic " + nameOfTopic + " is not acknowledged");
        }
    }

    public void verifyReceivedTopicMessageNotAcknowledged(String nameOfTopic, int indexOfMessage) {
        this.checkTopicByName(nameOfTopic);
        List messageList = this.getReceivedMessageListFromTopic(nameOfTopic);
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Topic " + nameOfTopic + " received only " + messageList.size() + " messages");
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of topic " + nameOfTopic + " is acknowledged");
        }
    }

    public void verifyReceivedTopicMessageAcknowledged(int indexOfSession, int indexOfTopic, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getReceivedMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " of session with index " + indexOfSession + " does not exist");
        }
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " received only " + messageList.size() + " messages");
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of temporary topic " + indexOfTopic + " is not acknowledged");
        }
    }

    public void verifyReceivedTopicMessageNotAcknowledged(int indexOfSession, int indexOfTopic, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getReceivedMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
        if (null == messageList) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " of session with index " + indexOfSession + " does not exist");
        }
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Temporary topic with index " + indexOfTopic + " received only " + messageList.size() + " messages");
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of temporary topic " + indexOfTopic + " is acknowledged");
        }
    }

    public void verifyNumberOfCreatedTopicMessages(int indexOfSession, int number) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (number != this.getTopicMessageManager(indexOfSession).getMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " messages, received " + this.getTopicMessageManager(indexOfSession).getMessageList().size() + " messages");
        }
    }

    public void verifyNumberOfCreatedTopicBytesMessages(int indexOfSession, int number) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (number != this.getTopicMessageManager(indexOfSession).getBytesMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " bytes messages, received " + this.getTopicMessageManager(indexOfSession).getBytesMessageList().size() + " bytes messages");
        }
    }

    public void verifyNumberOfCreatedTopicMapMessages(int indexOfSession, int number) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (number != this.getTopicMessageManager(indexOfSession).getMapMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " map messages, received " + this.getTopicMessageManager(indexOfSession).getMapMessageList().size() + " map messages");
        }
    }

    public void verifyNumberOfCreatedTopicTextMessages(int indexOfSession, int number) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (number != this.getTopicMessageManager(indexOfSession).getTextMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " text messages, received " + this.getTopicMessageManager(indexOfSession).getTextMessageList().size() + " text messages");
        }
    }

    public void verifyNumberOfCreatedTopicStreamMessages(int indexOfSession, int number) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (number != this.getTopicMessageManager(indexOfSession).getStreamMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " stream messages, received " + this.getTopicMessageManager(indexOfSession).getStreamMessageList().size() + " stream messages");
        }
    }

    public void verifyNumberOfCreatedTopicObjectMessages(int indexOfSession, int number) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        if (number != this.getTopicMessageManager(indexOfSession).getObjectMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " object messages, received " + this.getTopicMessageManager(indexOfSession).getObjectMessageList().size() + " object messages");
        }
    }

    public void verifyCreatedTopicMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedTopicBytesMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getBytesMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " bytes messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicBytesMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getBytesMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " bytes messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedTopicMapMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getMapMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " map messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicMapMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getMapMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " map messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedTopicTextMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getTextMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " text messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicTextMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getTextMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " text messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedTopicStreamMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getStreamMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " stream messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicStreamMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getStreamMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " stream messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedTopicObjectMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getObjectMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " object messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedTopicObjectMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetTopicSessionByIndex(indexOfSession);
        List messageList = this.getTopicMessageManager(indexOfSession).getObjectMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " object messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyNumberOfCreatedMessages(int indexOfSession, int number) {
        this.checkAndGetSessionByIndex(indexOfSession);
        if (number != this.getMessageManager(indexOfSession).getMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " messages, received " + this.getMessageManager(indexOfSession).getMessageList().size() + " messages");
        }
    }

    public void verifyNumberOfCreatedBytesMessages(int indexOfSession, int number) {
        this.checkAndGetSessionByIndex(indexOfSession);
        if (number != this.getMessageManager(indexOfSession).getBytesMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " bytes messages, received " + this.getMessageManager(indexOfSession).getBytesMessageList().size() + " bytes messages");
        }
    }

    public void verifyNumberOfCreatedMapMessages(int indexOfSession, int number) {
        this.checkAndGetSessionByIndex(indexOfSession);
        if (number != this.getMessageManager(indexOfSession).getMapMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " map messages, received " + this.getMessageManager(indexOfSession).getMapMessageList().size() + " map messages");
        }
    }

    public void verifyNumberOfCreatedTextMessages(int indexOfSession, int number) {
        this.checkAndGetSessionByIndex(indexOfSession);
        if (number != this.getMessageManager(indexOfSession).getTextMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " text messages, received " + this.getMessageManager(indexOfSession).getTextMessageList().size() + " text messages");
        }
    }

    public void verifyNumberOfCreatedStreamMessages(int indexOfSession, int number) {
        this.checkAndGetSessionByIndex(indexOfSession);
        if (number != this.getMessageManager(indexOfSession).getStreamMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " stream messages, received " + this.getMessageManager(indexOfSession).getStreamMessageList().size() + " stream messages");
        }
    }

    public void verifyNumberOfCreatedObjectMessages(int indexOfSession, int number) {
        this.checkAndGetSessionByIndex(indexOfSession);
        if (number != this.getMessageManager(indexOfSession).getObjectMessageList().size()) {
            throw new VerifyFailedException("Expected " + number + " object messages, received " + this.getMessageManager(indexOfSession).getObjectMessageList().size() + " object messages");
        }
    }

    public void verifyCreatedMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedBytesMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getBytesMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " bytes messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedBytesMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getBytesMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " bytes messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedMapMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getMapMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " map messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedMapMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getMapMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " map messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedTextMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getTextMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " text messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedTextMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getTextMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " text messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedStreamMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getStreamMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " stream messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedStreamMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getStreamMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " stream messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    public void verifyCreatedObjectMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getObjectMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " object messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (!message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is not acknowledged");
        }
    }

    public void verifyCreatedObjectMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.checkAndGetSessionByIndex(indexOfSession);
        List messageList = this.getMessageManager(indexOfSession).getObjectMessageList();
        if (indexOfMessage >= messageList.size()) {
            throw new VerifyFailedException("Only " + messageList.size() + " object messages created for session " + indexOfSession);
        }
        MockMessage message = (MockMessage)messageList.get(indexOfMessage);
        if (message.isAcknowledged()) {
            throw new VerifyFailedException("Message " + indexOfMessage + " of session " + indexOfSession + " is acknowledged");
        }
    }

    private MockQueueSession checkAndGetQueueSessionByIndex(int indexOfSession) {
        if (null == this.getCurrentQueueConnection()) {
            throw new VerifyFailedException("No QueueConnection present.");
        }
        MockQueueSession session = this.getQueueSession(indexOfSession);
        if (null == session) {
            throw new VerifyFailedException("QueueSession with index " + indexOfSession + " does not exist.");
        }
        return session;
    }

    private MockTopicSession checkAndGetTopicSessionByIndex(int indexOfSession) {
        if (null == this.getCurrentTopicConnection()) {
            throw new VerifyFailedException("No TopicConnection present.");
        }
        MockTopicSession session = this.getTopicSession(indexOfSession);
        if (null == session) {
            throw new VerifyFailedException("TopicSession with index " + indexOfSession + " does not exist.");
        }
        return session;
    }

    private MockSession checkAndGetSessionByIndex(int indexOfSession) {
        if (null == this.getCurrentConnection()) {
            throw new VerifyFailedException("No Connection present.");
        }
        MockSession session = this.getSession(indexOfSession);
        if (null == session) {
            throw new VerifyFailedException("Session with index " + indexOfSession + " does not exist.");
        }
        return session;
    }

    private void checkQueueByName(String queueName) {
        DestinationManager destinationManager = this.getDestinationManager();
        if (!destinationManager.existsQueue(queueName)) {
            throw new VerifyFailedException("Queue with name " + queueName + " is not present.");
        }
    }

    private void checkTopicByName(String topicName) {
        DestinationManager destinationManager = this.getDestinationManager();
        if (!destinationManager.existsTopic(topicName)) {
            throw new VerifyFailedException("Topic with name " + topicName + " is not present.");
        }
    }
}

