/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.jms.ConfigurationManager;
import com.mockrunner.jms.DestinationManager;
import com.mockrunner.jms.JMSTestModule;
import com.mockrunner.jms.MessageManager;
import com.mockrunner.jms.QueueTransmissionManager;
import com.mockrunner.jms.TopicTransmissionManager;
import com.mockrunner.jms.TransmissionManagerWrapper;
import com.mockrunner.mock.jms.JMSMockObjectFactory;
import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockMessage;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockQueueConnection;
import com.mockrunner.mock.jms.MockQueueSession;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTemporaryQueue;
import com.mockrunner.mock.jms.MockTemporaryTopic;
import com.mockrunner.mock.jms.MockTopic;
import com.mockrunner.mock.jms.MockTopicConnection;
import com.mockrunner.mock.jms.MockTopicSession;
import java.util.List;
import javax.jms.MessageListener;
import org.junit.After;
import org.junit.Before;

public abstract class BasicJMSTestCaseAdapter {
    private JMSTestModule jmsTestModule;
    private JMSMockObjectFactory jmsMockObjectFactory;

    public BasicJMSTestCaseAdapter() {
    }

    public BasicJMSTestCaseAdapter(String name) {
    }

    @After
    public void tearDown() throws Exception {
        this.jmsTestModule = null;
        this.jmsMockObjectFactory = null;
    }

    @Before
    public void setUp() throws Exception {
        this.jmsTestModule = this.createJMSTestModule(this.getJMSMockObjectFactory());
    }

    protected JMSMockObjectFactory createJMSMockObjectFactory() {
        return new JMSMockObjectFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSMockObjectFactory getJMSMockObjectFactory() {
        Class<JMSMockObjectFactory> clazz = JMSMockObjectFactory.class;
        synchronized (JMSMockObjectFactory.class) {
            if (this.jmsMockObjectFactory == null) {
                this.jmsMockObjectFactory = this.createJMSMockObjectFactory();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.jmsMockObjectFactory;
        }
    }

    protected void setJMSMockObjectFactory(JMSMockObjectFactory jmsMockObjectFactory) {
        this.jmsMockObjectFactory = jmsMockObjectFactory;
    }

    protected JMSTestModule createJMSTestModule() {
        return new JMSTestModule(this.getJMSMockObjectFactory());
    }

    protected JMSTestModule createJMSTestModule(JMSMockObjectFactory mockFactory) {
        return new JMSTestModule(mockFactory);
    }

    protected JMSTestModule getJMSTestModule() {
        return this.jmsTestModule;
    }

    protected void setJMSTestModule(JMSTestModule jmsTestModule) {
        this.jmsTestModule = jmsTestModule;
    }

    protected MockSession getSession(int indexOfSession) {
        return this.jmsTestModule.getSession(indexOfSession);
    }

    protected void verifyConnectionClosed() {
        this.jmsTestModule.verifyConnectionClosed();
    }

    protected void setCurrentQueueConnectionIndex(int connectionIndex) {
        this.jmsTestModule.setCurrentQueueConnectionIndex(connectionIndex);
    }

    protected MockQueueConnection getCurrentQueueConnection() {
        return this.jmsTestModule.getCurrentQueueConnection();
    }

    protected void setCurrentTopicConnectionIndex(int connectionIndex) {
        this.jmsTestModule.setCurrentTopicConnectionIndex(connectionIndex);
    }

    protected MockTopicConnection getCurrentTopicConnection() {
        return this.jmsTestModule.getCurrentTopicConnection();
    }

    protected void setCurrentConnectionIndex(int connectionIndex) {
        this.jmsTestModule.setCurrentConnectionIndex(connectionIndex);
    }

    protected MockConnection getCurrentConnection() {
        return this.jmsTestModule.getCurrentConnection();
    }

    protected void registerTestMessageListenerForQueue(MockConnection connection, String queueName, boolean transacted, int acknowledgeMode, MessageListener listener) {
        this.jmsTestModule.registerTestMessageListenerForQueue(connection, queueName, transacted, acknowledgeMode, listener);
    }

    protected void registerTestMessageListenerForQueue(MockConnection connection, String queueName, boolean transacted, int acknowledgeMode, String messageSelector, MessageListener listener) {
        this.jmsTestModule.registerTestMessageListenerForQueue(connection, queueName, transacted, acknowledgeMode, messageSelector, listener);
    }

    protected void registerTestMessageListenerForQueue(String queueName, MessageListener listener) {
        this.jmsTestModule.registerTestMessageListenerForQueue(queueName, listener);
    }

    protected void registerTestMessageListenerForQueue(MockConnection connection, String queueName, MessageListener listener) {
        this.jmsTestModule.registerTestMessageListenerForQueue(connection, queueName, listener);
    }

    protected DestinationManager getDestinationManager() {
        return this.jmsTestModule.getDestinationManager();
    }

    protected void registerTestMessageListenerForTopic(MockConnection connection, String topicName, boolean transacted, int acknowledgeMode, String messageSelector, MessageListener listener) {
        this.jmsTestModule.registerTestMessageListenerForTopic(connection, topicName, transacted, acknowledgeMode, messageSelector, listener);
    }

    protected void registerTestMessageListenerForTopic(MockConnection connection, String topicName, boolean transacted, int acknowledgeMode, MessageListener listener) {
        this.jmsTestModule.registerTestMessageListenerForTopic(connection, topicName, transacted, acknowledgeMode, listener);
    }

    protected void registerTestMessageListenerForTopic(String topicName, MessageListener listener) {
        this.jmsTestModule.registerTestMessageListenerForTopic(topicName, listener);
    }

    protected void registerTestMessageListenerForTopic(MockConnection connection, String topicName, MessageListener listener) {
        this.jmsTestModule.registerTestMessageListenerForTopic(connection, topicName, listener);
    }

    protected MockTopic getTopic(String name) {
        return this.jmsTestModule.getTopic(name);
    }

    protected ConfigurationManager getConfigurationManager() {
        return this.jmsTestModule.getConfigurationManager();
    }

    protected MessageManager getQueueMessageManager(int indexOfSession) {
        return this.jmsTestModule.getQueueMessageManager(indexOfSession);
    }

    protected MockQueueSession getQueueSession(int indexOfSession) {
        return this.jmsTestModule.getQueueSession(indexOfSession);
    }

    protected MessageManager getMessageManager(int indexOfSession) {
        return this.jmsTestModule.getMessageManager(indexOfSession);
    }

    protected MessageManager getTopicMessageManager(int indexOfSession) {
        return this.jmsTestModule.getTopicMessageManager(indexOfSession);
    }

    protected MockTopicSession getTopicSession(int indexOfSession) {
        return this.jmsTestModule.getTopicSession(indexOfSession);
    }

    protected QueueTransmissionManager getQueueTransmissionManager(int indexOfSession) {
        return this.jmsTestModule.getQueueTransmissionManager(indexOfSession);
    }

    protected TopicTransmissionManager getTopicTransmissionManager(int indexOfSession) {
        return this.jmsTestModule.getTopicTransmissionManager(indexOfSession);
    }

    protected TransmissionManagerWrapper getTransmissionManager(int indexOfSession) {
        return this.jmsTestModule.getTransmissionManager(indexOfSession);
    }

    protected TransmissionManagerWrapper getTransmissionManagerWrapper(int indexOfSession) {
        return this.jmsTestModule.getTransmissionManagerWrapper(indexOfSession);
    }

    protected TransmissionManagerWrapper getQueueTransmissionManagerWrapper(int indexOfSession) {
        return this.jmsTestModule.getQueueTransmissionManagerWrapper(indexOfSession);
    }

    protected TransmissionManagerWrapper getTopicTransmissionManagerWrapper(int indexOfSession) {
        return this.jmsTestModule.getTopicTransmissionManagerWrapper(indexOfSession);
    }

    protected List getQueueSessionList() {
        return this.jmsTestModule.getQueueSessionList();
    }

    protected List getTopicSessionList() {
        return this.jmsTestModule.getTopicSessionList();
    }

    protected List getSessionList() {
        return this.jmsTestModule.getSessionList();
    }

    protected List getTemporaryQueueList(int indexOfSession) {
        return this.jmsTestModule.getTemporaryQueueList(indexOfSession);
    }

    protected List getTemporaryTopicList(int indexOfSession) {
        return this.jmsTestModule.getTemporaryTopicList(indexOfSession);
    }

    protected MockTemporaryQueue getTemporaryQueue(int indexOfSession, int indexOfQueue) {
        return this.jmsTestModule.getTemporaryQueue(indexOfSession, indexOfQueue);
    }

    protected MockTemporaryTopic getTemporaryTopic(int indexOfSession, int indexOfTopic) {
        return this.jmsTestModule.getTemporaryTopic(indexOfSession, indexOfTopic);
    }

    protected List getCurrentMessageListFromQueue(String name) {
        return this.jmsTestModule.getCurrentMessageListFromQueue(name);
    }

    protected List getCurrentMessageListFromTemporaryQueue(int indexOfSession, int indexOfQueue) {
        return this.jmsTestModule.getCurrentMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
    }

    protected List getReceivedMessageListFromQueue(String name) {
        return this.jmsTestModule.getReceivedMessageListFromQueue(name);
    }

    protected List getReceivedMessageListFromTemporaryQueue(int indexOfSession, int indexOfQueue) {
        return this.jmsTestModule.getReceivedMessageListFromTemporaryQueue(indexOfSession, indexOfQueue);
    }

    protected List getCurrentMessageListFromTopic(String name) {
        return this.jmsTestModule.getCurrentMessageListFromTopic(name);
    }

    protected List getCurrentMessageListFromTemporaryTopic(int indexOfSession, int indexOfTopic) {
        return this.jmsTestModule.getCurrentMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
    }

    protected List getReceivedMessageListFromTopic(String name) {
        return this.jmsTestModule.getReceivedMessageListFromTopic(name);
    }

    protected List getReceivedMessageListFromTemporaryTopic(int indexOfSession, int indexOfTopic) {
        return this.jmsTestModule.getReceivedMessageListFromTemporaryTopic(indexOfSession, indexOfTopic);
    }

    protected void verifyQueueConnectionClosed() {
        this.jmsTestModule.verifyQueueConnectionClosed();
    }

    protected void verifyQueueConnectionStarted() {
        this.jmsTestModule.verifyQueueConnectionStarted();
    }

    protected void verifyQueueConnectionStopped() {
        this.jmsTestModule.verifyQueueConnectionStopped();
    }

    protected void verifyTopicConnectionClosed() {
        this.jmsTestModule.verifyTopicConnectionClosed();
    }

    protected void verifyTopicConnectionStarted() {
        this.jmsTestModule.verifyTopicConnectionStarted();
    }

    protected void verifyTopicConnectionStopped() {
        this.jmsTestModule.verifyTopicConnectionStopped();
    }

    protected void verifyConnectionStarted() {
        this.jmsTestModule.verifyConnectionStarted();
    }

    protected void verifyConnectionStopped() {
        this.jmsTestModule.verifyConnectionStopped();
    }

    protected void verifyQueueSessionClosed(int indexOfSession) {
        this.jmsTestModule.verifyQueueSessionClosed(indexOfSession);
    }

    protected void verifyQueueSessionCommitted(int indexOfSession) {
        this.jmsTestModule.verifyQueueSessionCommitted(indexOfSession);
    }

    protected void verifyQueueSessionNotCommitted(int indexOfSession) {
        this.jmsTestModule.verifyQueueSessionNotCommitted(indexOfSession);
    }

    protected void verifyQueueSessionNumberCommits(int indexOfSession, int numberOfCommits) {
        this.jmsTestModule.verifyQueueSessionNumberCommits(indexOfSession, numberOfCommits);
    }

    protected void verifyQueueSessionRolledBack(int indexOfSession) {
        this.jmsTestModule.verifyQueueSessionRolledBack(indexOfSession);
    }

    protected void verifyQueueSessionNotRolledBack(int indexOfSession) {
        this.jmsTestModule.verifyQueueSessionNotRolledBack(indexOfSession);
    }

    protected void verifyQueueSessionNumberRollbacks(int indexOfSession, int numberOfRollbacks) {
        this.jmsTestModule.verifyQueueSessionNumberRollbacks(indexOfSession, numberOfRollbacks);
    }

    protected void verifyQueueSessionRecovered(int indexOfSession) {
        this.jmsTestModule.verifyQueueSessionRecovered(indexOfSession);
    }

    protected void verifyQueueSessionNotRecovered(int indexOfSession) {
        this.jmsTestModule.verifyQueueSessionNotRecovered(indexOfSession);
    }

    protected void verifyTopicSessionClosed(int indexOfSession) {
        this.jmsTestModule.verifyTopicSessionClosed(indexOfSession);
    }

    protected void verifyTopicSessionCommitted(int indexOfSession) {
        this.jmsTestModule.verifyTopicSessionCommitted(indexOfSession);
    }

    protected void verifyTopicSessionNotCommitted(int indexOfSession) {
        this.jmsTestModule.verifyTopicSessionNotCommitted(indexOfSession);
    }

    protected void verifyTopicSessionNumberCommits(int indexOfSession, int numberOfCommits) {
        this.jmsTestModule.verifyTopicSessionNumberCommits(indexOfSession, numberOfCommits);
    }

    protected void verifyTopicSessionRolledBack(int indexOfSession) {
        this.jmsTestModule.verifyTopicSessionRolledBack(indexOfSession);
    }

    protected void verifyTopicSessionNotRolledBack(int indexOfSession) {
        this.jmsTestModule.verifyTopicSessionNotRolledBack(indexOfSession);
    }

    protected void verifyTopicSessionNumberRollbacks(int indexOfSession, int numberOfRollbacks) {
        this.jmsTestModule.verifyTopicSessionNumberRollbacks(indexOfSession, numberOfRollbacks);
    }

    protected void verifyTopicSessionRecovered(int indexOfSession) {
        this.jmsTestModule.verifyTopicSessionRecovered(indexOfSession);
    }

    protected void verifyTopicSessionNotRecovered(int indexOfSession) {
        this.jmsTestModule.verifyTopicSessionNotRecovered(indexOfSession);
    }

    protected void verifySessionClosed(int indexOfSession) {
        this.jmsTestModule.verifySessionClosed(indexOfSession);
    }

    protected void verifySessionCommitted(int indexOfSession) {
        this.jmsTestModule.verifySessionCommitted(indexOfSession);
    }

    protected void verifySessionNotCommitted(int indexOfSession) {
        this.jmsTestModule.verifySessionNotCommitted(indexOfSession);
    }

    protected void verifySessionNumberCommits(int indexOfSession, int numberOfCommits) {
        this.jmsTestModule.verifySessionNumberCommits(indexOfSession, numberOfCommits);
    }

    protected void verifySessionRolledBack(int indexOfSession) {
        this.jmsTestModule.verifySessionRolledBack(indexOfSession);
    }

    protected void verifySessionNotRolledBack(int indexOfSession) {
        this.jmsTestModule.verifySessionNotRolledBack(indexOfSession);
    }

    protected void verifySessionNumberRollbacks(int indexOfSession, int numberOfRollbacks) {
        this.jmsTestModule.verifySessionNumberRollbacks(indexOfSession, numberOfRollbacks);
    }

    protected void verifySessionRecovered(int indexOfSession) {
        this.jmsTestModule.verifySessionRecovered(indexOfSession);
    }

    protected void verifySessionNotRecovered(int indexOfSession) {
        this.jmsTestModule.verifySessionNotRecovered(indexOfSession);
    }

    protected void verifyAllQueueSessionsClosed() {
        this.jmsTestModule.verifyAllQueueSessionsClosed();
    }

    protected void verifyAllQueueSessionsRecovered() {
        this.jmsTestModule.verifyAllQueueSessionsRecovered();
    }

    protected void verifyAllQueueSessionsCommitted() {
        this.jmsTestModule.verifyAllQueueSessionsCommitted();
    }

    protected void verifyAllQueueSessionsRolledBack() {
        this.jmsTestModule.verifyAllQueueSessionsRolledBack();
    }

    protected void verifyAllTopicSessionsClosed() {
        this.jmsTestModule.verifyAllTopicSessionsClosed();
    }

    protected void verifyAllTopicSessionsRecovered() {
        this.jmsTestModule.verifyAllTopicSessionsRecovered();
    }

    protected void verifyAllTopicSessionsCommitted() {
        this.jmsTestModule.verifyAllTopicSessionsCommitted();
    }

    protected void verifyAllTopicSessionsRolledBack() {
        this.jmsTestModule.verifyAllTopicSessionsRolledBack();
    }

    protected void verifyAllSessionsClosed() {
        this.jmsTestModule.verifyAllSessionsClosed();
    }

    protected void verifyAllSessionsRecovered() {
        this.jmsTestModule.verifyAllSessionsRecovered();
    }

    protected void verifyAllSessionsCommitted() {
        this.jmsTestModule.verifyAllSessionsCommitted();
    }

    protected void verifyAllSessionsRolledBack() {
        this.jmsTestModule.verifyAllSessionsRolledBack();
    }

    protected void verifyNumberMessageProducers(int indexOfSession, int numberOfProducers) {
        this.jmsTestModule.verifyNumberMessageProducers(indexOfSession, numberOfProducers);
    }

    protected void verifyAllMessageProducersClosed(int indexOfSession) {
        this.jmsTestModule.verifyAllMessageProducersClosed(indexOfSession);
    }

    protected void verifyNumberQueueSenders(int indexOfSession, String queueName, int numberOfSenders) {
        this.jmsTestModule.verifyNumberQueueSenders(indexOfSession, queueName, numberOfSenders);
    }

    protected void verifyNumberQueueSenders(int indexOfSession, int numberOfSenders) {
        this.jmsTestModule.verifyNumberQueueSenders(indexOfSession, numberOfSenders);
    }

    protected void verifyQueueSenderClosed(int indexOfSession, String queueName, int indexOfSender) {
        this.jmsTestModule.verifyQueueSenderClosed(indexOfSession, queueName, indexOfSender);
    }

    protected void verifyAllQueueSendersClosed(int indexOfSession) {
        this.jmsTestModule.verifyAllQueueSendersClosed(indexOfSession);
    }

    protected void verifyNumberTopicPublishers(int indexOfSession, String topicName, int numberOfPublishers) {
        this.jmsTestModule.verifyNumberTopicPublishers(indexOfSession, topicName, numberOfPublishers);
    }

    protected void verifyNumberTopicPublishers(int indexOfSession, int numberOfPublishers) {
        this.jmsTestModule.verifyNumberTopicPublishers(indexOfSession, numberOfPublishers);
    }

    protected void verifyTopicPublisherClosed(int indexOfSession, String topicName, int indexOfPublisher) {
        this.jmsTestModule.verifyTopicPublisherClosed(indexOfSession, topicName, indexOfPublisher);
    }

    protected void verifyAllTopicPublishersClosed(int indexOfSession) {
        this.jmsTestModule.verifyAllTopicPublishersClosed(indexOfSession);
    }

    protected void verifyNumberMessageConsumers(int indexOfSession, int numberOfConsumers) {
        this.jmsTestModule.verifyNumberMessageConsumers(indexOfSession, numberOfConsumers);
    }

    protected void verifyAllMessageConsumersClosed(int indexOfSession) {
        this.jmsTestModule.verifyAllMessageConsumersClosed(indexOfSession);
    }

    protected void verifyNumberQueueReceivers(int indexOfSession, int numberOfReceivers) {
        this.jmsTestModule.verifyNumberQueueReceivers(indexOfSession, numberOfReceivers);
    }

    protected void verifyNumberQueueReceivers(int indexOfSession, String queueName, int numberOfReceivers) {
        this.jmsTestModule.verifyNumberQueueReceivers(indexOfSession, queueName, numberOfReceivers);
    }

    protected void verifyQueueReceiverClosed(int indexOfSession, String queueName, int indexOfReceiver) {
        this.jmsTestModule.verifyQueueReceiverClosed(indexOfSession, queueName, indexOfReceiver);
    }

    protected void verifyAllQueueReceiversClosed(int indexOfSession) {
        this.jmsTestModule.verifyAllQueueReceiversClosed(indexOfSession);
    }

    protected void verifyNumberTopicSubscribers(int indexOfSession, int numberOfSubscribers) {
        this.jmsTestModule.verifyNumberTopicSubscribers(indexOfSession, numberOfSubscribers);
    }

    protected void verifyNumberTopicSubscribers(int indexOfSession, String topicName, int numberOfSubscribers) {
        this.jmsTestModule.verifyNumberTopicSubscribers(indexOfSession, topicName, numberOfSubscribers);
    }

    protected void verifyTopicSubscriberClosed(int indexOfSession, String topicName, int indexOfSubscriber) {
        this.jmsTestModule.verifyTopicSubscriberClosed(indexOfSession, topicName, indexOfSubscriber);
    }

    protected void verifyAllTopicSubscribersClosed(int indexOfSession) {
        this.jmsTestModule.verifyAllTopicSubscribersClosed(indexOfSession);
    }

    protected void verifyNumberQueueBrowsers(int indexOfSession, String queueName, int numberOfBrowsers) {
        this.jmsTestModule.verifyNumberQueueBrowsers(indexOfSession, queueName, numberOfBrowsers);
    }

    protected void verifyNumberQueueBrowsers(int indexOfSession, int numberOfBrowsers) {
        this.jmsTestModule.verifyNumberQueueBrowsers(indexOfSession, numberOfBrowsers);
    }

    protected void verifyQueueBrowserClosed(int indexOfSession, String queueName, int indexOfBrowser) {
        this.jmsTestModule.verifyQueueBrowserClosed(indexOfSession, queueName, indexOfBrowser);
    }

    protected void verifyAllQueueBrowsersClosed(int indexOfSession) {
        this.jmsTestModule.verifyAllQueueBrowsersClosed(indexOfSession);
    }

    protected void verifyDurableTopicSubscriberPresent(int indexOfSession, String name) {
        this.jmsTestModule.verifyDurableTopicSubscriberPresent(indexOfSession, name);
    }

    protected void verifyNumberDurableTopicSubscribers(int indexOfSession, String topicName, int numberOfSubscribers) {
        this.jmsTestModule.verifyNumberDurableTopicSubscribers(indexOfSession, topicName, numberOfSubscribers);
    }

    protected void verifyNumberDurableTopicSubscribers(int indexOfSession, int numberOfSubscribers) {
        this.jmsTestModule.verifyNumberDurableTopicSubscribers(indexOfSession, numberOfSubscribers);
    }

    protected void verifyDurableTopicSubscriberClosed(int indexOfSession, String name) {
        this.jmsTestModule.verifyDurableTopicSubscriberClosed(indexOfSession, name);
    }

    protected void verifyAllDurableTopicSubscribersClosed(int indexOfSession) {
        this.jmsTestModule.verifyAllDurableTopicSubscribersClosed(indexOfSession);
    }

    protected void verifyNumberQueueSessions(int number) {
        this.jmsTestModule.verifyNumberQueueSessions(number);
    }

    protected void verifyNumberTopicSessions(int number) {
        this.jmsTestModule.verifyNumberTopicSessions(number);
    }

    protected void verifyNumberSessions(int number) {
        this.jmsTestModule.verifyNumberSessions(number);
    }

    protected void verifyNumberTemporaryQueues(int indexOfSession, int numberQueues) {
        this.jmsTestModule.verifyNumberTemporaryQueues(indexOfSession, numberQueues);
    }

    protected void verifyNumberTemporaryTopics(int indexOfSession, int numberTopics) {
        this.jmsTestModule.verifyNumberTemporaryTopics(indexOfSession, numberTopics);
    }

    protected void verifyTemporaryQueueDeleted(int indexOfSession, int indexOfQueue) {
        this.jmsTestModule.verifyTemporaryQueueDeleted(indexOfSession, indexOfQueue);
    }

    protected void verifyAllTemporaryQueuesDeleted(int indexOfSession) {
        this.jmsTestModule.verifyAllTemporaryQueuesDeleted(indexOfSession);
    }

    protected void verifyTemporaryTopicDeleted(int indexOfSession, int indexOfTopic) {
        this.jmsTestModule.verifyTemporaryTopicDeleted(indexOfSession, indexOfTopic);
    }

    protected void verifyAllTemporaryTopicsDeleted(int indexOfSession) {
        this.jmsTestModule.verifyAllTemporaryTopicsDeleted(indexOfSession);
    }

    protected void verifyMessageEquals(MockMessage message1, MockMessage message2) {
        this.jmsTestModule.verifyMessageEquals(message1, message2);
    }

    protected void verifyCurrentQueueMessageEquals(String nameOfQueue, int indexOfSourceMessage, MockMessage targetMessage) {
        this.jmsTestModule.verifyCurrentQueueMessageEquals(nameOfQueue, indexOfSourceMessage, targetMessage);
    }

    protected void verifyCurrentQueueMessageEquals(int indexOfSession, int indexOfQueue, int indexOfSourceMessage, MockMessage targetMessage) {
        this.jmsTestModule.verifyCurrentQueueMessageEquals(indexOfSession, indexOfQueue, indexOfSourceMessage, targetMessage);
    }

    protected void verifyReceivedQueueMessageEquals(String nameOfQueue, int indexOfSourceMessage, MockMessage targetMessage) {
        this.jmsTestModule.verifyReceivedQueueMessageEquals(nameOfQueue, indexOfSourceMessage, targetMessage);
    }

    protected void verifyReceivedQueueMessageEquals(int indexOfSession, int indexOfQueue, int indexOfSourceMessage, MockMessage targetMessage) {
        this.jmsTestModule.verifyReceivedQueueMessageEquals(indexOfSession, indexOfQueue, indexOfSourceMessage, targetMessage);
    }

    protected void verifyNumberOfCurrentQueueMessages(int indexOfSession, int indexOfQueue, int numberOfMessages) {
        this.jmsTestModule.verifyNumberOfCurrentQueueMessages(indexOfSession, indexOfQueue, numberOfMessages);
    }

    protected void verifyNumberOfCurrentQueueMessages(String nameOfQueue, int numberOfMessages) {
        this.jmsTestModule.verifyNumberOfCurrentQueueMessages(nameOfQueue, numberOfMessages);
    }

    protected void verifyNumberOfReceivedQueueMessages(String nameOfQueue, int numberOfMessages) {
        this.jmsTestModule.verifyNumberOfReceivedQueueMessages(nameOfQueue, numberOfMessages);
    }

    protected void verifyNumberOfReceivedQueueMessages(int indexOfSession, int indexOfQueue, int numberOfMessages) {
        this.jmsTestModule.verifyNumberOfReceivedQueueMessages(indexOfSession, indexOfQueue, numberOfMessages);
    }

    protected void verifyAllReceivedQueueMessagesAcknowledged(String nameOfQueue) {
        this.jmsTestModule.verifyAllReceivedQueueMessagesAcknowledged(nameOfQueue);
    }

    protected void verifyAllReceivedQueueMessagesAcknowledged(int indexOfSession, int indexOfQueue) {
        this.jmsTestModule.verifyAllReceivedQueueMessagesAcknowledged(indexOfSession, indexOfQueue);
    }

    protected void verifyReceivedQueueMessageAcknowledged(String nameOfQueue, int indexOfMessage) {
        this.jmsTestModule.verifyReceivedQueueMessageAcknowledged(nameOfQueue, indexOfMessage);
    }

    protected void verifyReceivedQueueMessageAcknowledged(int indexOfSession, int indexOfQueue, int indexOfMessage) {
        this.jmsTestModule.verifyReceivedQueueMessageAcknowledged(indexOfSession, indexOfQueue, indexOfMessage);
    }

    protected void verifyReceivedQueueMessageNotAcknowledged(int indexOfSession, int indexOfQueue, int indexOfMessage) {
        this.jmsTestModule.verifyReceivedQueueMessageNotAcknowledged(indexOfSession, indexOfQueue, indexOfMessage);
    }

    protected void verifyReceivedQueueMessageNotAcknowledged(String nameOfQueue, int indexOfMessage) {
        this.jmsTestModule.verifyReceivedQueueMessageNotAcknowledged(nameOfQueue, indexOfMessage);
    }

    protected void verifyNumberOfCreatedQueueMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedQueueMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedQueueBytesMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedQueueBytesMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedQueueMapMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedQueueMapMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedQueueTextMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedQueueTextMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedQueueStreamMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedQueueStreamMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedQueueObjectMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedQueueObjectMessages(indexOfSession, number);
    }

    protected void verifyCreatedQueueMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueBytesMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueBytesMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueBytesMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueBytesMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueMapMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueMapMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueMapMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueMapMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueTextMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueTextMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueTextMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueTextMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueStreamMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueStreamMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueStreamMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueStreamMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueObjectMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueObjectMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedQueueObjectMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedQueueObjectMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCurrentTopicMessageEquals(int indexOfSession, int indexOfTopic, int indexOfSourceMessage, MockMessage targetMessage) {
        this.jmsTestModule.verifyCurrentTopicMessageEquals(indexOfSession, indexOfTopic, indexOfSourceMessage, targetMessage);
    }

    protected void verifyCurrentTopicMessageEquals(String nameOfTopic, int indexOfSourceMessage, MockMessage targetMessage) {
        this.jmsTestModule.verifyCurrentTopicMessageEquals(nameOfTopic, indexOfSourceMessage, targetMessage);
    }

    protected void verifyReceivedTopicMessageEquals(String nameOfTopic, int indexOfSourceMessage, MockMessage targetMessage) {
        this.jmsTestModule.verifyReceivedTopicMessageEquals(nameOfTopic, indexOfSourceMessage, targetMessage);
    }

    protected void verifyReceivedTopicMessageEquals(int indexOfSession, int indexOfTopic, int indexOfSourceMessage, MockMessage targetMessage) {
        this.jmsTestModule.verifyReceivedTopicMessageEquals(indexOfSession, indexOfTopic, indexOfSourceMessage, targetMessage);
    }

    protected void verifyNumberOfCurrentTopicMessages(int indexOfSession, int indexOfTopic, int numberOfMessages) {
        this.jmsTestModule.verifyNumberOfCurrentTopicMessages(indexOfSession, indexOfTopic, numberOfMessages);
    }

    protected void verifyNumberOfCurrentTopicMessages(String nameOfTopic, int numberOfMessages) {
        this.jmsTestModule.verifyNumberOfCurrentTopicMessages(nameOfTopic, numberOfMessages);
    }

    protected void verifyNumberOfReceivedTopicMessages(int indexOfSession, int indexOfTopic, int numberOfMessages) {
        this.jmsTestModule.verifyNumberOfReceivedTopicMessages(indexOfSession, indexOfTopic, numberOfMessages);
    }

    protected void verifyNumberOfReceivedTopicMessages(String nameOfTopic, int numberOfMessages) {
        this.jmsTestModule.verifyNumberOfReceivedTopicMessages(nameOfTopic, numberOfMessages);
    }

    protected void verifyAllReceivedTopicMessagesAcknowledged(String nameOfTopic) {
        this.jmsTestModule.verifyAllReceivedTopicMessagesAcknowledged(nameOfTopic);
    }

    protected void verifyAllReceivedTopicMessagesAcknowledged(int indexOfSession, int indexOfTopic) {
        this.jmsTestModule.verifyAllReceivedTopicMessagesAcknowledged(indexOfSession, indexOfTopic);
    }

    protected void verifyReceivedTopicMessageAcknowledged(String nameOfTopic, int indexOfMessage) {
        this.jmsTestModule.verifyReceivedTopicMessageAcknowledged(nameOfTopic, indexOfMessage);
    }

    protected void verifyReceivedTopicMessageAcknowledged(int indexOfSession, int indexOfTopic, int indexOfMessage) {
        this.jmsTestModule.verifyReceivedTopicMessageAcknowledged(indexOfSession, indexOfTopic, indexOfMessage);
    }

    protected void verifyReceivedTopicMessageNotAcknowledged(int indexOfSession, int indexOfTopic, int indexOfMessage) {
        this.jmsTestModule.verifyReceivedTopicMessageNotAcknowledged(indexOfSession, indexOfTopic, indexOfMessage);
    }

    protected void verifyReceivedTopicMessageNotAcknowledged(String nameOfTopic, int indexOfMessage) {
        this.jmsTestModule.verifyReceivedTopicMessageNotAcknowledged(nameOfTopic, indexOfMessage);
    }

    protected void verifyNumberOfCreatedTopicMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedTopicMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedTopicBytesMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedTopicBytesMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedTopicMapMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedTopicMapMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedTopicTextMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedTopicTextMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedTopicStreamMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedTopicStreamMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedTopicObjectMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedTopicObjectMessages(indexOfSession, number);
    }

    protected void verifyCreatedTopicMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicBytesMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicBytesMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicBytesMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicBytesMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicMapMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicMapMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicMapMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicMapMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicTextMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicTextMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicTextMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicTextMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicStreamMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicStreamMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicStreamMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicStreamMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicObjectMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicObjectMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTopicObjectMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTopicObjectMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyNumberOfCreatedMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedBytesMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedBytesMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedMapMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedMapMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedTextMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedTextMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedStreamMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedStreamMessages(indexOfSession, number);
    }

    protected void verifyNumberOfCreatedObjectMessages(int indexOfSession, int number) {
        this.jmsTestModule.verifyNumberOfCreatedObjectMessages(indexOfSession, number);
    }

    protected void verifyCreatedMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedBytesMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedBytesMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedBytesMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedBytesMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedMapMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedMapMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedMapMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedMapMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTextMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTextMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedTextMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedTextMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedStreamMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedStreamMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedStreamMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedStreamMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedObjectMessageAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedObjectMessageAcknowledged(indexOfSession, indexOfMessage);
    }

    protected void verifyCreatedObjectMessageNotAcknowledged(int indexOfSession, int indexOfMessage) {
        this.jmsTestModule.verifyCreatedObjectMessageNotAcknowledged(indexOfSession, indexOfMessage);
    }

    protected MockQueue getQueue(String name) {
        return this.jmsTestModule.getQueue(name);
    }
}

