/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockDestination;
import com.mockrunner.mock.jms.MockMessage;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopic;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.StreamMessage;

public class MockMessageProducer
implements MessageProducer,
Serializable {
    private MockConnection connection;
    private MockDestination destination;
    private MockSession session;
    private boolean closed;
    private boolean disableMessageId;
    private boolean disableTimestamp;
    private int deliveryMode;
    private int priority;
    private long timeToLive;

    public MockMessageProducer(MockConnection connection, MockSession session, MockDestination destination) {
        this.connection = connection;
        this.destination = destination;
        this.session = session;
        this.closed = false;
        this.disableMessageId = false;
        this.disableTimestamp = false;
        this.deliveryMode = 2;
        this.priority = 4;
        this.timeToLive = 0L;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void send(Message message) throws JMSException {
        this.send(this.destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.connection.throwJMSException();
        if (this.isClosed()) {
            throw new JMSException("Producer is closed");
        }
        if (null == destination) {
            throw new InvalidDestinationException("destination must not be null");
        }
        if (message instanceof MockMessage && this.connection.getConfigurationManager().getDoCloneOnSend()) {
            message = (MockMessage)((MockMessage)message).clone();
        }
        if (destination instanceof MockQueue) {
            this.setJMSMessageHeaders(message, destination, deliveryMode, priority, timeToLive);
            this.session.addSessionToQueue((MockQueue)destination);
            ((MockQueue)destination).addMessage(message);
        } else if (destination instanceof MockTopic) {
            this.setJMSMessageHeaders(message, destination, deliveryMode, priority, timeToLive);
            this.session.addSessionToTopic((MockTopic)destination);
            ((MockTopic)destination).addMessage(message);
        } else {
            throw new InvalidDestinationException("destination must be an instance of MockQueue or MockTopic");
        }
    }

    public Destination getDestination() throws JMSException {
        this.connection.throwJMSException();
        return this.destination;
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        this.closed = true;
    }

    public void setDisableMessageID(boolean disableMessageId) throws JMSException {
        this.connection.throwJMSException();
        this.disableMessageId = disableMessageId;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.connection.throwJMSException();
        return this.disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean disableTimestamp) throws JMSException {
        this.connection.throwJMSException();
        this.disableTimestamp = disableTimestamp;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.connection.throwJMSException();
        return this.disableTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.connection.throwJMSException();
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        this.connection.throwJMSException();
        return this.deliveryMode;
    }

    public void setPriority(int priority) throws JMSException {
        this.connection.throwJMSException();
        this.priority = priority;
    }

    public int getPriority() throws JMSException {
        this.connection.throwJMSException();
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.connection.throwJMSException();
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        this.connection.throwJMSException();
        return this.timeToLive;
    }

    private void setJMSMessageHeaders(Message message, Destination destination, int deliveryMode, int priority, long timeToLive) throws JMSException {
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSDestination(destination);
        long currentTime = System.currentTimeMillis();
        if (!this.disableTimestamp) {
            message.setJMSTimestamp(currentTime);
        }
        if (0L == timeToLive) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(currentTime + timeToLive);
        }
        if (!this.disableMessageId) {
            message.setJMSMessageID("ID:" + String.valueOf(Math.random()));
        }
        if (message instanceof MockMessage) {
            ((MockMessage)message).setReadOnly(true);
            ((MockMessage)message).setReadOnlyProperties(true);
        }
        if (message instanceof BytesMessage) {
            ((BytesMessage)message).reset();
        }
        if (message instanceof StreamMessage) {
            ((StreamMessage)message).reset();
        }
    }
}

