/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;

public class MockServletOutputStream
extends ServletOutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private String encoding;

    public MockServletOutputStream() {
        this("ISO-8859-1");
    }

    public MockServletOutputStream(String encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void write(int value) throws IOException {
        this.buffer.write(value);
    }

    public String getContent() {
        try {
            this.buffer.flush();
            return this.buffer.toString(this.encoding);
        }
        catch (IOException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public byte[] getBinaryContent() {
        try {
            this.buffer.flush();
            return this.buffer.toByteArray();
        }
        catch (IOException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void clearContent() {
        this.buffer = new ByteArrayOutputStream();
    }
}

