/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

public class MockJspWriter
extends JspWriter {
    private PrintWriter printWriter;
    private Writer writer;
    private HttpServletResponse response;
    private boolean providedWriter;

    public MockJspWriter() {
        super(0, true);
        this.writer = new StringWriter();
        this.printWriter = new PrintWriter(this.writer);
        this.response = null;
        this.providedWriter = false;
    }

    public MockJspWriter(HttpServletResponse response) throws IOException {
        super(0, true);
        this.writer = response.getWriter();
        this.response = response;
        this.printWriter = new PrintWriter(this.writer);
        this.providedWriter = false;
    }

    public MockJspWriter(Writer writer) {
        super(0, true);
        this.writer = writer;
        this.printWriter = new PrintWriter(writer);
        this.response = null;
        this.providedWriter = true;
    }

    public String getOutputAsString() {
        try {
            this.flush();
            if (!this.providedWriter) {
                if (null == this.response) {
                    return ((StringWriter)this.writer).toString();
                }
                if (this.response instanceof MockHttpServletResponse) {
                    return ((MockHttpServletResponse)this.response).getOutputStreamContent();
                }
            }
            return "";
        }
        catch (IOException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public String toString() {
        return this.getOutputAsString();
    }

    public void clear() throws IOException {
        if (this.providedWriter) {
            throw new IOException("Illegal call if writer is provided.");
        }
        this.clearWriter();
    }

    public void clearBuffer() throws IOException {
        if (!this.providedWriter) {
            this.clearWriter();
        }
    }

    private void clearWriter() throws IOException {
        if (null == this.response) {
            this.writer = new StringWriter();
            this.printWriter = new PrintWriter(this.writer);
        } else {
            this.flush();
            this.response.resetBuffer();
        }
    }

    public void close() throws IOException {
        this.flush();
        this.printWriter.close();
    }

    public int getRemaining() {
        return 0;
    }

    public void flush() throws IOException {
        this.printWriter.flush();
    }

    public void newLine() throws IOException {
        this.print(System.getProperty("line.separator"));
    }

    public void print(boolean value) throws IOException {
        this.printWriter.print(value);
    }

    public void print(char value) throws IOException {
        this.printWriter.print(value);
    }

    public void print(char[] value) throws IOException {
        this.printWriter.print(value);
    }

    public void print(double value) throws IOException {
        this.printWriter.print(value);
    }

    public void print(float value) throws IOException {
        this.printWriter.print(value);
    }

    public void print(int value) throws IOException {
        this.printWriter.print(value);
    }

    public void print(long value) throws IOException {
        this.printWriter.print(value);
    }

    public void print(Object value) throws IOException {
        this.printWriter.print(value);
    }

    public void print(String value) throws IOException {
        this.printWriter.print(value);
    }

    public void println() throws IOException {
        this.printWriter.println();
    }

    public void println(boolean value) throws IOException {
        this.printWriter.println(value);
    }

    public void println(char value) throws IOException {
        this.printWriter.println(value);
    }

    public void println(char[] value) throws IOException {
        this.printWriter.println(value);
    }

    public void println(double value) throws IOException {
        this.printWriter.println(value);
    }

    public void println(float value) throws IOException {
        this.printWriter.println(value);
    }

    public void println(int value) throws IOException {
        this.printWriter.println(value);
    }

    public void println(long value) throws IOException {
        this.printWriter.println(value);
    }

    public void println(Object value) throws IOException {
        this.printWriter.println(value);
    }

    public void println(String value) throws IOException {
        this.printWriter.println(value);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.printWriter.write(cbuf, off, len);
    }
}

