/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.servlet;

import com.mockrunner.example.servlet.RedirectServlet;
import com.mockrunner.servlet.BasicServletTestCaseAdapter;
import java.io.BufferedReader;
import org.jdom2.Element;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RedirectServletTest
extends BasicServletTestCaseAdapter {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createServlet(RedirectServlet.class);
    }

    @Test
    public void testServletOutput() throws Exception {
        this.addRequestParameter("redirecturl", "http://www.mockrunner.com");
        this.doPost();
        BufferedReader reader = this.getOutputAsBufferedReader();
        Assert.assertEquals((Object)"<html>", (Object)reader.readLine().trim());
        Assert.assertEquals((Object)"<head>", (Object)reader.readLine().trim());
        reader.readLine();
        Assert.assertEquals((Object)"</head>", (Object)reader.readLine().trim());
        Assert.assertEquals((Object)"<body>", (Object)reader.readLine().trim());
        reader.readLine();
        Assert.assertEquals((Object)"</body>", (Object)reader.readLine().trim());
        Assert.assertEquals((Object)"</html>", (Object)reader.readLine().trim());
        this.verifyOutputContains("URL=http://www.mockrunner.com");
    }

    @Test
    public void testServletOutputAsXML() throws Exception {
        this.addRequestParameter("redirecturl", "http://www.mockrunner.com");
        this.doPost();
        Element root = this.getOutputAsJDOMDocument().getRootElement();
        Assert.assertEquals((Object)"html", (Object)root.getName());
        Element head = root.getChild("head");
        Element meta = head.getChild("meta");
        Assert.assertEquals((Object)"refresh", (Object)meta.getAttributeValue("http-equiv"));
        Assert.assertEquals((Object)"0;URL=http://www.mockrunner.com", (Object)meta.getAttributeValue("content"));
    }
}

