/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.example.struts;

import com.mockrunner.example.struts.AuthenticationAction;
import com.mockrunner.example.struts.AuthenticationForm;
import com.mockrunner.example.struts.AuthenticationStrategy;
import com.mockrunner.example.struts.MockAuthenticationStrategy;
import com.mockrunner.struts.BasicActionTestCaseAdapter;
import org.apache.struts.action.ActionForm;
import org.junit.Before;
import org.junit.Test;

public class AuthenticationActionTest
extends BasicActionTestCaseAdapter {
    private MockAuthenticationStrategy strategy;
    private AuthenticationForm form;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.strategy = new MockAuthenticationStrategy();
        this.getActionMockObjectFactory().getMockServletContext().setAttribute(AuthenticationStrategy.class.getName(), (Object)this.strategy);
        this.form = (AuthenticationForm)this.createActionForm(AuthenticationForm.class);
        this.setValidate(true);
    }

    @Test
    public void testSuccessfulLogin() {
        this.addRequestParameter("username", "test");
        this.addRequestParameter("password", "test");
        this.strategy.setupLoginOk(true);
        this.actionPerform(AuthenticationAction.class, (ActionForm)this.form);
        this.verifyNoActionErrors();
        this.verifyNumberActionMessages(1);
        this.verifyActionMessagePresent("auth.login.successful");
        this.verifyForward("success");
    }

    @Test
    public void testEmptyInput() {
        this.form.setUsername("");
        this.form.setPassword("test");
        this.strategy.setupLoginOk(true);
        this.actionPerform(AuthenticationAction.class, (ActionForm)this.form);
        this.verifyNumberActionErrors(1);
        this.verifyActionErrorPresent("field.value.missing");
        this.verifyActionErrorValue("field.value.missing", "username");
        this.form.setUsername("test");
        this.form.setPassword("");
        this.actionPerform(AuthenticationAction.class, (ActionForm)this.form);
        this.verifyNumberActionErrors(1);
        this.verifyActionErrorPresent("field.value.missing");
        this.verifyActionErrorValue("field.value.missing", "password");
        this.strategy.setupLoginOk(false);
        this.strategy.setupUserKnown(false);
        this.actionPerform(AuthenticationAction.class, (ActionForm)this.form);
        this.verifyActionErrorNotPresent("auth.username.unknown");
    }

    @Test
    public void testUnknownUser() {
        this.form.setUsername("test");
        this.form.setPassword("test");
        this.strategy.setupLoginOk(false);
        this.strategy.setupUserKnown(false);
        this.actionPerform(AuthenticationAction.class, (ActionForm)this.form);
        this.verifyNumberActionErrors(1);
        this.verifyActionErrorPresent("auth.username.unknown");
        this.verifyActionErrorValue("auth.username.unknown", "test");
        this.verifyForward("failure");
    }

    @Test
    public void testWrongPassword() {
        this.form.setUsername("test");
        this.form.setPassword("test");
        this.strategy.setupLoginOk(false);
        this.strategy.setupUserKnown(true);
        this.strategy.setupPasswordOk(false);
        this.actionPerform(AuthenticationAction.class, (ActionForm)this.form);
        this.verifyNumberActionErrors(1);
        this.verifyActionErrorPresent("auth.password.wrong");
        this.verifyForward("failure");
    }

    @Test
    public void testGeneralError() {
        this.form.setUsername("test");
        this.form.setPassword("test");
        this.strategy.setupLoginOk(false);
        this.strategy.setupUserKnown(true);
        this.strategy.setupPasswordOk(true);
        this.actionPerform(AuthenticationAction.class, (ActionForm)this.form);
        this.verifyNumberActionErrors(1);
        this.verifyActionErrorPresent("auth.general.error");
        this.verifyForward("failure");
    }
}

