/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.struts;

import com.mockrunner.base.HTMLOutputModule;
import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.mock.web.ActionMockObjectFactory;
import com.mockrunner.mock.web.MockActionForward;
import com.mockrunner.mock.web.MockActionMapping;
import com.mockrunner.mock.web.MockPageContext;
import com.mockrunner.mock.web.WebMockObjectFactory;
import com.mockrunner.struts.ExceptionHandlerConfig;
import com.mockrunner.util.common.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.ValidatorPlugIn;

public class ActionTestModule
extends HTMLOutputModule {
    private ActionMockObjectFactory mockFactory;
    private MockActionForward forward;
    private ActionForm formObj;
    private Action actionObj;
    private boolean reset;
    private boolean doPopulate;
    private boolean recognizeInSession;
    private String messageAttributeKey;
    private String errorAttributeKey;
    private List exceptionHandlers;

    public ActionTestModule(ActionMockObjectFactory mockFactory) {
        super((WebMockObjectFactory)mockFactory);
        this.mockFactory = mockFactory;
        this.reset = true;
        this.doPopulate = true;
        this.recognizeInSession = true;
        this.messageAttributeKey = "org.apache.struts.action.ACTION_MESSAGE";
        this.errorAttributeKey = "org.apache.struts.action.ERROR";
        this.exceptionHandlers = new ArrayList();
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void setDoPopulate(boolean doPopulate) {
        this.doPopulate = doPopulate;
    }

    public void setRecognizeMessagesInSession(boolean recognizeInSession) {
        this.recognizeInSession = recognizeInSession;
    }

    public void setMessageAttributeKey(String messageAttributeKey) {
        this.messageAttributeKey = messageAttributeKey;
    }

    public void setErrorAttributeKey(String errorAttributeKey) {
        this.errorAttributeKey = errorAttributeKey;
    }

    public String addMappedPropertyRequestPrefix(String property) {
        return "value(" + property + ")";
    }

    public void setParameter(String parameter) {
        this.getActionMapping().setParameter(parameter);
    }

    public void setValidate(boolean validate) {
        this.getActionMapping().setValidate(validate);
    }

    public void setInput(String input) {
        this.getActionMapping().setInput(input);
    }

    public void addExceptionHandler(ExceptionHandlerConfig handler) {
        if (null != handler) {
            this.exceptionHandlers.add(handler);
        }
    }

    public void setResources(MessageResources resources) {
        this.mockFactory.getWrappedRequest().setAttribute("org.apache.struts.action.MESSAGE", (Object)resources);
    }

    public void setResources(String key, MessageResources resources) {
        MessageResourcesConfig config = new MessageResourcesConfig();
        config.setKey(key);
        this.mockFactory.getMockModuleConfig().addMessageResourcesConfig(config);
        key = key + this.mockFactory.getMockModuleConfig().getPrefix();
        this.mockFactory.getMockServletContext().setAttribute(key, (Object)resources);
    }

    public void setDataSource(DataSource dataSource) {
        this.setDataSource("org.apache.struts.action.DATA_SOURCE", dataSource);
    }

    public void setDataSource(String key, DataSource dataSource) {
        key = key + this.mockFactory.getMockModuleConfig().getPrefix();
        this.mockFactory.getMockServletContext().setAttribute(key, (Object)dataSource);
    }

    public void setLocale(Locale locale) {
        this.mockFactory.getMockSession().setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
    }

    public ValidatorResources createValidatorResources(String[] resourcesFiles) {
        if (resourcesFiles.length == 0) {
            return null;
        }
        this.setUpServletContextResourcePath(resourcesFiles);
        String resourceString = resourcesFiles[0];
        for (int ii = 1; ii < resourcesFiles.length; ++ii) {
            resourceString = resourceString + "," + resourcesFiles[ii];
        }
        ValidatorPlugIn plugIn = new ValidatorPlugIn();
        plugIn.setPathnames(resourceString);
        try {
            plugIn.init((ActionServlet)this.mockFactory.getMockActionServlet(), (ModuleConfig)this.mockFactory.getMockModuleConfig());
        }
        catch (ServletException exc) {
            throw new RuntimeException("Error initializing ValidatorPlugIn: " + exc.getMessage());
        }
        String key = "org.apache.commons.validator.VALIDATOR_RESOURCES" + this.mockFactory.getMockModuleConfig().getPrefix();
        return (ValidatorResources)this.mockFactory.getMockServletContext().getAttribute(key);
    }

    private void setUpServletContextResourcePath(String[] resourcesFiles) {
        for (int ii = 0; ii < resourcesFiles.length; ++ii) {
            String file = resourcesFiles[ii];
            try {
                File streamFile = new File(file);
                FileInputStream stream = new FileInputStream(streamFile);
                byte[] fileData = StreamUtil.getStreamAsByteArray((InputStream)stream);
                this.mockFactory.getMockServletContext().setResourceAsStream(file, fileData);
                this.mockFactory.getMockServletContext().setResource(file, streamFile.toURL());
                continue;
            }
            catch (Exception exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
    }

    public void setValidatorResources(ValidatorResources validatorResources) {
        String key = "org.apache.commons.validator.VALIDATOR_RESOURCES" + this.mockFactory.getMockModuleConfig().getPrefix();
        this.mockFactory.getMockServletContext().setAttribute(key, (Object)validatorResources);
    }

    public void verifyForward(String path) {
        if (null == this.getActionForward()) {
            throw new VerifyFailedException("ActionForward == null");
        }
        if (!this.getActionForward().verifyPath(path)) {
            throw new VerifyFailedException("expected " + path + ", received " + this.getActionForward().getPath());
        }
    }

    public void verifyForwardName(String name) {
        if (null == this.getActionForward()) {
            throw new VerifyFailedException("ActionForward == null");
        }
        if (!this.getActionForward().verifyName(name)) {
            throw new VerifyFailedException("expected " + name + ", received " + this.getActionForward().getName());
        }
    }

    public void verifyRedirect(boolean redirect) {
        if (null == this.getActionForward()) {
            throw new VerifyFailedException("ActionForward == null");
        }
        if (!this.getActionForward().verifyRedirect(redirect)) {
            throw new VerifyFailedException("expected " + redirect + ", received " + this.getActionForward().getRedirect());
        }
    }

    public void verifyNoActionErrors() {
        this.verifyNoActionMessages(this.getActionErrors());
    }

    public void verifyNoActionMessages() {
        this.verifyNoActionMessages(this.getActionMessages());
    }

    private void verifyNoActionMessages(ActionMessages messages) {
        if (this.containsMessages(messages)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("has the following messages/errors: ");
            Iterator iterator = messages.get();
            while (iterator.hasNext()) {
                ActionMessage message = (ActionMessage)iterator.next();
                buffer.append(message.getKey() + ";");
            }
            throw new VerifyFailedException(buffer.toString());
        }
    }

    public void verifyHasActionErrors() {
        if (!this.containsMessages(this.getActionErrors())) {
            throw new VerifyFailedException("no action errors");
        }
    }

    public void verifyHasActionMessages() {
        if (!this.containsMessages(this.getActionMessages())) {
            throw new VerifyFailedException("no action messages");
        }
    }

    public void verifyActionErrorPresent(String errorKey) {
        this.verifyActionMessagePresent(errorKey, this.getActionErrors());
    }

    public void verifyActionMessagePresent(String messageKey) {
        this.verifyActionMessagePresent(messageKey, this.getActionMessages());
    }

    private void verifyActionMessagePresent(String messageKey, ActionMessages messages) {
        if (!this.containsMessages(messages)) {
            throw new VerifyFailedException("no action messages/errors");
        }
        Iterator iterator = messages.get();
        while (iterator.hasNext()) {
            ActionMessage message = (ActionMessage)iterator.next();
            if (!message.getKey().equals(messageKey)) continue;
            return;
        }
        throw new VerifyFailedException("message/error " + messageKey + " not present");
    }

    public void verifyActionErrorNotPresent(String errorKey) {
        this.verifyActionMessageNotPresent(errorKey, this.getActionErrors());
    }

    public void verifyActionMessageNotPresent(String messageKey) {
        this.verifyActionMessageNotPresent(messageKey, this.getActionMessages());
    }

    private void verifyActionMessageNotPresent(String messageKey, ActionMessages messages) {
        if (!this.containsMessages(messages)) {
            return;
        }
        Iterator iterator = messages.get();
        while (iterator.hasNext()) {
            ActionMessage message = (ActionMessage)iterator.next();
            if (!message.getKey().equals(messageKey)) continue;
            throw new VerifyFailedException("message/error " + messageKey + " present");
        }
    }

    public void verifyActionErrors(String[] errorKeys) {
        this.verifyActionMessages(errorKeys, this.getActionErrors());
    }

    public void verifyActionMessages(String[] messageKeys) {
        this.verifyActionMessages(messageKeys, this.getActionMessages());
    }

    private void verifyActionMessages(String[] messageKeys, ActionMessages messages) {
        if (!this.containsMessages(messages)) {
            throw new VerifyFailedException("no action messages/errors");
        }
        if (messages.size() != messageKeys.length) {
            throw new VerifyFailedException("expected " + messageKeys.length + " messages/errors, received " + messages.size() + " messages/errors");
        }
        Iterator iterator = messages.get();
        for (int ii = 0; ii < messageKeys.length; ++ii) {
            ActionMessage message = (ActionMessage)iterator.next();
            if (message.getKey().equals(messageKeys[ii])) continue;
            throw new VerifyFailedException("mismatch at position " + ii + ", actual: " + message.getKey() + ", expected: " + messageKeys[ii]);
        }
    }

    public void verifyActionErrorValues(String errorKey, Object[] values) {
        ActionMessage error = this.getActionErrorByKey(errorKey);
        if (null == error) {
            throw new VerifyFailedException("action error " + errorKey + " not present");
        }
        this.verifyActionMessageValues(error, values);
    }

    public void verifyActionMessageValues(String messageKey, Object[] values) {
        ActionMessage message = this.getActionMessageByKey(messageKey);
        if (null == message) {
            throw new VerifyFailedException("action message " + messageKey + " not present");
        }
        this.verifyActionMessageValues(message, values);
    }

    private void verifyActionMessageValues(ActionMessage message, Object[] values) {
        Object[] actualValues = message.getValues();
        if (null == actualValues) {
            throw new VerifyFailedException("action message/error " + message.getKey() + " has no values");
        }
        if (values.length != actualValues.length) {
            throw new VerifyFailedException("action message/error " + message.getKey() + " has " + actualValues.length + " values");
        }
        for (int ii = 0; ii < actualValues.length; ++ii) {
            if (values[ii].equals(actualValues[ii])) continue;
            throw new VerifyFailedException("action message/error " + message.getKey() + ": expected value[" + ii + "]: " + values[ii] + " received value[" + ii + "]: " + actualValues[ii]);
        }
    }

    public void verifyActionErrorValue(String errorKey, Object value) {
        this.verifyActionErrorValues(errorKey, new Object[]{value});
    }

    public void verifyActionMessageValue(String messageKey, Object value) {
        this.verifyActionMessageValues(messageKey, new Object[]{value});
    }

    public void verifyActionErrorProperty(String errorKey, String property) {
        this.verifyActionMessageProperty(errorKey, property, this.getActionErrors());
    }

    public void verifyActionMessageProperty(String messageKey, String property) {
        this.verifyActionMessageProperty(messageKey, property, this.getActionMessages());
    }

    private void verifyActionMessageProperty(String messageKey, String property, ActionMessages messages) {
        this.verifyActionMessagePresent(messageKey, messages);
        Iterator iterator = messages.get(property);
        while (iterator.hasNext()) {
            ActionMessage message = (ActionMessage)iterator.next();
            if (!message.getKey().equals(messageKey)) continue;
            return;
        }
        throw new VerifyFailedException("action message/error " + messageKey + " not present for property " + property);
    }

    public void verifyNumberActionErrors(int number) {
        this.verifyNumberActionMessages(number, this.getActionErrors());
    }

    public void verifyNumberActionMessages(int number) {
        this.verifyNumberActionMessages(number, this.getActionMessages());
    }

    private void verifyNumberActionMessages(int number, ActionMessages messages) {
        if (null != messages) {
            if (messages.size() == number) {
                return;
            }
            throw new VerifyFailedException("expected " + number + " messages/errors, received " + messages.size() + " messages/errors");
        }
        if (number == 0) {
            return;
        }
        throw new VerifyFailedException("no action messages/errors");
    }

    public ActionMessage getActionErrorByKey(String errorKey) {
        return this.getActionMessageByKey(errorKey, this.getActionErrors());
    }

    public ActionMessage getActionMessageByKey(String messageKey) {
        return this.getActionMessageByKey(messageKey, this.getActionMessages());
    }

    private ActionMessage getActionMessageByKey(String messageKey, ActionMessages messages) {
        if (null == messages) {
            return null;
        }
        Iterator iterator = messages.get();
        while (iterator.hasNext()) {
            ActionMessage message = (ActionMessage)iterator.next();
            if (!message.getKey().equals(messageKey)) continue;
            return message;
        }
        return null;
    }

    public void setActionMessages(ActionMessages messages) {
        this.mockFactory.getWrappedRequest().setAttribute(this.messageAttributeKey, (Object)messages);
    }

    public void setActionMessagesToSession(ActionMessages messages) {
        this.mockFactory.getMockSession().setAttribute(this.messageAttributeKey, (Object)messages);
    }

    public ActionMessages getActionMessages() {
        ActionMessages requestMessages = this.getActionMessagesFromRequest();
        ActionMessages sessionMessages = this.getActionMessagesFromSession();
        if (this.recognizeInSession) {
            if (null == requestMessages || requestMessages.isEmpty()) {
                return sessionMessages;
            }
            if (null == sessionMessages || sessionMessages.isEmpty()) {
                return requestMessages;
            }
            requestMessages = new ActionMessages(requestMessages);
            requestMessages.add(sessionMessages);
        }
        return requestMessages;
    }

    public ActionMessages getActionMessagesFromRequest() {
        return (ActionMessages)this.mockFactory.getWrappedRequest().getAttribute(this.messageAttributeKey);
    }

    public ActionMessages getActionMessagesFromSession() {
        return (ActionMessages)this.mockFactory.getMockSession().getAttribute(this.messageAttributeKey);
    }

    public boolean hasActionMessages() {
        ActionMessages messages = this.getActionMessages();
        return this.containsMessages(messages);
    }

    public void setActionErrors(ActionMessages errors) {
        this.mockFactory.getWrappedRequest().setAttribute(this.errorAttributeKey, (Object)errors);
    }

    public void setActionErrorsToSession(ActionMessages errors) {
        this.mockFactory.getMockSession().setAttribute(this.errorAttributeKey, (Object)errors);
    }

    public ActionMessages getActionErrors() {
        ActionMessages requestErrors = this.getActionErrorsFromRequest();
        ActionMessages sessionErrors = this.getActionErrorsFromSession();
        if (this.recognizeInSession) {
            if (null == requestErrors || requestErrors.isEmpty()) {
                return sessionErrors;
            }
            if (null == sessionErrors || sessionErrors.isEmpty()) {
                return requestErrors;
            }
            if (requestErrors instanceof ActionErrors || sessionErrors instanceof ActionErrors) {
                ActionErrors tempErrors = new ActionErrors();
                tempErrors.add(requestErrors);
                requestErrors = tempErrors;
            } else {
                requestErrors = new ActionMessages(requestErrors);
            }
            requestErrors.add(sessionErrors);
        }
        return requestErrors;
    }

    public ActionMessages getActionErrorsFromRequest() {
        return (ActionMessages)this.mockFactory.getWrappedRequest().getAttribute(this.errorAttributeKey);
    }

    public ActionMessages getActionErrorsFromSession() {
        return (ActionMessages)this.mockFactory.getMockSession().getAttribute(this.errorAttributeKey);
    }

    public boolean hasActionErrors() {
        ActionMessages errors = this.getActionErrors();
        return this.containsMessages(errors);
    }

    public MockActionMapping getMockActionMapping() {
        return this.mockFactory.getMockActionMapping();
    }

    public ActionMapping getActionMapping() {
        return this.mockFactory.getActionMapping();
    }

    public MockPageContext getMockPageContext() {
        return this.mockFactory.getMockPageContext();
    }

    public MockActionForward getActionForward() {
        return this.forward;
    }

    public Action getLastAction() {
        return this.actionObj;
    }

    public void generateValidToken() {
        String token = String.valueOf(Math.random());
        this.mockFactory.getMockSession().setAttribute("org.apache.struts.action.TOKEN", (Object)token);
        this.addRequestParameter("org.apache.struts.taglib.html.TOKEN", token);
    }

    public ActionForm getActionForm() {
        return this.formObj;
    }

    public void setActionForm(ActionForm formObj) {
        this.formObj = formObj;
    }

    public ActionForm createActionForm(Class form) {
        try {
            if (null == form) {
                this.formObj = null;
                return null;
            }
            this.formObj = (ActionForm)form.newInstance();
            return this.formObj;
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public DynaActionForm createDynaActionForm(FormBeanConfig formConfig) {
        try {
            if (null == formConfig) {
                this.formObj = null;
                return null;
            }
            DynaActionFormClass formClass = DynaActionFormClass.createDynaActionFormClass((FormBeanConfig)formConfig);
            this.formObj = (DynaActionForm)formClass.newInstance();
            return (DynaActionForm)this.formObj;
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void populateRequestToForm() {
        try {
            this.handleActionForm();
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public ActionForward actionPerform(Class action) {
        return this.actionPerform(action, (ActionForm)null);
    }

    public ActionForward actionPerform(Action action) {
        return this.actionPerform(action, (ActionForm)null);
    }

    public ActionForward actionPerform(Class action, Class form) {
        this.createActionForm(form);
        return this.actionPerform(action, this.formObj);
    }

    public ActionForward actionPerform(Action action, Class form) {
        this.createActionForm(form);
        return this.actionPerform(action, this.formObj);
    }

    public ActionForward actionPerform(Class action, ActionForm form) {
        Action actionToCall = null;
        try {
            actionToCall = (Action)action.newInstance();
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
        return this.actionPerform(actionToCall, form);
    }

    public ActionForward actionPerform(Action action, ActionForm form) {
        block8: {
            try {
                this.actionObj = action;
                this.actionObj.setServlet((ActionServlet)this.mockFactory.getMockActionServlet());
                this.formObj = form;
                this.setActionErrors(null);
                this.getActionMapping().setType(action.getClass().getName());
                if (null != this.formObj) {
                    this.handleActionForm();
                }
                if (!this.hasActionErrors()) {
                    ActionForward currentForward;
                    block7: {
                        currentForward = null;
                        try {
                            currentForward = this.actionObj.execute(this.getActionMapping(), this.formObj, this.mockFactory.getWrappedRequest(), this.mockFactory.getWrappedResponse());
                        }
                        catch (Exception exc) {
                            ExceptionHandlerConfig handler = this.findExceptionHandler(exc);
                            if (null == handler) {
                                throw exc;
                            }
                            Object result = handler.handle(exc, this.getActionMapping(), this.formObj, this.mockFactory.getWrappedRequest(), this.mockFactory.getWrappedResponse());
                            if (!(result instanceof ActionForward)) break block7;
                            currentForward = (ActionForward)result;
                        }
                    }
                    this.setResult(currentForward);
                    break block8;
                }
                this.setResult(this.getActionMapping().getInputForward());
            }
            catch (Exception exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return this.getActionForward();
    }

    public String getOutput() {
        try {
            this.mockFactory.getMockResponse().getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mockFactory.getMockResponse().getOutputStreamContent();
    }

    private void setResult(ActionForward currentForward) {
        this.forward = null == currentForward ? null : new MockActionForward(currentForward);
    }

    private ExceptionHandlerConfig findExceptionHandler(Exception exc) {
        for (int ii = 0; ii < this.exceptionHandlers.size(); ++ii) {
            ExceptionHandlerConfig next = (ExceptionHandlerConfig)this.exceptionHandlers.get(ii);
            if (!next.canHandle(exc)) continue;
            return next;
        }
        return null;
    }

    private void handleActionForm() throws Exception {
        ActionErrors errors;
        if (this.reset) {
            this.getActionForm().reset(this.getActionMapping(), this.mockFactory.getWrappedRequest());
        }
        if (this.doPopulate) {
            this.populateMockRequest();
        }
        this.formObj.setServlet((ActionServlet)this.mockFactory.getMockActionServlet());
        if (this.getActionMapping().getValidate() && this.containsMessages((ActionMessages)(errors = this.formObj.validate(this.getActionMapping(), this.mockFactory.getWrappedRequest())))) {
            this.mockFactory.getWrappedRequest().setAttribute(this.errorAttributeKey, (Object)errors);
        }
    }

    private void populateMockRequest() throws Exception {
        BeanUtils.populate((Object)this.getActionForm(), (Map)this.mockFactory.getWrappedRequest().getParameterMap());
    }

    private boolean containsMessages(ActionMessages messages) {
        return null != messages && messages.size() > 0;
    }
}

