/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.struts;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;

public class MapMessageResources
extends MessageResources {
    private static final Log log = LogFactory.getLog(MapMessageResources.class);
    private Map messages;

    public MapMessageResources() {
        this(null);
    }

    public MapMessageResources(Map messages) {
        this(messages, null, "", true);
    }

    public MapMessageResources(Map messages, MessageResourcesFactory factory, String config) {
        super(factory, config);
        this.messages = messages;
        if (null == this.messages) {
            this.messages = new HashMap();
        }
    }

    public MapMessageResources(Map messages, MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        this.messages = messages;
        if (null == this.messages) {
            this.messages = new HashMap();
        }
    }

    public String getMessage(Locale locale, String key) {
        return (String)this.messages.get(key);
    }

    public void putMessage(String key, String value) {
        this.messages.put(key, value);
    }

    public void putMessages(Map messages) {
        this.messages.putAll(messages);
    }

    public void putMessages(String propertyFileName) {
        this.putMessages(new File(propertyFileName));
    }

    public void putMessages(File propertyFile) {
        try {
            FileInputStream inputStream = new FileInputStream(propertyFile);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.putMessages(properties);
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
        }
    }

    public void clear() {
        this.formats.clear();
        this.messages.clear();
    }
}

