/*
 * Decompiled with CFR 0.152.
 */
package com.modus.common.message;

import com.modus.common.message.BaseMessage;
import com.modus.common.message.MessageMDN;
import com.modus.openas2.OpenAS2Exception;
import com.modus.openas2.message.DataHistoryItem;
import com.modus.openas2.util.DateUtil;
import com.modus.openas2.util.RandomUtil;
import java.text.DecimalFormat;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Message
extends BaseMessage {
    private static final Log logger = LogFactory.getLog(Message.class);
    private MessageMDN MDN;
    private String originalMIC;

    public String generateMessageID() {
        StringBuilder buf = new StringBuilder();
        String dateFormat = "ddMMyyyyHHmmssZ";
        buf.append("<MODUSAS2-").append(DateUtil.formatDate(dateFormat));
        DecimalFormat randomFormatter = new DecimalFormat("0000");
        buf.append("-").append(randomFormatter.format(RandomUtil.getRandomGenerator().nextInt(10000)));
        String senderID = this.getHeader("AS2-From");
        String receiverID = this.getHeader("AS2-To");
        buf.append("@").append(receiverID);
        buf.append("_").append(senderID);
        buf.append(">");
        String messageId = buf.toString();
        return messageId;
    }

    public boolean isRequestingMDN() {
        boolean requested = this.getHeader("Disposition-Notification-To") != null || this.getHeader("Disposition-Notification-Options") != null;
        return requested;
    }

    public boolean isRequestingAsynchMDN() {
        boolean requested = (this.getHeader("Disposition-Notification-To") != null || this.getHeader("Disposition-Notification-Options") != null) && this.getHeader("Receipt-Delivery-Option") != null;
        return requested;
    }

    public String getAsyncMDNurl() {
        return this.getHeader("Receipt-Delivery-Option");
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentDisposition(String contentDisposition) {
        this.setHeader("Content-Disposition", contentDisposition);
    }

    public String getContentDisposition() {
        return this.getHeader("Content-Disposition");
    }

    private void setData(MimeBodyPart data, DataHistoryItem historyItem) {
        this.data = data;
        if (data != null) {
            try {
                this.setContentType(data.getContentType());
            }
            catch (MessagingException e) {
                logger.warn("Error setting ContentDisposition, defaults to null", e);
                this.setContentType(null);
            }
            try {
                this.setContentDisposition(data.getHeader("Content-Disposition", null));
            }
            catch (MessagingException e) {
                logger.warn("Error setting ContentDisposition, defaults to null", e);
                this.setContentDisposition(null);
            }
        }
        if (historyItem != null) {
            this.getHistory().getItems().add(historyItem);
        }
    }

    public DataHistoryItem setData(MimeBodyPart data) throws OpenAS2Exception {
        try {
            DataHistoryItem historyItem = new DataHistoryItem(data.getContentType());
            this.setData(data, historyItem);
            return historyItem;
        }
        catch (Exception e) {
            logger.error("Error setting Data on message.", e);
            throw new OpenAS2Exception(e.getMessage());
        }
    }

    public void setMDN(MessageMDN mdn) {
        this.MDN = mdn;
    }

    public MessageMDN getMDN() {
        return this.MDN;
    }

    public void setSubject(String subject) {
        this.setHeader("Subject", subject);
    }

    public String getSubject() {
        return this.getHeader("Subject");
    }

    public String toString() {
        Header header;
        StringBuilder buf = new StringBuilder();
        buf.append("\n\n");
        buf.append("Message " + this.getLoggingText());
        buf.append("\n\t");
        buf.append("From:").append(this.getHeader("AS2-From"));
        buf.append("\n\t");
        buf.append("To:").append(this.getHeader("AS2-To"));
        Enumeration headerEn = this.getHeaders().getAllHeaders();
        buf.append("\r\nHeaders:{");
        while (headerEn.hasMoreElements()) {
            buf.append("\n\t");
            header = (Header)headerEn.nextElement();
            buf.append(header.getName()).append("=").append(header.getValue());
            if (!headerEn.hasMoreElements()) continue;
            buf.append(", ");
        }
        buf.append("} \n");
        if (this.getData() != null) {
            buf.append("Payload Headers:{");
            try {
                headerEn = this.getData().getAllHeaders();
                while (headerEn.hasMoreElements()) {
                    buf.append("\n\t");
                    header = (Header)headerEn.nextElement();
                    buf.append(header.getName()).append("=").append(header.getValue());
                    if (!headerEn.hasMoreElements()) continue;
                    buf.append(", ");
                }
            }
            catch (MessagingException e) {
                logger.warn("Problem accesing headers while executing Message#toString()", e);
            }
            buf.append("} \n");
        }
        buf.append("Original MIC:" + this.getOriginalMIC());
        MessageMDN mdn = this.getMDN();
        if (mdn != null) {
            buf.append("\r\nMDN:{");
            buf.append(mdn.toString());
        }
        buf.append("\r\n}");
        return buf.toString();
    }

    public Message clone() {
        Message clonedMessage = new Message();
        clonedMessage.setContentDisposition(this.getContentDisposition());
        clonedMessage.setContentType(this.getContentType());
        try {
            clonedMessage.setData(this.getData());
        }
        catch (OpenAS2Exception e) {
            logger.warn("Error cloning a Message", e);
        }
        clonedMessage.setOriginalMIC(this.getOriginalMIC());
        clonedMessage.setHeaders(this.getHeaders());
        clonedMessage.setHistory(this.getHistory());
        clonedMessage.setMDN(this.getMDN());
        clonedMessage.setMessageID(this.getMessageID());
        clonedMessage.setSubject(this.getSubject());
        return clonedMessage;
    }

    public String getOriginalMIC() {
        return this.originalMIC;
    }

    public void setOriginalMIC(String originalMIC) {
        this.originalMIC = originalMIC;
    }
}

