/*
 * Decompiled with CFR 0.152.
 */
package com.modus.common.message;

import com.modus.common.message.BaseMessage;
import com.modus.common.message.Message;
import com.modus.openas2.util.DateUtil;
import com.modus.openas2.util.RandomUtil;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageMDN
extends BaseMessage {
    private static final Log logger = LogFactory.getLog(MessageMDN.class);
    private String text;
    private Message message;

    public MessageMDN() {
    }

    public MessageMDN(Message msg) {
        this.setMessage(msg);
        this.setHeader("AS2-To", msg.getHeader("AS2-From"));
        this.setHeader("AS2-From", msg.getHeader("AS2-To"));
    }

    private String generateMessageID() {
        StringBuilder buf = new StringBuilder();
        String dateFormat = "ddMMyyyyHHmmssZ";
        buf.append("<MODUSAS2-").append(DateUtil.formatDate(dateFormat));
        DecimalFormat randomFormatter = new DecimalFormat("0000");
        buf.append("-").append(randomFormatter.format(RandomUtil.getRandomGenerator().nextInt(10000)));
        if (this.getMessage() != null) {
            String senderID = this.getMessage().getHeader("AS2-From");
            String receiverID = this.getMessage().getHeader("AS2-To");
            buf.append("@").append(receiverID);
            buf.append("_").append(senderID);
        }
        buf.append(">");
        return buf.toString();
    }

    public void setData(MimeBodyPart data) {
        this.data = data;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n\n");
        buf.append("MDN " + this.getLoggingText());
        buf.append("\n\t");
        buf.append("From:").append(this.getHeader("AS2-From"));
        buf.append("\n\t");
        buf.append("To:").append(this.getHeader("AS2-To"));
        Enumeration headerEn = this.getHeaders().getAllHeaders();
        buf.append("\r\nHeaders:{");
        while (headerEn.hasMoreElements()) {
            buf.append("\n\t");
            Header header = (Header)headerEn.nextElement();
            buf.append(header.getName()).append("=").append(header.getValue());
            if (!headerEn.hasMoreElements()) continue;
            buf.append(", ");
        }
        buf.append("\n}");
        try {
            if (this.getData() != null && this.getData().isMimeType("multipart/*")) {
                buf.append("\n##################### Multipart content ##############\n");
                MimeMultipart content = (MimeMultipart)this.getData().getContent();
                int count = content.getCount();
                for (int i = 0; i < count; ++i) {
                    buf.append("\n------------------- Part " + i + " ---------------- \n");
                    buf.append("\nHeaders {\n");
                    headerEn = content.getBodyPart(i).getAllHeaders();
                    while (headerEn.hasMoreElements()) {
                        Header header = (Header)headerEn.nextElement();
                        buf.append(header.getName()).append("=").append(header.getValue());
                        if (headerEn.hasMoreElements()) {
                            buf.append(", ");
                        }
                        buf.append("\n");
                    }
                    buf.append("}");
                    buf.append("\nContent: {\n");
                    buf.append(content.getBodyPart(i).getContent());
                    buf.append("}");
                }
                buf.append("\n######################################################\n");
            }
        }
        catch (MessagingException e) {
            logger.warn("Problem accesing headers while executing Message#toString()", e);
        }
        catch (IOException e) {
            logger.warn("Problem accesing headers while executing Message#toString()", e);
        }
        return buf.toString();
    }

    public void updateMessageID() {
        this.setMessageID(this.generateMessageID());
    }
}

