/*
 * Decompiled with CFR 0.152.
 */
package com.modus.common.service.agreement;

import com.modus.common.message.Message;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Agreement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MIME_VERSION = "1.0";
    private static final String AS2_VERSION = "1.1";
    private static final String SIGNED_RECEIPT_PROTOCOL_REQUIRED = "required, pkcs7-signature; ";
    private static final String SIGNED_RECEIPT_PROTOCOL_OPTIONAL = "optional, pkcs7-signature; ";
    private static final String MIC_ALGORITHM_IMPORTANCE_REQUIRED = "required";
    private static final String MIC_ALGORITHM_IMPORTANCE_OPTIONAL = "optional";
    private String receiverID;
    private String senderID;
    private String senderCertificate;
    private String receiverCertificate;
    private Boolean signed = null;
    private Boolean encrypted = null;
    private Boolean compressed = null;
    private String senderPassword;
    private String receiverPassword;
    private String micAlgorithm;
    private String fallbackMicAlgorithm;
    private String micAlgorithmImportance;
    private String mdnToUrl;
    private String mdnOptions;
    private String mdnSubject;
    private boolean requestReceipt = false;
    private boolean requestUnsignedReceipt = true;
    private String signedReceiptProtocol;
    private String asyncMdnToUrl;
    private String subject;
    private String filename;
    private String contentType;
    private String contentTransferEncoding;

    public Agreement from(String from) {
        this.setSenderID(from);
        return this;
    }

    public Agreement to(String to) {
        this.setReceiverID(to);
        return this;
    }

    public Agreement subject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public Agreement setMDNOptions(String mdnOpts) {
        boolean emptyOpts = StringUtils.isEmpty((String)mdnOpts);
        if (!emptyOpts) {
            this.setRequestUnsignedReceipt(false);
            this.parseMDNOptions(mdnOpts);
        }
        this.mdnOptions = mdnOpts;
        return this;
    }

    public String getMDNOptions() {
        return this.mdnOptions;
    }

    public Agreement encrypted() {
        this.encrypted = true;
        return this;
    }

    public Agreement notEncrypted() {
        this.encrypted = false;
        return this;
    }

    public Agreement signed() {
        this.signed = true;
        return this;
    }

    public Agreement notSigned() {
        this.signed = false;
        return this;
    }

    public Agreement compressed() {
        this.compressed = true;
        return this;
    }

    public Agreement notCompressed() {
        this.compressed = false;
        return this;
    }

    public Agreement setSignedMicAlgorithmOptional() {
        this.setMicAlgorithmImportance(MIC_ALGORITHM_IMPORTANCE_OPTIONAL);
        return this;
    }

    private void setMicAlgorithmImportance(String micAlgorithmImportance) {
        this.micAlgorithmImportance = micAlgorithmImportance;
    }

    public String getMicAlgorithm() {
        return this.micAlgorithm;
    }

    public Agreement setMicAlgorithm(String micAlgorithm) {
        this.micAlgorithm = micAlgorithm;
        return this;
    }

    public String getFallbackMicAlgorithm() {
        return this.fallbackMicAlgorithm;
    }

    public Agreement setFallbackMicAlgorithm(String fallbackMicAlgorithm) {
        this.fallbackMicAlgorithm = fallbackMicAlgorithm;
        return this;
    }

    public String getMDNToUrl() {
        return this.mdnToUrl;
    }

    public Agreement setMDNToUrl(String mdnToUrl) {
        this.setRequestReceipt(!StringUtils.isEmpty((String)mdnToUrl));
        this.mdnToUrl = mdnToUrl;
        return this;
    }

    public String getMimeVersion() {
        return MIME_VERSION;
    }

    public String getAS2Version() {
        return AS2_VERSION;
    }

    public String getEncryptionAlgorithm() {
        return "3des";
    }

    public String getSigningAlgorithm() {
        return "sha1";
    }

    private void parseMDNOptions(String mdnOpts) {
        String[] options = StringUtils.split((String)mdnOpts, (String)";");
        String[] signedReceiptProtocols = StringUtils.split((String)options[0], (String)"=");
        this.setSignedReceiptProtocol(signedReceiptProtocols[1]);
        String[] micAlgorithms = StringUtils.split((String)StringUtils.split((String)options[1], (String)"=")[1], (String)",");
        this.setMicAlgorithmImportance(micAlgorithms[0]);
        this.setMicAlgorithm(StringUtils.trimToEmpty((String)micAlgorithms[1]));
        if (micAlgorithms.length > 2) {
            this.setFallbackMicAlgorithm(StringUtils.trimToEmpty((String)micAlgorithms[2]));
        }
    }

    public boolean isRequestReceipt() {
        return this.requestReceipt;
    }

    public Agreement setRequestReceipt(boolean requestReceipt) {
        this.requestReceipt = requestReceipt;
        return this;
    }

    public boolean isRequestUnsignedReceipt() {
        return this.requestUnsignedReceipt;
    }

    public Agreement setRequestUnsignedReceipt(boolean requestUnsignedReceipt) {
        this.requestUnsignedReceipt = requestUnsignedReceipt;
        return this;
    }

    private String getMicAlgorithmImportance() {
        return this.micAlgorithmImportance;
    }

    public Agreement setSignedMicAlgorithmRequired() {
        this.setMicAlgorithmImportance(MIC_ALGORITHM_IMPORTANCE_REQUIRED);
        return this;
    }

    public String getSenderCertificate() {
        return this.senderCertificate;
    }

    public Agreement usingSenderCertificate(String senderCertificatePath) {
        this.senderCertificate = senderCertificatePath;
        return this;
    }

    public String getReceiverCertificate() {
        return this.receiverCertificate;
    }

    public Agreement usingReceiverCertificate(String receiverCertificatePath) {
        this.receiverCertificate = receiverCertificatePath;
        return this;
    }

    public String getSenderPassword() {
        return this.senderPassword;
    }

    public Agreement setSenderPassword(String senderPassword) {
        this.senderPassword = senderPassword;
        return this;
    }

    public String getReceiverPassword() {
        return this.receiverPassword;
    }

    public Agreement setReceiverPassword(String receiverPassword) {
        this.receiverPassword = receiverPassword;
        return this;
    }

    public String getMDNSubject() {
        return this.mdnSubject;
    }

    public Agreement setMDNSubject(String mdnSubject) {
        this.mdnSubject = mdnSubject;
        return this;
    }

    public void makeMDNOptions(Message msg) {
        if (this.getMDNOptions() != null) {
            msg.addHeader("Disposition-Notification-Options", this.getMDNOptions());
        } else if (this.isRequestReceipt() && !this.isRequestUnsignedReceipt()) {
            String mdnOptions = "signed-receipt-protocol=";
            mdnOptions = mdnOptions + this.getSignedReceiptProtocol();
            mdnOptions = mdnOptions + "signed-receipt-micalg=" + this.getMicAlgorithmImportance();
            mdnOptions = mdnOptions + "," + this.getMicAlgorithm();
            if (this.getFallbackMicAlgorithm() != null) {
                mdnOptions = mdnOptions + "," + this.getFallbackMicAlgorithm();
            }
            msg.addHeader("Disposition-Notification-Options", mdnOptions);
        }
    }

    public void setSignedReceiptProtocolRequired() {
        this.setSignedReceiptProtocol(SIGNED_RECEIPT_PROTOCOL_REQUIRED);
    }

    public void setSignedReceiptProtocolOptional() {
        this.setSignedReceiptProtocol(SIGNED_RECEIPT_PROTOCOL_OPTIONAL);
    }

    public String getSignedReceiptProtocol() {
        return this.signedReceiptProtocol;
    }

    private void setSignedReceiptProtocol(String protocol) {
        this.signedReceiptProtocol = protocol;
    }

    public Boolean isSigned() {
        return this.signed;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public Boolean isCompressed() {
        return this.compressed;
    }

    public String getAsyncMDNToUrl() {
        return this.asyncMdnToUrl;
    }

    public Agreement setAsyncMDNToUrl(String asyncMDNToUrl) {
        this.asyncMdnToUrl = asyncMDNToUrl;
        return this;
    }

    public String getSenderID() {
        return this.senderID;
    }

    public void setSenderID(String senderID) {
        this.senderID = senderID;
    }

    public String getReceiverID() {
        return this.receiverID;
    }

    public void setReceiverID(String receiverID) {
        this.receiverID = receiverID;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }
}

