/*
 * Decompiled with CFR 0.152.
 */
package com.modus.common.service.result;

import com.modus.common.exception.AS2ServiceException;
import com.modus.common.message.MessageMDN;
import com.modus.common.service.result.AS2ResultError;
import com.modus.common.service.result.AS2ResultSuccess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AS2Result {
    private static final Log logger = LogFactory.getLog(AS2Result.class);
    private MessageMDN mdn;

    protected AS2Result(MessageMDN mdn) {
        this.mdn = mdn;
    }

    public abstract boolean isSuccess();

    public abstract boolean isError();

    public abstract AS2ServiceException getError();

    public MessageMDN getMDN() {
        return this.mdn;
    }

    public static AS2Result error(MessageMDN mdn, AS2ServiceException e) {
        logger.error("AS2 processing error occurred. MDN being returned: " + mdn);
        return new AS2ResultError(mdn, e);
    }

    public static AS2Result success(MessageMDN mdn) {
        return new AS2ResultSuccess(mdn);
    }
}

