/*
 * Decompiled with CFR 0.152.
 */
package com.modus.common.service.util;

import com.modus.common.service.agreement.Agreement;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AS2ServiceUtil {
    private AS2ServiceUtil() {
    }

    public static Map<String, Serializable> buildHeadersFromAgreement(Agreement agreement) {
        HashMap<String, Serializable> headers = new HashMap<String, Serializable>();
        headers.put("AS2-Version", (Serializable)((Object)agreement.getAS2Version()));
        headers.put("AS2-From", (Serializable)((Object)agreement.getSenderID()));
        headers.put("AS2-To", (Serializable)((Object)agreement.getReceiverID()));
        headers.put("Subject", (Serializable)((Object)agreement.getSubject()));
        headers.put("Disposition-Notification-To", (Serializable)((Object)agreement.getMDNToUrl()));
        headers.put("Disposition-Notification-Options", (Serializable)((Object)agreement.getMDNOptions()));
        headers.put("Content-Disposition", (Serializable)((Object)("Attachment; filename=\"" + agreement.getFilename() + "\"")));
        headers.put("Receipt-Delivery-Option", (Serializable)((Object)agreement.getAsyncMDNToUrl()));
        headers.put("custom-payload-filename", (Serializable)((Object)agreement.getFilename()));
        headers.put("custom-content-type", (Serializable)((Object)agreement.getContentType()));
        headers.put("custom-content-transfer-encoding", (Serializable)((Object)agreement.getContentTransferEncoding()));
        headers.put("custom-mic-algorithm", (Serializable)((Object)agreement.getMicAlgorithm()));
        headers.put("custom-mic-fallback-algorithm", (Serializable)((Object)agreement.getFallbackMicAlgorithm()));
        return headers;
    }
}

