/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2;

import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.FileStorageEnum;
import com.modus.mule.modules.as2.GlobalContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.ClientFacadeFactory;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.common.ContentTransferEncodingEnum;
import com.modus.mule.modules.as2.common.MicAlgorithmEnum;
import com.modus.mule.modules.as2.common.MicAlgorithmOptionEnum;
import com.modus.mule.modules.as2.common.RequestReceipt;
import com.modus.mule.modules.as2.filestorage.NullFileStorageService;
import com.modus.mule.modules.as2.filestorage.s3.S3FileStorageService;
import com.modus.mule.modules.as2.messagetracker.MemoryMessageTracker;
import com.modus.mule.modules.as2.messagetracker.RemoteMessageTracker;
import com.modus.mule.modules.as2.server.ServerConfig;
import com.modus.mule.modules.as2.server.ServerFacade;
import com.modus.mule.modules.as2.tpm.TpmService;
import com.modus.service.AS2ServiceImpl;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.callback.SourceCallback;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AS2Connector {
    private static final Logger logger = Logger.getLogger(AS2Connector.class);
    @Inject
    private MuleContext muleContext;
    private String httpEndpointRef;
    private String messageTrackerAddress;
    private FileStorageEnum fileStorageType;
    private String tpmServiceAddress;
    private ServerFacade as2Server;
    private ClientFacadeFactory as2ClientFactory;
    private final ConnectorContext connectorContext = new ConnectorContext();
    private GlobalContext globalContext;
    private static final String KEY_STORE_PATH_FRIENDLY_NAME = "Key Store Path";
    private static final String KEY_STORE_PASSWORD_FRIENDLY_NAME = "Key Store Password";
    private static final String KEY_STORE_PASSWORD_SUMMARY = "Password protecting the key store.";

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public synchronized void receive(SourceCallback callback, String receiptSubject, Boolean requireSenderCompress, String requireSenderAs2From, String requireSenderAs2To, String keyStorePath, String keyStorePassword, Boolean requireSenderSigns, Boolean requireSenderEncrypts, MicAlgorithmOptionEnum preferredMicAlgorithm) throws AS2ConnectorException {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setAs2From(requireSenderAs2From);
        serverConfig.setAs2To(requireSenderAs2To);
        serverConfig.setReceiptSubject(receiptSubject);
        serverConfig.setRequireSenderSigns(requireSenderSigns);
        serverConfig.setRequireSenderEncrypts(requireSenderEncrypts);
        serverConfig.setRequireSenderCompress(requireSenderCompress);
        serverConfig.setKeyStorePath(keyStorePath);
        serverConfig.setKeyStorePassword(keyStorePassword);
        serverConfig.setPreferredMicAlgorithm(preferredMicAlgorithm);
        serverConfig.setHttpEndpointRef(this.httpEndpointRef);
        this.as2Server = new ServerFacade(callback, this.muleContext, serverConfig, this.connectorContext);
        this.as2Server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    @Autowired(required=false)
    public MuleEvent send(String subject, String contentType, ContentTransferEncodingEnum contentTransferEncoding, String filename, Integer receiptTimeout, Boolean compress, String as2From, String as2To, String keyStorePath, String keyStorePassword, String receiptVerificationCertificateKeyStoreEntryAlias, String asyncReceiptTlsCertificateKeyStoreEntryAlias, RequestReceipt requestReceipt, Boolean sign, Boolean encrypt, Boolean requireSignedReceipt, Boolean requireMicAlgorithm, MicAlgorithmEnum micAlgorithm, MicAlgorithmOptionEnum fallbackMicAlgorithm, String receiptDeliveryOption, MuleEvent muleEvent) throws AS2ConnectorException {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setAs2From(as2From);
        clientConfig.setAs2To(as2To);
        clientConfig.setSubject(subject);
        clientConfig.setContentType(contentType);
        clientConfig.setSign(sign);
        clientConfig.setEncrypt(encrypt);
        clientConfig.setRequireSignedReceipt(requireSignedReceipt);
        clientConfig.setRequireSignedReceiptMicAlg(requireMicAlgorithm);
        clientConfig.setMicAlgorithm(micAlgorithm);
        clientConfig.setFallbackMicAlgorithm(fallbackMicAlgorithm);
        clientConfig.setKeyStorePath(keyStorePath);
        clientConfig.setKeyStorePassword(keyStorePassword);
        clientConfig.setRequestReceipt(requestReceipt);
        clientConfig.setFilename(filename);
        clientConfig.setReceiptDeliveryOption(receiptDeliveryOption);
        clientConfig.setReceiptTimeout(receiptTimeout);
        clientConfig.setContentTransferEncoding(contentTransferEncoding);
        clientConfig.setAsyncReceiptTlsCertificateKeyStoreEntryAlias(asyncReceiptTlsCertificateKeyStoreEntryAlias);
        clientConfig.setReceiptVerificationCertificateKeyStoreEntryAlias(receiptVerificationCertificateKeyStoreEntryAlias);
        clientConfig.setCompress(compress);
        if (this.as2ClientFactory == null) {
            AS2Connector aS2Connector = this;
            synchronized (aS2Connector) {
                this.as2ClientFactory = new ClientFacadeFactory(clientConfig, this.httpEndpointRef, this.muleContext, this.connectorContext);
            }
        }
        return this.as2ClientFactory.createClient(clientConfig, this.connectorContext).send(muleEvent);
    }

    @PostConstruct
    public void onPostConstruct() throws AS2ConnectorException {
        this.globalContext = GlobalContext.getInstance();
        this.connectorContext.setAs2Service(new AS2ServiceImpl());
        this.setFileStorageImpl();
        this.setMessageTrackerImpl();
        this.createTpmService(this.connectorContext, this.tpmServiceAddress);
    }

    public String getHttpEndpointRef() {
        return this.httpEndpointRef;
    }

    public void setHttpEndpointRef(String httpEndpointRef) {
        this.httpEndpointRef = httpEndpointRef;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String getMessageTrackerAddress() {
        return this.messageTrackerAddress;
    }

    public void setMessageTrackerAddress(String messageTrackerAddress) {
        this.messageTrackerAddress = StringUtils.isNotEmpty((String)messageTrackerAddress) && messageTrackerAddress.endsWith("/") ? messageTrackerAddress.substring(0, messageTrackerAddress.length() - 1) : messageTrackerAddress;
    }

    private void setMessageTrackerImpl() {
        if (StringUtils.isEmpty((String)this.messageTrackerAddress)) {
            this.connectorContext.setMessageTracker(new MemoryMessageTracker(this.muleContext));
        } else {
            this.connectorContext.setMessageTracker(new RemoteMessageTracker(this.messageTrackerAddress));
        }
    }

    private void createTpmService(ConnectorContext connectorContext, String tpmServiceAddress) {
        if (StringUtils.isNotEmpty((String)tpmServiceAddress)) {
            connectorContext.setTpmService(new TpmService(tpmServiceAddress));
        }
    }

    public ConnectorContext getConnectorContext() {
        return this.connectorContext;
    }

    public FileStorageEnum getFileStorageType() {
        return this.fileStorageType;
    }

    public void setFileStorageType(FileStorageEnum fileStorageType) {
        this.fileStorageType = fileStorageType;
    }

    private void setFileStorageImpl() {
        if (this.fileStorageType == null || this.fileStorageType.equals((Object)FileStorageEnum.none)) {
            this.connectorContext.setFileStorageService(new NullFileStorageService());
        } else if (this.fileStorageType.equals((Object)FileStorageEnum.s3)) {
            this.connectorContext.setFileStorageService(new S3FileStorageService(System.getProperty("aws.accessKeyId"), System.getProperty("aws.secretKey"), System.getProperty("aws.s3.bucketName")));
        }
    }

    public String getTpmServiceAddress() {
        return this.tpmServiceAddress;
    }

    public void setTpmServiceAddress(String tpmServiceAddress) {
        this.tpmServiceAddress = tpmServiceAddress;
    }
}

