/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2;

import java.io.Closeable;
import java.io.IOException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.mule.module.launcher.MuleContainer;

public class GlobalContext
implements Closeable {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static GlobalContext globalContext = null;
    private static final Logger logger = Logger.getLogger(MuleContainer.class);
    private CloseableHttpAsyncClient httpAsyncClient;
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper;

    public static GlobalContext getInstance() {
        if (globalContext == null) {
            globalContext = new GlobalContext();
        }
        return globalContext;
    }

    private GlobalContext() {
        String splashScreen = "\n**********************************************************************\n" + "* AS2 Connector                                                      *\n" + "* Version: 1.0.0                                                     *\n" + "* Powered by Modus Box                                               *\n" + "**********************************************************************";
        logger.info((Object)splashScreen);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        this.httpAsyncClient = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        this.httpAsyncClient.start();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    public CloseableHttpAsyncClient getHttpAsyncClient() {
        return this.httpAsyncClient;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void close() throws IOException {
        this.httpAsyncClient.close();
        this.httpClient.close();
    }
}

