/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.client;

import com.modus.common.message.Message;
import com.modus.common.message.MessageMDN;
import com.modus.common.service.AS2Service;
import com.modus.common.service.agreement.Agreement;
import com.modus.common.service.agreement.SecurityInfo;
import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.SslV2HelloEnabledSslServerSocketFactory;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.common.ContentTransferEncodingEnum;
import com.modus.mule.modules.as2.common.MessageLogger;
import com.modus.mule.modules.as2.common.MicAlgorithmEnum;
import com.modus.mule.modules.as2.common.MicAlgorithmOptionEnum;
import com.modus.mule.modules.as2.common.RequestReceipt;
import com.modus.mule.modules.as2.messagetracker.As2Transmission;
import com.modus.mule.modules.as2.messagetracker.Callback;
import com.modus.mule.modules.as2.messagetracker.MdnContent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Header;
import org.apache.log4j.Logger;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.MuleContextNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.tcp.SimpleServerSocketFactory;
import org.mule.util.IOUtils;
import org.mule.util.ObjectNameHelper;
import org.mule.util.StringUtils;

public class ClientFacade {
    private static final int MESSAGE_TRACKER_POLL_INTERVAL_MILLISECONDS = 1000;
    private static final Logger logger = Logger.getLogger(ClientFacade.class);
    private OutboundEndpoint outboundEndpoint;
    private ClientConfig clientConfig;
    private AS2Service as2Service;
    private MuleContext muleContext;
    private Map<String, InboundEndpoint> receiptListenerCache;
    private ConnectorContext connectorContext;

    public ClientFacade(OutboundEndpoint outboundEndpoint, MuleContext muleContext, ClientConfig clientConfig, ConnectorContext connectorContext, Map<String, InboundEndpoint> receiptListenerCache) {
        this.clientConfig = clientConfig;
        this.outboundEndpoint = outboundEndpoint;
        this.as2Service = connectorContext.getAs2Service();
        this.muleContext = muleContext;
        this.receiptListenerCache = receiptListenerCache;
        this.connectorContext = connectorContext;
    }

    private As2Transmission pollTransmissionForReceipt(Message as2Message, MuleEvent muleEvent) throws Exception {
        As2Transmission resultAs2Transmission;
        int elapsedTimeMilliseconds = 0;
        As2Transmission queryAs2Transmission = new As2Transmission();
        queryAs2Transmission.setAs2MessageId(as2Message.getMessageID());
        while ((resultAs2Transmission = this.connectorContext.getMessageTracker().get(queryAs2Transmission)) == null || resultAs2Transmission.getMdnStatus() == null || resultAs2Transmission.getMdnStatus() != 1) {
            Thread.sleep(1000L);
            if ((elapsedTimeMilliseconds += 1000) <= this.clientConfig.getReceiptTimeout()) continue;
            this.updateAs2TransmissionToFailed(as2Message.getMessageID(), new Callback<As2Transmission>(){

                @Override
                public void completed(As2Transmission result) {
                }

                @Override
                public void completed() {
                }

                @Override
                public void failed(Exception e) {
                }
            });
            throw new MessagingException(MessageFactory.createStaticMessage((String)"Timed out waiting for async receipt"), muleEvent);
        }
        return resultAs2Transmission;
    }

    public MuleEvent send(MuleEvent muleEvent) throws AS2ConnectorException {
        String address = this.getDestinationAddress(this.muleContext, muleEvent, this.outboundEndpoint);
        try {
            Agreement agreement = this.createAgreement(this.clientConfig, address);
            SecurityInfo info = new SecurityInfo(this.clientConfig.getKeyStorePath(), this.clientConfig.getKeyStorePassword(), this.clientConfig.getKeyStorePath(), this.clientConfig.getKeyStorePassword(), this.clientConfig.getReceiptVerificationCertificateKeyStoreEntryAlias());
            Message as2Request = this.as2Service.prepare(agreement, new ByteArrayInputStream(muleEvent.getMessage().getPayloadAsBytes()), info, this.clientConfig.getCompress(), this.clientConfig.getSign(), this.clientConfig.getEncrypt());
            this.recordAs2Transmission(as2Request, muleEvent.getMessage().getPayloadAsBytes());
            DefaultMuleEvent requestMuleEvent = new DefaultMuleEvent(this.as2MessageToMuleMessage(as2Request), muleEvent);
            MuleEvent receiptMuleEvent = this.isAsyncReceiptRequest(this.clientConfig) ? this.sendAndReceiveAsyncReceipt(address, as2Request, (MuleEvent)requestMuleEvent) : this.sendAndReceiveReceipt(address, as2Request, (MuleEvent)requestMuleEvent);
            if (!this.clientConfig.getRequestReceipt().equals((Object)RequestReceipt.none)) {
                Map receiptHttpHeaders = (Map)receiptMuleEvent.getMessage().getInboundProperty("http.headers", new HashMap());
                this.as2Service.verify(as2Request.getOriginalMIC(), receiptHttpHeaders, receiptMuleEvent.getMessage().getPayloadAsBytes(), info);
            }
            return receiptMuleEvent;
        }
        catch (Exception e) {
            throw new AS2ConnectorException(e);
        }
    }

    private boolean isAsyncReceiptRequest(ClientConfig clientConfig) {
        return clientConfig.getReceiptDeliveryOption() != null;
    }

    private MuleMessage as2MessageToMuleMessage(Message mdnAs2Message) throws Exception {
        byte[] data = IOUtils.toByteArray((InputStream)mdnAs2Message.getData().getInputStream());
        DefaultMuleMessage mdnMuleMessage = new DefaultMuleMessage((Object)data, this.muleContext);
        Enumeration headers = mdnAs2Message.getHeaders().getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            mdnMuleMessage.setOutboundProperty(header.getName(), (Object)header.getValue());
        }
        mdnMuleMessage.setOutboundProperty("Content-Length", (Object)Integer.toString(data.length));
        return mdnMuleMessage;
    }

    private void recordAs2Transmission(Message mdnAs2Message, byte[] payload) throws Exception {
        String fileUrl = this.connectorContext.getFileStorageService().store(payload);
        As2Transmission as2Transmission = this.as2MessageToAs2Transmission(mdnAs2Message);
        as2Transmission.setFileUrl(fileUrl);
        this.connectorContext.getMessageTracker().create(as2Transmission);
    }

    private As2Transmission as2MessageToAs2Transmission(Message mdnAs2Message) throws Exception {
        As2Transmission as2Transmission = new As2Transmission();
        as2Transmission.setIsMessageEncrypted(this.clientConfig.getEncrypt());
        as2Transmission.setIsMessageSigned(this.clientConfig.getSign());
        as2Transmission.setMdnStatus(0);
        as2Transmission.setContentType(mdnAs2Message.getHeader("Content-Type"));
        as2Transmission.setAs2From(mdnAs2Message.getHeader("AS2-From"));
        as2Transmission.setAs2To(mdnAs2Message.getHeader("AS2-To"));
        as2Transmission.setFilename(this.clientConfig.getFilename());
        as2Transmission.setIsMDNExpected(true);
        as2Transmission.setMessageMicValue(mdnAs2Message.getOriginalMIC());
        as2Transmission.setTransmissionStatus(0);
        if (mdnAs2Message.isRequestingAsynchMDN()) {
            as2Transmission.setIsMDNAsync(true);
        }
        as2Transmission.setMessageDateTime(new Date().toString());
        as2Transmission.setAs2MessageId(mdnAs2Message.getMessageID());
        return as2Transmission;
    }

    private void updateAs2TransmissionToComplete(String id, MuleEvent muleEvent, Callback<As2Transmission> callback) throws Exception {
        As2Transmission as2Transmission = new As2Transmission();
        MdnContent mdnContent = new MdnContent();
        if (muleEvent.getMessage().getInboundProperty("Content-Type") != null) {
            mdnContent.setContentType(muleEvent.getMessage().getInboundProperty("Content-Type").toString());
        }
        mdnContent.setContent(muleEvent.getMessage().getPayloadAsBytes());
        as2Transmission.setMdnContent(mdnContent);
        as2Transmission.setMdnStatus(1);
        as2Transmission.setAs2MessageId(id);
        as2Transmission.setTransmissionStatus(1);
        as2Transmission.setReceivedDateTime(new Date().toString());
        as2Transmission.setIsMDNExpected(false);
        this.connectorContext.getMessageTracker().update(as2Transmission, callback);
    }

    private void updateAs2TransmissionToFailed(String id, Callback<As2Transmission> callback) throws Exception {
        As2Transmission as2Transmission = new As2Transmission();
        as2Transmission.setAs2MessageId(id);
        as2Transmission.setTransmissionStatus(2);
        as2Transmission.setIsMDNExpected(false);
        this.connectorContext.getMessageTracker().update(as2Transmission, callback);
    }

    public AS2Service getAs2Service() {
        return this.as2Service;
    }

    public void setAs2Service(AS2Service as2Service) {
        this.as2Service = as2Service;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReceiptListener(FlowConstruct flowConstruct, MuleContext muleContext) throws Exception {
        String endpointUri = this.buildEndpointUri(this.clientConfig.getReceiptDeliveryOption());
        Map<String, InboundEndpoint> map = this.receiptListenerCache;
        synchronized (map) {
            if (this.receiptListenerCache.get(endpointUri) == null) {
                InboundEndpoint inboundEndpoint = (InboundEndpoint)muleContext.getRegistry().lookupObject(ObjectNameHelper.getEndpointNameFor((EndpointURI)new MuleEndpointURI(endpointUri, muleContext)));
                if (inboundEndpoint == null) {
                    inboundEndpoint = this.buildInboundEndpoint(endpointUri, flowConstruct);
                }
                this.receiptListenerCache.put(endpointUri, inboundEndpoint);
            }
        }
    }

    private MuleEvent doSend(MuleEvent requestMuleEvent, OutboundEndpoint outboundEndpoint, String address) throws Exception {
        MessageLogger.logOutgoingMessage(requestMuleEvent.getMessage(), "Sending AS2 request to " + address, logger);
        MuleEvent replyMuleEvent = outboundEndpoint.process(requestMuleEvent);
        MessageLogger.logIncomingMessage(replyMuleEvent.getMessage(), "Received reply", logger);
        return replyMuleEvent;
    }

    private Agreement createAgreement(ClientConfig clientConfig, String toUrl) {
        Agreement agreement = new Agreement().from(clientConfig.getAs2From()).to(clientConfig.getAs2To()).subject(clientConfig.getSubject());
        if (clientConfig.getRequestReceipt().equals((Object)RequestReceipt.signed)) {
            agreement.setMDNToUrl(toUrl);
            agreement.setRequestReceipt(true);
            agreement.setRequestUnsignedReceipt(false);
            if (clientConfig.getRequireSignedReceipt().booleanValue()) {
                agreement.setSignedReceiptProtocolRequired();
            } else {
                agreement.setSignedReceiptProtocolOptional();
            }
            if (clientConfig.getRequireSignedReceiptMicAlg().booleanValue()) {
                agreement.setSignedMicAlgorithmRequired();
            } else {
                agreement.setSignedMicAlgorithmOptional();
            }
            if (clientConfig.getMicAlgorithm().equals((Object)MicAlgorithmEnum.sha1)) {
                agreement.setMicAlgorithm("sha1");
            } else {
                agreement.setMicAlgorithm("md5");
            }
            if (clientConfig.getFallbackMicAlgorithm().equals((Object)MicAlgorithmOptionEnum.sha1)) {
                agreement.setFallbackMicAlgorithm("sha1");
            } else if (clientConfig.getFallbackMicAlgorithm().equals((Object)MicAlgorithmOptionEnum.md5)) {
                agreement.setFallbackMicAlgorithm("md5");
            }
        } else if (clientConfig.getRequestReceipt().equals((Object)RequestReceipt.unsigned)) {
            agreement.setMDNToUrl(toUrl);
            agreement.setRequestReceipt(true);
            agreement.setRequestUnsignedReceipt(true);
        } else {
            agreement.setRequestReceipt(false);
        }
        if (clientConfig.getEncrypt().booleanValue()) {
            agreement.encrypted();
        }
        if (clientConfig.getSign().booleanValue()) {
            agreement.signed();
        }
        if (StringUtils.isNotBlank((String)clientConfig.getReceiptDeliveryOption())) {
            agreement.setAsyncMDNToUrl(clientConfig.getReceiptDeliveryOption());
        }
        if (StringUtils.isNotEmpty((String)clientConfig.getFilename())) {
            agreement.setFilename(clientConfig.getFilename());
        }
        if (StringUtils.isNotEmpty((String)clientConfig.getContentType())) {
            agreement.setContentType(clientConfig.getContentType());
        }
        if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum._7bit)) {
            agreement.setContentTransferEncoding("7bit");
        } else if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum._8bit)) {
            agreement.setContentTransferEncoding("8bit");
        } else if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum.base64)) {
            agreement.setContentTransferEncoding("base64");
        } else if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum.binary)) {
            agreement.setContentTransferEncoding("binary");
        } else if (clientConfig.getContentTransferEncoding().equals((Object)ContentTransferEncodingEnum.quoted_printable)) {
            agreement.setContentTransferEncoding("quoted-printable");
        }
        return agreement;
    }

    private String getDestinationAddress(MuleContext muleContext, MuleEvent muleEvent, OutboundEndpoint outboundEndpoint) {
        if (muleContext.getExpressionManager().isExpression(outboundEndpoint.getAddress())) {
            return muleContext.getExpressionManager().parse(outboundEndpoint.getAddress(), muleEvent).toString();
        }
        return outboundEndpoint.getAddress();
    }

    private MuleEvent sendAndReceiveAsyncReceipt(String address, Message as2Request, MuleEvent requestMuleEvent) throws Exception {
        this.createReceiptListener(requestMuleEvent.getFlowConstruct(), this.muleContext);
        this.doSend(requestMuleEvent, this.outboundEndpoint, address);
        As2Transmission as2Transmission = this.pollTransmissionForReceipt(as2Request, requestMuleEvent);
        MdnContent mdnContent = as2Transmission.getMdnContent();
        HashMap<String, String> receiptAs2Headers = new HashMap<String, String>();
        if (as2Transmission.getAs2From() != null) {
            receiptAs2Headers.put("AS2-From", as2Transmission.getAs2To());
        }
        if (as2Transmission.getContentType() != null) {
            receiptAs2Headers.put("Content-Type", mdnContent.getContentType());
        }
        DefaultMuleEvent receiptMuleEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)mdnContent.getContent(), this.muleContext), requestMuleEvent);
        receiptMuleEvent.getMessage().setProperty("http.headers", receiptAs2Headers, PropertyScope.INBOUND);
        return receiptMuleEvent;
    }

    private MuleEvent sendAndReceiveReceipt(String address, Message as2Request, MuleEvent requestMuleEvent) throws Exception {
        try {
            MuleEvent receiptMuleEvent = this.doSend(requestMuleEvent, this.outboundEndpoint, address);
            this.updateAs2TransmissionToComplete(as2Request.getMessageID(), receiptMuleEvent, new Callback<As2Transmission>(){

                @Override
                public void completed(As2Transmission result) {
                }

                @Override
                public void completed() {
                }

                @Override
                public void failed(Exception e) {
                }
            });
            return receiptMuleEvent;
        }
        catch (Exception e) {
            this.updateAs2TransmissionToFailed(as2Request.getMessageID(), new Callback<As2Transmission>(){

                @Override
                public void completed(As2Transmission result) {
                }

                @Override
                public void completed() {
                }

                @Override
                public void failed(Exception e) {
                }
            });
            throw new Exception(e);
        }
    }

    private String buildEndpointUri(String url) throws Exception {
        URL receiptDeliveryOption = new URL(url);
        String port = String.valueOf(receiptDeliveryOption.getPort());
        String protocol = receiptDeliveryOption.getProtocol();
        if (port.equals("-1")) {
            port = "80";
        }
        return protocol + "://0.0.0.0:" + port + receiptDeliveryOption.getFile();
    }

    private InboundEndpoint buildInboundEndpoint(String endpointUri, FlowConstruct flowConstruct) throws Exception {
        EndpointBuilder endpointBuilder = this.muleContext.getEndpointFactory().getEndpointBuilder(endpointUri);
        TransportFactory factory = new TransportFactory(this.muleContext);
        Connector connector = factory.createConnector(endpointUri);
        if (endpointUri.startsWith("https")) {
            HttpsConnector httpsConnector = (HttpsConnector)connector;
            httpsConnector.setKeyStore(this.clientConfig.getKeyStorePath());
            httpsConnector.setKeyStorePassword(this.clientConfig.getKeyStorePassword());
            httpsConnector.setKeyPassword("");
            TlsConfiguration tlsConfiguration = new TlsConfiguration(null);
            tlsConfiguration.setKeyStore(this.clientConfig.getKeyStorePath());
            tlsConfiguration.setKeyStorePassword(this.clientConfig.getKeyStorePassword());
            tlsConfiguration.setKeyPassword("");
            tlsConfiguration.initialise(null == httpsConnector.getKeyStore(), "javax.net");
            httpsConnector.setServerSocketFactory((SimpleServerSocketFactory)new SslV2HelloEnabledSslServerSocketFactory(tlsConfiguration));
        }
        this.muleContext.getRegistry().registerConnector(connector);
        endpointBuilder.setConnector(connector);
        final InboundEndpoint inboundEndpoint = this.muleContext.getEndpointFactory().getInboundEndpoint(endpointBuilder);
        this.muleContext.getRegistry().registerObject(inboundEndpoint.getName(), (Object)inboundEndpoint, ImmutableEndpoint.class);
        inboundEndpoint.setFlowConstruct(flowConstruct);
        inboundEndpoint.setListener(new MessageProcessor(){

            public MuleEvent process(MuleEvent receiptMuleEvent) throws MuleException {
                try {
                    MessageLogger.logIncomingMessage(receiptMuleEvent.getMessage(), "Received async receipt", logger);
                    MessageMDN messageMDN = ClientFacade.this.as2Service.createMDN((Map)receiptMuleEvent.getMessage().getInboundProperty("http.headers", new HashMap()), receiptMuleEvent.getMessage().getPayloadAsBytes());
                    ClientFacade.this.updateAs2TransmissionToComplete(messageMDN.getHeader("Original-Message-ID"), receiptMuleEvent, new Callback<As2Transmission>(){

                        @Override
                        public void completed(As2Transmission result) {
                        }

                        @Override
                        public void completed() {
                        }

                        @Override
                        public void failed(Exception e) {
                        }
                    });
                }
                catch (Exception e) {
                    throw new MessagingException(receiptMuleEvent, (Throwable)e);
                }
                return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"", ClientFacade.this.muleContext), receiptMuleEvent);
            }
        });
        this.muleContext.registerListener((ServerNotificationListener)new MuleContextNotificationListener(){

            public void onNotification(ServerNotification notification) {
                try {
                    if (notification.getAction() == 105) {
                        inboundEndpoint.stop();
                    }
                }
                catch (MuleException e) {
                    logger.error((Object)"An error occurred while stopping the connector", (Throwable)e);
                }
            }
        });
        inboundEndpoint.start();
        return inboundEndpoint;
    }
}

