/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.client;

import com.modus.mule.modules.as2.ConnectorContext;
import com.modus.mule.modules.as2.client.ClientConfig;
import com.modus.mule.modules.as2.client.ClientFacade;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.common.MicAlgorithmEnum;
import com.modus.mule.modules.as2.common.MicAlgorithmOptionEnum;
import com.modus.mule.modules.as2.common.RequestReceipt;
import com.modus.mule.modules.as2.tpm.As2Spec;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.i18n.MessageFactory;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.util.StringUtils;

public class ClientFacadeFactory {
    private OutboundEndpoint outboundEndpoint;
    private MuleContext muleContext;
    private Map<String, InboundEndpoint> receiptListenerCache = new HashMap<String, InboundEndpoint>();
    private ClientConfig as2SpecClientConfig;

    public ClientFacadeFactory(ClientConfig clientConfig, String httpEndpointRef, MuleContext muleContext, ConnectorContext connectorContext) throws AS2ConnectorException {
        this.muleContext = muleContext;
        this.outboundEndpoint = this.buildOutboundEndpoint(clientConfig, httpEndpointRef);
        this.as2SpecClientConfig = this.buildAs2SpecClientConfig(clientConfig, connectorContext);
    }

    public ClientFacade createClient(ClientConfig localClientConfig, ConnectorContext connectorContext) throws AS2ConnectorException {
        ClientConfig clientConfig = this.buildConfigFromAs2SpecAndLocalClientConfig(this.as2SpecClientConfig, localClientConfig);
        if (StringUtils.isEmpty((String)clientConfig.getAs2From()) || StringUtils.isEmpty((String)clientConfig.getAs2To())) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"AS2-From and AS2-To HTTP headers must be set"));
        }
        return new ClientFacade(this.outboundEndpoint, this.muleContext, clientConfig, connectorContext, this.receiptListenerCache);
    }

    private OutboundEndpoint buildOutboundEndpoint(ClientConfig clientConfig, String httpEndpointRef) throws AS2ConnectorException {
        EndpointURIEndpointBuilder endpointBuilder = (EndpointURIEndpointBuilder)this.muleContext.getRegistry().lookupObject(httpEndpointRef);
        if (endpointBuilder == null) {
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)("Invalid global HTTP/s endpoint reference: " + httpEndpointRef + ". Make sure the connector config is pointing to the correct global HTTP/s endpoint")));
        }
        try {
            if (clientConfig.getReceiptTimeout() != null && clientConfig.getReceiptDeliveryOption() == null) {
                endpointBuilder.setResponseTimeout(clientConfig.getReceiptTimeout().intValue());
            }
            return endpointBuilder.buildOutboundEndpoint();
        }
        catch (Exception e) {
            throw new AS2ConnectorException(e);
        }
    }

    private ClientConfig buildAs2SpecClientConfig(ClientConfig clientConfig, ConnectorContext connectorContext) throws AS2ConnectorException {
        ClientConfig as2SpecClientConfig = new ClientConfig();
        if (StringUtils.isNotEmpty((String)clientConfig.getSpecId())) {
            As2Spec as2Spec = connectorContext.getTpmService().getAs2Spec(clientConfig.getSpecId());
            as2SpecClientConfig.setAs2From(as2Spec.getAs2From());
            as2SpecClientConfig.setAs2To(as2Spec.getAs2To());
            as2SpecClientConfig.setReceiptDeliveryOption(as2Spec.getMdnAsyncUrl());
            as2SpecClientConfig.setEncrypt(Boolean.getBoolean(as2Spec.getMessageEncrypted()));
            as2SpecClientConfig.setSign(Boolean.getBoolean(as2Spec.getMessageSigned()));
            as2SpecClientConfig.setContentType(as2Spec.getMimeType());
            as2SpecClientConfig.setSubject(as2Spec.getSubject());
            as2SpecClientConfig.setRequireSignedReceipt(Boolean.getBoolean(as2Spec.getMdnSigned()));
            as2SpecClientConfig.setFilename(as2Spec.getFilename());
            if (StringUtils.equalsIgnoreCase((String)as2Spec.getMdnRequired(), (String)"true")) {
                as2SpecClientConfig.setRequestReceipt(RequestReceipt.signed);
            } else if (StringUtils.equalsIgnoreCase((String)as2Spec.getMdnRequired(), (String)"false")) {
                as2SpecClientConfig.setRequestReceipt(RequestReceipt.unsigned);
            }
            if (StringUtils.equalsIgnoreCase((String)as2Spec.getMicAlgorithm(), (String)"sha1")) {
                as2SpecClientConfig.setMicAlgorithm(MicAlgorithmEnum.sha1);
            } else if (StringUtils.equalsIgnoreCase((String)as2Spec.getMicAlgorithm(), (String)"md5")) {
                as2SpecClientConfig.setMicAlgorithm(MicAlgorithmEnum.md5);
            }
            if (StringUtils.equalsIgnoreCase((String)as2Spec.getFallbackMicAlgorithm(), (String)"sha1")) {
                as2SpecClientConfig.setFallbackMicAlgorithm(MicAlgorithmOptionEnum.sha1);
            } else if (StringUtils.equalsIgnoreCase((String)as2Spec.getFallbackMicAlgorithm(), (String)"md5")) {
                as2SpecClientConfig.setFallbackMicAlgorithm(MicAlgorithmOptionEnum.md5);
            } else {
                as2SpecClientConfig.setFallbackMicAlgorithm(MicAlgorithmOptionEnum.none);
            }
        }
        return as2SpecClientConfig;
    }

    private ClientConfig buildConfigFromAs2SpecAndLocalClientConfig(ClientConfig as2SpecClientConfig, ClientConfig localClientConfig) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setAs2From(StringUtils.isEmpty((String)as2SpecClientConfig.getAs2From()) ? localClientConfig.getAs2From() : as2SpecClientConfig.getAs2From());
        clientConfig.setAs2To(StringUtils.isEmpty((String)as2SpecClientConfig.getAs2To()) ? localClientConfig.getAs2To() : as2SpecClientConfig.getAs2To());
        clientConfig.setReceiptDeliveryOption(StringUtils.isEmpty((String)as2SpecClientConfig.getReceiptDeliveryOption()) ? localClientConfig.getReceiptDeliveryOption() : as2SpecClientConfig.getReceiptDeliveryOption());
        clientConfig.setEncrypt(as2SpecClientConfig.getEncrypt() == null ? localClientConfig.getEncrypt() : as2SpecClientConfig.getEncrypt());
        clientConfig.setSign(as2SpecClientConfig.getSign() == null ? localClientConfig.getSign() : as2SpecClientConfig.getSign());
        clientConfig.setContentType(StringUtils.isEmpty((String)as2SpecClientConfig.getContentType()) ? localClientConfig.getContentType() : as2SpecClientConfig.getContentType());
        clientConfig.setSubject(StringUtils.isEmpty((String)as2SpecClientConfig.getSubject()) ? localClientConfig.getSubject() : as2SpecClientConfig.getSubject());
        clientConfig.setMicAlgorithm(as2SpecClientConfig.getMicAlgorithm() == null ? localClientConfig.getMicAlgorithm() : as2SpecClientConfig.getMicAlgorithm());
        clientConfig.setFallbackMicAlgorithm(as2SpecClientConfig.getFallbackMicAlgorithm() == null ? localClientConfig.getFallbackMicAlgorithm() : as2SpecClientConfig.getFallbackMicAlgorithm());
        clientConfig.setFilename(StringUtils.isEmpty((String)as2SpecClientConfig.getFilename()) ? localClientConfig.getFilename() : as2SpecClientConfig.getFilename());
        clientConfig.setRequestReceipt(as2SpecClientConfig.getRequestReceipt() == null ? localClientConfig.getRequestReceipt() : as2SpecClientConfig.getRequestReceipt());
        clientConfig.setRequireSignedReceipt(as2SpecClientConfig.getRequireSignedReceipt() == null ? localClientConfig.getRequireSignedReceipt() : as2SpecClientConfig.getRequireSignedReceipt());
        clientConfig.setAsyncReceiptTlsCertificateKeyStoreEntryAlias(localClientConfig.getAsyncReceiptTlsCertificateKeyStoreEntryAlias());
        clientConfig.setCompress(localClientConfig.getCompress());
        clientConfig.setContentTransferEncoding(localClientConfig.getContentTransferEncoding());
        clientConfig.setReceiptTimeout(localClientConfig.getReceiptTimeout());
        clientConfig.setReceiptVerificationCertificateKeyStoreEntryAlias(localClientConfig.getReceiptVerificationCertificateKeyStoreEntryAlias());
        clientConfig.setRequireSignedReceiptMicAlg(localClientConfig.getRequireSignedReceiptMicAlg());
        clientConfig.setHttpEndpointRef(localClientConfig.getHttpEndpointRef());
        clientConfig.setKeyStorePassword(localClientConfig.getKeyStorePassword());
        clientConfig.setKeyStorePath(localClientConfig.getKeyStorePath());
        return clientConfig;
    }
}

