/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import org.mule.api.security.tls.TlsConfiguration;
import org.mule.transport.tcp.TcpServerSocketFactory;
import org.mule.util.ArrayUtils;

class SslV2HelloEnabledSslServerSocketFactory
extends TcpServerSocketFactory {
    private TlsConfiguration tls;

    public SslV2HelloEnabledSslServerSocketFactory(TlsConfiguration tls) {
        this.tls = tls;
    }

    public ServerSocket createServerSocket(InetAddress address, int port, int backlog, Boolean reuse) throws IOException {
        try {
            KeyManager[] keyManagers = null == this.tls.getKeyManagerFactory() ? null : this.tls.getKeyManagerFactory().getKeyManagers();
            TrustManager[] trustManagers = null == this.tls.getTrustManagerFactory() ? null : this.tls.getTrustManagerFactory().getTrustManagers();
            SSLContext context = SSLContext.getInstance(this.tls.getSslType());
            context.init(keyManagers, trustManagers, null);
            SslV2HelloEnabledRestrictedSSLServerSocketFactory ssf = new SslV2HelloEnabledRestrictedSSLServerSocketFactory(context, this.tls.getEnabledCipherSuites(), this.tls.getEnabledProtocols());
            return this.configure(((ServerSocketFactory)ssf).createServerSocket(), reuse, new InetSocketAddress(address, port), backlog);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private class SslV2HelloEnabledRestrictedSSLServerSocketFactory
    extends SSLServerSocketFactory {
        private final SSLServerSocketFactory sslServerSocketFactory;
        private final String[] enabledCipherSuites;
        private final String[] enabledProtocols;
        private final String[] defaultCipherSuites;

        public SslV2HelloEnabledRestrictedSSLServerSocketFactory(SSLContext sslContext, String[] cipherSuites, String[] protocols) {
            this.sslServerSocketFactory = sslContext.getServerSocketFactory();
            if (cipherSuites == null) {
                cipherSuites = this.sslServerSocketFactory.getDefaultCipherSuites();
            }
            this.enabledCipherSuites = ArrayUtils.intersection((String[])cipherSuites, (String[])this.sslServerSocketFactory.getSupportedCipherSuites());
            this.defaultCipherSuites = ArrayUtils.intersection((String[])cipherSuites, (String[])this.sslServerSocketFactory.getDefaultCipherSuites());
            if (protocols == null) {
                protocols = sslContext.getDefaultSSLParameters().getProtocols();
            }
            this.enabledProtocols = ArrayUtils.intersection((String[])protocols, (String[])sslContext.getSupportedSSLParameters().getProtocols());
        }

        @Override
        public ServerSocket createServerSocket() throws IOException {
            return this.restrictCipherSuites((SSLServerSocket)this.sslServerSocketFactory.createServerSocket());
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.restrictCipherSuites((SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port));
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.restrictCipherSuites((SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog));
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            return this.restrictCipherSuites((SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog, ifAddress));
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.defaultCipherSuites;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.enabledCipherSuites;
        }

        private SSLServerSocket restrictCipherSuites(SSLServerSocket sslServerSocket) {
            sslServerSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            sslServerSocket.setEnabledProtocols(this.enabledProtocols);
            return sslServerSocket;
        }
    }
}

