/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.config;

import com.modus.mule.modules.as2.config.AS2ConnectorConfigDefinitionParser;
import com.modus.mule.modules.as2.config.ReceiveDefinitionParser;
import com.modus.mule.modules.as2.config.SendDefinitionParser;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class As2NamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(As2NamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [as2] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [as2] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new AS2ConnectorConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("send", (BeanDefinitionParser)new SendDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("send", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("receive", (BeanDefinitionParser)new ReceiveDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("receive", "@Source", ex);
        }
    }
}

