/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.filestorage.s3;

import com.modus.mule.modules.as2.filestorage.s3.AWS4SignerBase;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;

public class AWS4SignerForAuthorizationHeader
extends AWS4SignerBase {
    public AWS4SignerForAuthorizationHeader(URL endpointUrl, String httpMethod, String serviceName, String regionName) {
        super(endpointUrl, httpMethod, serviceName, regionName);
    }

    public String computeSignature(Map<String, String> headers, Map<String, String> queryParameters, String bodyHash, String awsAccessKey, String awsSecretKey) {
        Date now = new Date();
        String dateTimeStamp = this.dateTimeFormat.format(now);
        headers.put("x-amz-date", dateTimeStamp);
        String hostHeader = this.endpointUrl.getHost();
        int port = this.endpointUrl.getPort();
        if (port > -1) {
            hostHeader.concat(":" + Integer.toString(port));
        }
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AWS4SignerForAuthorizationHeader.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AWS4SignerForAuthorizationHeader.getCanonicalizedHeaderString(headers);
        String canonicalizedQueryParameters = AWS4SignerForAuthorizationHeader.getCanonicalizedQueryString(queryParameters);
        String canonicalRequest = AWS4SignerForAuthorizationHeader.getCanonicalRequest(this.endpointUrl, this.httpMethod, canonicalizedQueryParameters, canonicalizedHeaderNames, canonicalizedHeaders, bodyHash);
        String dateStamp = this.dateStampFormat.format(now);
        String scope = dateStamp + "/" + this.regionName + "/" + this.serviceName + "/" + "aws4_request";
        String stringToSign = AWS4SignerForAuthorizationHeader.getStringToSign("AWS4", "HMAC-SHA256", dateTimeStamp, scope, canonicalRequest);
        byte[] kSecret = ("AWS4" + awsSecretKey).getBytes(Charset.forName("UTF-8"));
        byte[] kDate = AWS4SignerForAuthorizationHeader.sign(dateStamp, kSecret, "HmacSHA256");
        byte[] kRegion = AWS4SignerForAuthorizationHeader.sign(this.regionName, kDate, "HmacSHA256");
        byte[] kService = AWS4SignerForAuthorizationHeader.sign(this.serviceName, kRegion, "HmacSHA256");
        byte[] kSigning = AWS4SignerForAuthorizationHeader.sign("aws4_request", kService, "HmacSHA256");
        byte[] signature = AWS4SignerForAuthorizationHeader.sign(stringToSign, kSigning, "HmacSHA256");
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + "/" + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + AWS4SignerForAuthorizationHeader.toHex(signature);
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        return authorizationHeader;
    }
}

