/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.filestorage.s3;

import com.modus.mule.modules.as2.GlobalContext;
import com.modus.mule.modules.as2.common.AS2ConnectorException;
import com.modus.mule.modules.as2.filestorage.FileStorageService;
import com.modus.mule.modules.as2.filestorage.OnUploadCompleteCallback;
import com.modus.mule.modules.as2.filestorage.s3.AWS4SignerBase;
import com.modus.mule.modules.as2.filestorage.s3.AWS4SignerForAuthorizationHeader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.log4j.Logger;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.IOUtils;
import org.mule.util.UUID;

public class S3FileStorageService
implements FileStorageService {
    private String awsAccessKey;
    private String awsSecretKey;
    private CloseableHttpAsyncClient httpAsyncClient;
    private CloseableHttpClient httpClient;
    private String bucketName;
    private static final Logger logger = Logger.getLogger(S3FileStorageService.class);

    public S3FileStorageService(String awsAccessKey, String awsSecretKey, String bucketName) {
        this.awsAccessKey = awsAccessKey;
        this.awsSecretKey = awsSecretKey;
        this.httpAsyncClient = GlobalContext.getInstance().getHttpAsyncClient();
        this.httpClient = GlobalContext.getInstance().getHttpClient();
        this.bucketName = bucketName;
    }

    @Override
    public void store(byte[] file, final OnUploadCompleteCallback onUploadCompleteCallback) {
        final HttpPut httpPut = this.buildPutRequest(file);
        this.httpAsyncClient.execute(httpPut, new FutureCallback<HttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(HttpResponse httpResponse) {
                try {
                    if (httpResponse.getStatusLine().getStatusCode() >= 200 && httpResponse.getStatusLine().getStatusCode() < 300) {
                        onUploadCompleteCallback.completed(httpPut.getURI().toString());
                    } else {
                        S3FileStorageService.this.logUploadError(httpResponse);
                        onUploadCompleteCallback.failed(new Exception());
                    }
                }
                finally {
                    S3FileStorageService.this.closeHttpStream(httpResponse);
                }
            }

            @Override
            public void failed(Exception e) {
                onUploadCompleteCallback.failed(e);
            }

            @Override
            public void cancelled() {
                logger.error((Object)"File record operation cancelled");
            }
        });
    }

    @Override
    public String store(byte[] file) throws Exception {
        HttpPut httpPut = this.buildPutRequest(file);
        CloseableHttpResponse httpResponse = this.httpClient.execute(httpPut);
        try {
            if (httpResponse.getStatusLine().getStatusCode() >= 200 && httpResponse.getStatusLine().getStatusCode() < 300) {
                String string = httpPut.getURI().toString();
                return string;
            }
            this.logUploadError(httpResponse);
            throw new AS2ConnectorException(MessageFactory.createStaticMessage((String)"Failed to record file"));
        }
        finally {
            this.closeHttpStream(httpResponse);
        }
    }

    private HttpPut buildPutRequest(byte[] file) {
        URL endpointUrl;
        String url = "http://s3.amazonaws.com/" + this.bucketName + "/" + UUID.getUUID() + ".dat";
        try {
            endpointUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to parse service endpoint: " + e.getMessage());
        }
        byte[] contentHash = AWS4SignerBase.hash(file);
        String contentHashString = AWS4SignerBase.toHex(contentHash);
        HashMap<String, String> headers = new HashMap<String, String>();
        AWS4SignerForAuthorizationHeader signer = new AWS4SignerForAuthorizationHeader(endpointUrl, "PUT", "s3", "us-east-1");
        String authorization = signer.computeSignature(headers, null, contentHashString, this.awsAccessKey, this.awsSecretKey);
        HttpPut httpPut = new HttpPut(url);
        httpPut.setEntity(new ByteArrayEntity(file));
        httpPut.setHeader("Authorization", authorization);
        httpPut.setHeader("x-amz-content-sha256", contentHashString);
        httpPut.setHeader("x-amz-date", (String)headers.get("x-amz-date"));
        return httpPut;
    }

    private void logUploadError(HttpResponse httpResponse) {
        try {
            logger.error((Object)("Failed to record file. The HTTP status code is: " + httpResponse.getStatusLine().getStatusCode() + ". The reply's content is: \n\n" + IOUtils.toString((InputStream)httpResponse.getEntity().getContent())));
        }
        catch (IOException e) {
            logger.error((Object)("Failed to record file. The HTTP status code is: " + httpResponse.getStatusLine().getStatusCode() + ". Could not log the reply's content due"), (Throwable)e);
        }
    }

    private void closeHttpStream(HttpResponse httpResponse) {
        try {
            httpResponse.getEntity().getContent().close();
        }
        catch (IOException e) {
            logger.error((Object)"An error occurred while closing HTTP stream", (Throwable)e);
        }
    }
}

