/*
 * Decompiled with CFR 0.152.
 */
package com.modus.mule.modules.as2.messagetracker;

import com.modus.mule.modules.as2.messagetracker.As2Transmission;
import com.modus.mule.modules.as2.messagetracker.Callback;
import com.modus.mule.modules.as2.messagetracker.MessageTracker;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.mule.api.MuleContext;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;

public class MemoryMessageTracker
implements MessageTracker {
    private static final Logger logger = Logger.getLogger(MemoryMessageTracker.class);
    private ObjectStore<As2Transmission> objectStore;

    public MemoryMessageTracker(MuleContext muleContext) {
        this.objectStore = muleContext.getObjectStoreManager().getObjectStore("messageTrackerMemoryObjectStore", false, 0, 600000, 60000);
    }

    @Override
    public void create(As2Transmission as2Transmission, Callback<As2Transmission> callback) throws Exception {
        if (as2Transmission.getAs2MessageId() != null) {
            try {
                this.objectStore.store((Serializable)((Object)as2Transmission.getAs2MessageId()), (Serializable)as2Transmission);
            }
            catch (ObjectAlreadyExistsException e) {
                logger.warn((Object)"A record of the transmission already exists", (Throwable)e);
            }
        } else {
            logger.warn((Object)"Could not record message since AS2 Message-ID is null");
        }
        callback.completed();
    }

    @Override
    public void create(As2Transmission as2Transmission) throws ObjectStoreException {
        if (as2Transmission.getAs2MessageId() != null) {
            try {
                this.objectStore.store((Serializable)((Object)as2Transmission.getAs2MessageId()), (Serializable)as2Transmission);
            }
            catch (ObjectAlreadyExistsException e) {
                logger.warn((Object)"A record of the transmission already exists", (Throwable)e);
            }
        } else {
            logger.warn((Object)"Could not record message since AS2 Message-ID is null");
        }
    }

    @Override
    public void update(As2Transmission as2Transmission, Callback<As2Transmission> callback) throws Exception {
        As2Transmission recordAs2Transmission = (As2Transmission)this.objectStore.retrieve((Serializable)((Object)as2Transmission.getAs2MessageId()));
        if (as2Transmission.getAs2From() != null) {
            recordAs2Transmission.setAs2From(as2Transmission.getAs2From());
        }
        if (as2Transmission.getAs2MessageId() != null) {
            recordAs2Transmission.setAs2MessageId(as2Transmission.getAs2MessageId());
        }
        if (as2Transmission.getAs2To() != null) {
            recordAs2Transmission.setAs2To(as2Transmission.getAs2To());
        }
        if (as2Transmission.getContentType() != null) {
            recordAs2Transmission.setContentType(as2Transmission.getContentType());
        }
        if (as2Transmission.getFilename() != null) {
            recordAs2Transmission.setFilename(as2Transmission.getFilename());
        }
        if (as2Transmission.getHomePartyRole() != null) {
            recordAs2Transmission.setHomePartyRole(as2Transmission.getHomePartyRole());
        }
        if (as2Transmission.getId() != null) {
            recordAs2Transmission.setId(as2Transmission.getId());
        }
        if (as2Transmission.getIsMDNAsync() != null) {
            recordAs2Transmission.setIsMDNAsync(as2Transmission.getIsMDNAsync());
        }
        if (as2Transmission.getIsMDNExpected() != null) {
            recordAs2Transmission.setIsMDNExpected(as2Transmission.getIsMDNExpected());
        }
        if (as2Transmission.getIsMDNSigned() != null) {
            recordAs2Transmission.setIsMDNSigned(as2Transmission.getIsMDNSigned());
        }
        if (as2Transmission.getIsMessageEncrypted() != null) {
            recordAs2Transmission.setIsMessageEncrypted(as2Transmission.getIsMessageEncrypted());
        }
        if (as2Transmission.getMdnContent() != null) {
            recordAs2Transmission.setMdnContent(as2Transmission.getMdnContent());
        }
        if (as2Transmission.getMdnStatus() != null) {
            recordAs2Transmission.setMdnStatus(as2Transmission.getMdnStatus());
        }
        if (as2Transmission.getMessageDateTime() != null) {
            recordAs2Transmission.setMessageDateTime(as2Transmission.getMessageDateTime());
        }
        if (as2Transmission.getMessageMicValue() != null) {
            recordAs2Transmission.setMessageMicValue(as2Transmission.getMessageMicValue());
        }
        if (as2Transmission.getReceivedDateTime() != null) {
            recordAs2Transmission.setReceivedDateTime(as2Transmission.getReceivedDateTime());
        }
        if (as2Transmission.getTransmissionError() != null) {
            recordAs2Transmission.setTransmissionError(as2Transmission.getTransmissionError());
        }
        if (as2Transmission.getTransmissionStatus() != null) {
            recordAs2Transmission.setTransmissionStatus(as2Transmission.getTransmissionStatus());
        }
        if (as2Transmission.getAgreementId() != null) {
            recordAs2Transmission.setAgreementId(as2Transmission.getAgreementId());
        }
    }

    @Override
    public void get(As2Transmission as2Transmission, Callback<As2Transmission> callback) throws Exception {
        callback.completed((As2Transmission)this.objectStore.retrieve((Serializable)((Object)as2Transmission.getAs2MessageId())));
    }

    @Override
    public As2Transmission get(As2Transmission as2Transmission) throws Exception {
        return (As2Transmission)this.objectStore.retrieve((Serializable)((Object)as2Transmission.getAs2MessageId()));
    }
}

